/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.hooks;

import com.ldtteam.blockui.hooks.HookScreen;
import com.ldtteam.blockui.hooks.HookWindow;
import com.ldtteam.blockui.hooks.IGuiActionCallback;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.ldtteam.blockui.mod.Log;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class HookManager<T, U, K> {
    private static HookScreen scrollListener;
    private final List<HookEntry> registry = new ArrayList<HookEntry>();
    private final Map<K, WindowEntry> activeWindows = new HashMap<K, WindowEntry>();
    private final IForgeRegistry<U> typeRegistryReference;

    protected HookManager(IForgeRegistry<U> typeRegistryReference) {
        this.typeRegistryReference = typeRegistryReference;
    }

    protected void registerInternal(U targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, BiPredicate<? extends T, TriggerMechanism> shouldOpen, IGuiActionCallback<? extends T> onOpen, IGuiActionCallback<? extends T> onClose) {
        Objects.requireNonNull(targetThing, "Target can't be null!");
        Objects.requireNonNull(guiLoc, "Gui location can't be null!");
        Objects.requireNonNull(trigger, "Trigger can't be null!");
        BiPredicate<Object, TriggerMechanism> shouldOpenTest = Objects.requireNonNullElse(shouldOpen, (t, tt) -> true);
        IGuiActionCallback onOpenListener = Objects.requireNonNullElse(onOpen, IGuiActionCallback.noAction());
        IGuiActionCallback onClosedListener = Objects.requireNonNullElse(onClose, IGuiActionCallback.noAction());
        ResourceLocation registryKey = this.typeRegistryReference.getKey(targetThing);
        Optional<HookEntry> existing = this.registry.stream().filter(hook -> hook.getTargetThingRegistryKey().equals((Object)registryKey) && hook.trigger.getClass() == trigger.getClass()).findFirst();
        if (existing.isPresent()) {
            Log.getLogger().debug("Moving \"{}\" hook (with trigger \"{}\") from \"{}\" to \"{}\"", (Object)registryKey, (Object)existing.get().trigger.getName(), (Object)existing.get().guiLoc, (Object)guiLoc);
            this.registry.remove(existing.get());
        }
        this.registry.add(new HookEntry(targetThing, guiLoc, expirationTime, trigger, shouldOpenTest, onOpenListener, onClosedListener));
    }

    public boolean unregister(ResourceLocation resLoc) {
        return this.registry.removeIf(hook -> hook.getTargetThingRegistryKey().equals((Object)resLoc));
    }

    public boolean unregister(U thing) {
        return this.unregister(this.typeRegistryReference.getKey(thing));
    }

    public boolean unregister(ResourceLocation resLoc, TriggerMechanism triggerType) {
        return this.registry.removeIf(hook -> hook.getTargetThingRegistryKey().equals((Object)resLoc) && hook.trigger.getClass() == triggerType.getClass());
    }

    public boolean unregister(U thing, TriggerMechanism triggerType) {
        return this.unregister(this.typeRegistryReference.getKey(thing), triggerType);
    }

    protected abstract List<T> findTriggered(U var1, TriggerMechanism var2);

    protected abstract K keyMapper(T var1);

    protected abstract void translateToGuiBottomCenter(PoseStack var1, T var2, float var3);

    protected void tick(long ticks) {
        long now = System.currentTimeMillis();
        this.registry.forEach(hook -> {
            if (hook.trigger.canTick(ticks)) {
                this.findTriggered(hook.targetThing, hook.trigger).forEach(thing -> {
                    K key = this.keyMapper(thing);
                    WindowEntry entry = this.activeWindows.get(key);
                    if ((entry == null || entry.hook.trigger.isLowerPriority(hook.trigger)) && hook.shouldOpen.test(thing, hook.trigger)) {
                        if (entry != null) {
                            entry.screen.m_7861_();
                        }
                        WindowEntry window = new WindowEntry(now, thing, (HookEntry)hook, HookWindow::new);
                        this.activeWindows.put(key, window);
                        window.screen.m_6575_(Minecraft.m_91087_(), window.screen.getWindow().getWidth(), window.screen.getWindow().getHeight());
                    } else if (entry != null) {
                        entry.lastTimeAccessed = now;
                    }
                });
            }
        });
        this.activeWindows.values().removeIf(entry -> {
            if (entry.hook.trigger.canTick(ticks) && now - entry.lastTimeAccessed > entry.hook.expirationTime) {
                entry.screen.m_7861_();
                return true;
            }
            entry.screen.m_86600_();
            return false;
        });
    }

    protected void render(PoseStack ms, float partialTicks) {
        this.activeWindows.values().forEach(entry -> {
            ms.m_85836_();
            this.translateToGuiBottomCenter(ms, entry.thing, partialTicks);
            ms.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
            ms.m_85841_(-0.01f, -0.01f, 0.01f);
            entry.screen.render(ms);
            ms.m_85849_();
        });
    }

    public static boolean onScroll(double scrollDelta) {
        if (scrollListener != null) {
            return scrollListener.mouseScrolled(scrollDelta);
        }
        return false;
    }

    public static HookScreen getScrollListener() {
        return scrollListener;
    }

    public static void setScrollListener(HookScreen scrollListener) {
        HookManager.scrollListener = scrollListener;
    }

    protected class HookEntry {
        protected final U targetThing;
        protected final ResourceLocation guiLoc;
        protected final long expirationTime;
        protected final TriggerMechanism trigger;
        protected final BiPredicate<T, TriggerMechanism> shouldOpen;
        protected final IGuiActionCallback<T> onOpen;
        protected final IGuiActionCallback<T> onClose;

        private HookEntry(U targetThing, ResourceLocation guiLoc, long expirationTime, TriggerMechanism trigger, BiPredicate<T, TriggerMechanism> shouldOpen, IGuiActionCallback<T> onOpen, IGuiActionCallback<T> onClose) {
            this.targetThing = targetThing;
            this.guiLoc = guiLoc;
            this.expirationTime = expirationTime;
            this.trigger = trigger;
            this.shouldOpen = shouldOpen;
            this.onOpen = onOpen;
            this.onClose = onClose;
        }

        public ResourceLocation getTargetThingRegistryKey() {
            return HookManager.this.typeRegistryReference.getKey(this.targetThing);
        }
    }

    protected class WindowEntry {
        private long lastTimeAccessed = 0L;
        protected final T thing;
        protected final HookEntry hook;
        protected final HookScreen screen;

        public WindowEntry(long lastTimeAccessed, T thing, HookEntry hook, Function<WindowEntry, HookWindow<T, U>> windowFactory) {
            this.lastTimeAccessed = lastTimeAccessed;
            this.thing = thing;
            this.hook = hook;
            this.screen = windowFactory.apply(this).getScreen();
        }
    }
}

