/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.network;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.common.dataattachment.AccessoryContainer;
import com.swacky.ohmega.common.inv.AccessoryInventoryMenu;
import com.swacky.ohmega.event.OhmegaHooks;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.OpenInventoryPacket;
import com.swacky.ohmega.network.C2S.ResizeContainerPacket;
import com.swacky.ohmega.network.C2S.UseAccessoryPacket;
import com.swacky.ohmega.network.OhmegaNetworking;
import com.swacky.ohmega.network.S2C.SyncAccessorySlotsPacket;
import com.swacky.ohmega.network.S2C.SyncAccessoryTypesPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class OhmegaNetworkingImpl {

    public static final class S2C
    implements OhmegaNetworking.S2C.Service {
        @Override
        public void send(ServerPlayer receiver, CustomPacketPayload packet) {
            PacketDistributor.sendToPlayer((ServerPlayer)receiver, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }

        public static void handleSyncAccessorySlots(SyncAccessorySlotsPacket packet, IPayloadContext context) {
            if (packet.indexes().length == 0) {
                return;
            }
            context.enqueueWork(() -> {
                Entity patt0$temp;
                ClientLevel level = Minecraft.getInstance().level;
                if (level != null && (patt0$temp = level.getEntity(packet.playerId())) instanceof Player) {
                    Player player = (Player)patt0$temp;
                    AccessoryHelper.getContainer(player).syncSlots(player, packet.indexes(), packet.stacks());
                }
            });
        }

        public static void handleSyncAccessoryTypes(SyncAccessoryTypesPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> AccessoryTypeManager.getInstance().apply(packet.types));
        }
    }

    public static final class C2S
    implements OhmegaNetworking.C2S.Service {
        @Override
        public void send(CustomPacketPayload packet) {
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            if (connection == null) {
                throw new NullPointerException("Minecraft#getConnection returned a null pointer");
            }
            connection.send(packet);
        }

        public static void handleOpenAccessoryInventory(OpenAccessoryInventoryPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    ItemStack stack = player.containerMenu.getCarried();
                    if (!stack.isEmpty()) {
                        AbstractContainerMenu.dropOrPlaceInInventory((Player)player, (ItemStack)stack);
                        player.containerMenu.setCarried(ItemStack.EMPTY);
                    }
                    player.containerMenu.removed((Player)player);
                    player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, player0) -> new AccessoryInventoryMenu(id, inv), (Component)Component.empty()));
                }
            });
        }

        public static void handleOpenInventory(OpenInventoryPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    player.doCloseContainer();
                }
            });
        }

        public static void handleResizeContainer(ResizeContainerPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    AccessoryHelper.getContainer((Player)player).reloadCfg((Player)player);
                }
            });
        }

        public static void handleUseAccessory(UseAccessoryPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                ItemStack stack;
                Player player;
                AccessoryContainer container;
                IAccessory accessory;
                if (packet.slot() < AccessoryHelper.getSlotTypes().size() && (accessory = AccessoryHelper.getBoundAccessory((container = AccessoryHelper.getContainer(player = context.player())).getStackInSlot(packet.slot()).getItem())) != null && !OhmegaHooks.accessoryUseEvent(player, stack = container.getStackInSlot(packet.slot()))) {
                    accessory.onUse(player, stack);
                }
            });
        }
    }
}

