/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.mixin;

import com.swacky.ohmega.api.AccessoryHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
abstract class EnchantmentHelperMixin {
    @Unique
    private static final EquipmentSlot[] HUMANOID_ARMOUR = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD};

    EnchantmentHelperMixin() {
    }

    @Inject(method={"getRandomItemWith"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getRandomItemWith(DataComponentType<?> dataType, LivingEntity entity, Predicate<ItemStack> filter, CallbackInfoReturnable<Optional<EnchantedItemInUse>> cir) {
        int original = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = entity.getItemBySlot(slot);
            if (!filter.test(stack)) continue;
            for (Holder holder : ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet()) {
                Enchantment enchantment = (Enchantment)holder.value();
                if (!enchantment.effects().has(dataType) || !enchantment.matchingSlot(slot)) continue;
                ++original;
            }
        }
        ArrayList<EnchantedItemInUse> list = new ArrayList<EnchantedItemInUse>();
        if (entity instanceof Player) {
            RandomSource random;
            Player player = (Player)entity;
            for (ItemStack stack : AccessoryHelper.getStacks(player)) {
                if (!filter.test(stack)) continue;
                for (Holder holder : ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet()) {
                    Enchantment enchantment = (Enchantment)holder.value();
                    if (!enchantment.effects().has(dataType) || !EnchantmentHelperMixin.ohmega$checkSlots(enchantment.definition().slots())) continue;
                    list.add(new EnchantedItemInUse(stack, EquipmentSlot.MAINHAND, entity));
                }
            }
            if (!list.isEmpty() && (random = entity.getRandom()).nextInt(list.size() + original) >= original) {
                cir.setReturnValue((Object)Util.getRandomSafe(list, (RandomSource)random));
            }
        }
    }

    @Unique
    private static boolean ohmega$checkSlots(List<EquipmentSlotGroup> groups) {
        for (EquipmentSlotGroup group : groups) {
            for (EquipmentSlot slot : HUMANOID_ARMOUR) {
                if (!group.test(slot)) continue;
                return true;
            }
        }
        return false;
    }
}

