/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.event;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.event.CommonCallbacks;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.OpenInventoryPacket;
import com.swacky.ohmega.network.C2S.ResizeContainerPacket;
import com.swacky.ohmega.network.C2S.UseAccessoryPacket;
import com.swacky.ohmega.network.OhmegaNetworkingImpl;
import com.swacky.ohmega.network.S2C.SyncAccessorySlotsPacket;
import com.swacky.ohmega.network.S2C.SyncAccessoryTypesPacket;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.configuration.ICustomConfigurationTask;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.MainThreadPayloadHandler;
import org.jspecify.annotations.NonNull;

@EventBusSubscriber(modid="ohmega")
public final class CommonEvents {
    private static final ResourceLocation RELOAD_LISTENER_ID = OhmegaCommon.rl("accessory_type_manager");
    private static final ConfigurationTask.Type TYPE = new ConfigurationTask.Type(OhmegaCommon.rl("sync_accessory_types"));

    @SubscribeEvent
    public static void onClonePlayer(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        if (!event.isWasDeath() || CommonCallbacks.shouldKeepInventory(oldPlayer)) {
            Player newPlayer = event.getEntity();
            CommonCallbacks.onClonePlayer(oldPlayer, newPlayer);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        InteractionResult result = AccessoryHelper.tryEquip(event.getEntity(), event.getHand());
        event.setCancellationResult(result);
        if (result == InteractionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            AccessoryHelper.getContainer((Player)player).onDeath(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AccessoryHelper.syncAllSlots(player2, Collections.singleton(player2));
        }
    }

    @SubscribeEvent
    public static void onPlayerPostTick(PlayerTickEvent.Post event) {
        CommonCallbacks.onPlayerPostTick(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerTrack(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer tracked = (ServerPlayer)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer tracker = (ServerPlayer)entity;
                CommonCallbacks.onPlayerTrack(tracker, tracked);
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterConfigTasks(final RegisterConfigurationTasksEvent event) {
        event.register((ConfigurationTask)new ICustomConfigurationTask(){

            public void run(@NonNull Consumer<CustomPacketPayload> consumer) {
                consumer.accept(new SyncAccessoryTypesPacket());
                event.getListener().finishCurrentTask(TYPE);
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @NonNull ConfigurationTask.Type type() {
                return TYPE;
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterNetwork(RegisterPayloadHandlersEvent event) {
        event.registrar("1.0").playToServer(OpenAccessoryInventoryPacket.TYPE, OpenAccessoryInventoryPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.C2S::handleOpenAccessoryInventory)).playToServer(OpenInventoryPacket.TYPE, OpenInventoryPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.C2S::handleOpenInventory)).playToServer(ResizeContainerPacket.TYPE, ResizeContainerPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.C2S::handleResizeContainer)).playToServer(UseAccessoryPacket.TYPE, UseAccessoryPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.C2S::handleUseAccessory)).playToClient(SyncAccessorySlotsPacket.TYPE, SyncAccessorySlotsPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.S2C::handleSyncAccessorySlots)).configurationToClient(SyncAccessoryTypesPacket.TYPE, SyncAccessoryTypesPacket.CODEC, (IPayloadHandler)new MainThreadPayloadHandler(OhmegaNetworkingImpl.S2C::handleSyncAccessoryTypes));
    }

    @SubscribeEvent
    public static void onRegisterServerReloadListeners(AddServerReloadListenersEvent event) {
        event.addListener(RELOAD_LISTENER_ID, (PreparableReloadListener)AccessoryTypeManager.getInstance());
    }
}

