/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.event;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.client.screen.AccessoryInventoryButton;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.common.dataattachment.AccessoryContainer;
import com.swacky.ohmega.common.init.OhmegaBinds;
import com.swacky.ohmega.common.inv.AccessoryInventoryMenu;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.event.OhmegaHooks;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.ResizeContainerPacket;
import com.swacky.ohmega.network.C2S.UseAccessoryPacket;
import com.swacky.ohmega.network.OhmegaNetworking;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public final class ClientCallbacks {
    public static void onClientConfigReload() {
        LocalPlayer player;
        if (!OhmegaConfig.Client.compatibilityMode() && (player = Minecraft.getInstance().player) != null && player.containerMenu instanceof AccessoryInventoryMenu) {
            OhmegaNetworking.C2S.send(OpenAccessoryInventoryPacket.INSTANCE);
        }
    }

    public static void onItemTooltip(ItemStack stack, List<Component> tooltip) {
        MutableComponent component;
        if (AccessoryHelper.isItemAccessoryBound(stack.getItem()) && (component = AccessoryHelper.getTypeTooltip(stack.getItem())) != null) {
            tooltip.add((Component)component);
        }
    }

    public static void onKeyInput() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen == null && mc.player != null) {
            while (OhmegaBinds.OPEN_ACC_INV.consumeClick() && (mc.player.portalProcess == null || !mc.player.portalProcess.isInsidePortalThisTick())) {
                if (mc.gameMode != null && mc.gameMode.isServerControlledInventory()) {
                    mc.player.sendOpenInventory();
                    continue;
                }
                if (!mc.player.isCreative() && !mc.player.isSpectator()) {
                    OhmegaNetworking.C2S.send(OpenAccessoryInventoryPacket.INSTANCE);
                    continue;
                }
                mc.setScreen((Screen)new InventoryScreen((Player)mc.player));
            }
            ImmutableList<KeyMapping> mappings = OhmegaBinds.Generated.getMappings();
            ImmutableList<AccessoryType> keyboundSlotTypes = AccessoryHelper.getKeyboundSlotTypes();
            ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();
            if (mappings.isEmpty() || keyboundSlotTypes.isEmpty() || slotTypes.isEmpty()) {
                return;
            }
            AccessoryContainer container = AccessoryHelper.getContainer((Player)mc.player);
            for (int i = 0; i < OhmegaBinds.Generated.size(); ++i) {
                KeyMapping mapping = (KeyMapping)mappings.get(i);
                int j = 0;
                if (!mapping.consumeClick()) continue;
                int k = 1;
                while (!keyboundSlotTypes.contains(slotTypes.get(j)) || k++ <= i) {
                    ++j;
                }
                ItemStack stack = container.getStackInSlot(j);
                IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
                if (accessory == null) continue;
                if (!OhmegaHooks.accessoryUseEvent((Player)mc.player, stack)) {
                    accessory.onUse((Player)mc.player, stack);
                }
                OhmegaNetworking.C2S.send(new UseAccessoryPacket(j));
            }
        }
    }

    public static void onPostScreenInit(Screen screen, Consumer<AbstractWidget> widgetConsumer) {
        Minecraft mc;
        if (screen instanceof InventoryScreen && OhmegaConfig.Client.buttonStyle() != OhmegaConfig.Client.Service.ButtonStyle.HIDDEN && (mc = screen.minecraft) != null && mc.player != null && !mc.player.isCreative() && !mc.player.isSpectator()) {
            widgetConsumer.accept((AbstractWidget)new AccessoryInventoryButton(OhmegaConfig.Client.buttonStyle(), (AbstractContainerScreen)screen));
        }
    }

    public static void onServerConfigLoad(Runnable loadFunction) {
        ArrayList list = new ArrayList();
        for (ImmutableList immutableList : OhmegaBinds.Generated.getSlotKeys().values()) {
            list.addAll(immutableList);
        }
        Options options = Minecraft.getInstance().options;
        options.keyMappings = (KeyMapping[])ArrayUtils.addAll((Object[])Arrays.stream(options.keyMappings).filter(v -> !OhmegaBinds.isInstance(v)).toList().toArray(new KeyMapping[0]), (Object[])list.toArray(new KeyMapping[0]));
        loadFunction.run();
    }

    public static void onServerConfigReload(Runnable loadFunction) {
        ClientCallbacks.onServerConfigLoad(loadFunction);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            AccessoryHelper.getContainer((Player)player).reloadCfg((Player)player);
            OhmegaNetworking.C2S.send(ResizeContainerPacket.INSTANCE);
            if (!OhmegaConfig.Client.compatibilityMode() && player.containerMenu instanceof AccessoryInventoryMenu) {
                mc.screen = null;
                player.connection.send((Packet)new ServerboundContainerClosePacket(player.containerMenu.containerId));
                OhmegaNetworking.C2S.send(OpenAccessoryInventoryPacket.INSTANCE);
            }
        }
    }

    public static void onServerConfigUnload(Runnable loadFunction) {
        AccessoryTypeManager.getInstance().clear();
        Minecraft mc = Minecraft.getInstance();
        mc.options.keyMappings = Arrays.stream(mc.options.keyMappings).filter(v -> !OhmegaBinds.isInstance(v)).toList().toArray(new KeyMapping[0]);
        loadFunction.run();
    }
}

