/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.datagen.client.lang;

import com.swacky.ohmega.api.datagen.OhmegaLangHelper;
import com.swacky.ohmega.common.init.OhmegaItems;
import com.swacky.ohmega.datagen.client.lang.InternalLangHelper;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class OhmegaEnUsProvider
extends LanguageProvider {
    public OhmegaEnUsProvider(PackOutput output) {
        super(output, "ohmega", "en_us");
    }

    protected void addTranslations() {
        InternalLangHelper internalHelper = new InternalLangHelper(this);
        internalHelper.addDataPackDescription("Mod resources for Ohmega");
        OhmegaLangHelper helper = new OhmegaLangHelper((arg_0, arg_1) -> ((OhmegaEnUsProvider)this).add(arg_0, arg_1), "ohmega");
        helper.addKeyboundItem((Item)OhmegaItems.ANGEL_RING.get(), "Angel Ring", "Allows the wearer to fly", "Press %s to toggle flight");
        this.add("accessory_type", "Accessory Type: %s");
        helper.addType("generic", "Generic");
        helper.addType("normal", "Normal");
        helper.addType("utility", "Utility");
        helper.addType("special", "Special");
        this.add("key.category.ohmega.ohmega", "Ohmega");
        this.add("key.ohmega.open_acc_inv", "Open/Close Accessories Inventory");
        internalHelper.addConfig("title", "Ohmega Config");
        internalHelper.addConfigSection("client.toml", "Ohmega Client", "Ohmega Client Config");
        internalHelper.addConfigOption("compatibilityMode", "Compatibility Mode", "Disables some useful yet mostly unnoticeable features that may improve mod compatibility in rare cases");
        internalHelper.addConfigOption("buttonStyle", "Button Style", "Style of the accessory inventory button\nDEFAULT: The normal Ohmega button style\nLEGACY: A curios/baubles inspired button that renders next to the inventory player model\nTAG: A small tag-like button appearing just off the top corner of the inventory\nHIDDEN: Will not show, use the dedicated keybind to open the accessory inventory instead");
        internalHelper.addConfigOption("inventorySide", "Inventory Side", "The side of the inventory that the accessory inventory will be placed");
        internalHelper.addConfigOption("showHoverTooltip", "Show Hover Tooltip", "If true, will display a tooltip box of the type of accessory slot when it is hovered over");
        internalHelper.addConfigOption("maxColumns", "Max Columns", "The maximum columns to render");
        internalHelper.addConfigOption("maxColumnSlots", "Max Column Slots", "The maximum amount of slots per column\nIf exceeded, a new column will be made if it does not exceed \"maxColumns\"");
        internalHelper.addConfigOption("maxColumnRenderSlots", "Max Column Render Slots", "The maximum amount of slots to render per column");
        internalHelper.addConfigSection("server.toml", "Ohmega Server", "Ohmega Server Config");
        internalHelper.addConfigOption("slotTypes", "Slot Types", "Defines the types and number of slots in the accessory inventory");
        internalHelper.addConfigButton("slotTypes", "Edit");
        internalHelper.addConfigOption("keyboundSlotTypes", "Key-bound Slot Types", "Defines the types of accessories that can be key-bound");
        internalHelper.addConfigButton("keyboundSlotTypes", "Edit");
        internalHelper.addConfigOption("keepAccessoriesBehaviour", "Keep Accessories Behaviour", "Defines how to handle player death in terms of dropping accessories\nDEFAULT: Uses the vanilla \"keepInventory\" game-rule\nALWAYS_ON: Will never drop accessories on death\nALWAYS_OFF: Will always drop accessories on death");
        internalHelper.addConfigOption("disableAccessoryTypes", "Disable Accessory Types", "If true, effectively no accessory types will be used, and they will all be overridden, changing them all to \"ohmega:generic\"");
    }
}

