/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.config;

import com.swacky.ohmega.config.OhmegaConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jspecify.annotations.NonNull;

public final class OhmegaConfigImpl {

    public static final class Server
    implements OhmegaConfig.Server.Service {
        private static ModConfigSpec spec;
        public ModConfigSpec.ConfigValue<List<? extends String>> slotTypes;
        public ModConfigSpec.ConfigValue<List<? extends String>> keyboundSlotTypes;
        public // Could not load outer class - annotation placement on inner may be incorrect
        ModConfigSpec.EnumValue<@NonNull OhmegaConfig.Server.Service.KeepAccessoriesBehaviour> keepAccessoriesBehaviour;
        public ModConfigSpec.BooleanValue disableAccessoryTypes;

        public Server() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.slotTypes = builder.comment("Defines the types and number of slots in the accessory inventory").defineList("slotTypes", SLOT_TYPES_DEFAULT, () -> SLOT_TYPES_NEW_VALUE_DEFAULT, ACCESSORY_TYPE_VALIDATOR);
            this.keyboundSlotTypes = builder.comment("Defines the types of accessories that can be key-bound").defineListAllowEmpty("keyboundSlotTypes", KEYBOUND_SLOT_TYPES_DEFAULT, () -> "", ACCESSORY_TYPE_VALIDATOR);
            this.keepAccessoriesBehaviour = builder.comment("Defines how to handle player death in terms of dropping accessories\nDEFAULT: Uses the vanilla \"keepInventory\" game-rule\nALWAYS_ON: Will never drop accessories on death\nALWAYS_OFF: Will always drop accessories on death").defineEnum("keepAccessoriesBehaviour", (Enum)OhmegaConfig.Server.Service.KeepAccessoriesBehaviour.DEFAULT);
            this.disableAccessoryTypes = builder.comment("If true, effectively no accessory types will be used, and they will all be overridden, changing them all to \"ohmega:generic\"").define("disableAccessoryTypes", false);
            spec = builder.build();
        }

        public static ModConfigSpec getSpec() {
            return spec;
        }

        @Override
        public List<? extends String> slotTypes() {
            return (List)this.slotTypes.get();
        }

        @Override
        public Set<? extends String> keyboundSlotTypes() {
            return new HashSet((Collection)this.keyboundSlotTypes.get());
        }

        @Override
        public OhmegaConfig.Server.Service.KeepAccessoriesBehaviour keepAccessoriesBehaviour() {
            return (OhmegaConfig.Server.Service.KeepAccessoriesBehaviour)((Object)this.keepAccessoriesBehaviour.get());
        }

        @Override
        public boolean disableAccessoryTypes() {
            return (Boolean)this.disableAccessoryTypes.get();
        }
    }

    public static final class Client
    implements OhmegaConfig.Client.Service {
        private static ModConfigSpec spec;
        public ModConfigSpec.BooleanValue compatibilityMode;
        public // Could not load outer class - annotation placement on inner may be incorrect
        ModConfigSpec.EnumValue<@NonNull OhmegaConfig.Client.Service.ButtonStyle> buttonStyle;
        public // Could not load outer class - annotation placement on inner may be incorrect
        ModConfigSpec.EnumValue<@NonNull OhmegaConfig.Client.Service.Side> side;
        public ModConfigSpec.BooleanValue showHoverTooltip;
        public ModConfigSpec.IntValue maxColumns;
        public ModConfigSpec.IntValue maxColumnSlots;
        public ModConfigSpec.IntValue maxColumnRenderSlots;

        public Client() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            this.compatibilityMode = builder.comment("Disables some useful yet mostly unnoticeable features that may improve mod compatibility in rare cases").define("compatibilityMode", false);
            this.buttonStyle = builder.comment("Style of the accessory inventory button\nDEFAULT: The normal Ohmega button style\nLEGACY: A curios/baubles inspired button that renders next to the inventory player model\nTAG: A small tag-like button appearing just off the top corner of the inventory\nHIDDEN: Will not show, use the dedicated keybind to open the accessory inventory instead").defineEnum("buttonStyle", (Enum)OhmegaConfig.Client.Service.ButtonStyle.DEFAULT);
            this.side = builder.comment("The side of the inventory that the accessory inventory will be placed").defineEnum("inventorySide", (Enum)INVENTORY_SIDE_DEFAULT);
            this.showHoverTooltip = builder.comment("If true, will display a tooltip box of the type of accessory slot when it is hovered over").define("showHoverTooltip", true);
            this.maxColumns = builder.comment("The maximum columns to render").defineInRange("maxColumns", 1, 1, 4);
            this.maxColumnSlots = builder.comment("The maximum amount of slots per column\nIf exceeded, a new column will be made if it does not exceed \"maxColumns\"").defineInRange("maxColumnSlots", 8, 1, 32);
            this.maxColumnRenderSlots = builder.comment("The maximum amount of slots to render per column").defineInRange("maxColumnRenderSlots", 6, 1, 6);
            spec = builder.build();
        }

        public static ModConfigSpec getSpec() {
            return spec;
        }

        @Override
        public boolean compatibilityMode() {
            return (Boolean)this.compatibilityMode.get();
        }

        @Override
        public OhmegaConfig.Client.Service.ButtonStyle buttonStyle() {
            return (OhmegaConfig.Client.Service.ButtonStyle)((Object)this.buttonStyle.get());
        }

        @Override
        public OhmegaConfig.Client.Service.Side side() {
            return (OhmegaConfig.Client.Service.Side)((Object)this.side.get());
        }

        @Override
        public boolean showHoverTooltip() {
            return (Boolean)this.showHoverTooltip.get();
        }

        @Override
        public int maxColumns() {
            return (Integer)this.maxColumns.get();
        }

        @Override
        public int maxColumnSlots() {
            return (Integer)this.maxColumnSlots.get();
        }

        @Override
        public int maxColumnRenderSlots() {
            return (Integer)this.maxColumnRenderSlots.get();
        }
    }
}

