/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.config;

import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public final class OhmegaConfig {

    public static final class Server {
        private static final Service IMPL = OhmegaCommon.loadService(Service.class);

        public static void bootstrap() {
        }

        public static List<String> slotTypes() {
            return IMPL.slotTypes();
        }

        public static Set<String> keyboundSlotTypes() {
            return IMPL.keyboundSlotTypes();
        }

        public static Service.KeepAccessoriesBehaviour keepAccessoriesBehaviour() {
            return IMPL.keepAccessoriesBehaviour();
        }

        public static boolean disableAccessoryTypes() {
            return IMPL.disableAccessoryTypes();
        }

        public static interface Service {
            public static final String NORMAL = AccessoryType.NORMAL_ID.toString();
            public static final String UTILITY = AccessoryType.UTILITY_ID.toString();
            public static final String SPECIAL = AccessoryType.SPECIAL_ID.toString();
            public static final Predicate<Object> ACCESSORY_TYPE_VALIDATOR = v -> {
                if (!(v instanceof String)) return false;
                String str = (String)v;
                if (!AccessoryTypeManager.getInstance().exists(str)) return false;
                return true;
            };
            public static final String SLOT_TYPES_KEY = "slotTypes";
            public static final String SLOT_TYPES_DESCRIPTION = "Defines the types and number of slots in the accessory inventory";
            public static final List<String> SLOT_TYPES_DEFAULT = List.of(NORMAL, NORMAL, NORMAL, UTILITY, UTILITY, SPECIAL);
            public static final String SLOT_TYPES_NEW_VALUE_DEFAULT = NORMAL;
            public static final String KEYBOUND_SLOT_TYPES_KEY = "keyboundSlotTypes";
            public static final String KEYBOUND_SLOT_TYPES_DESCRIPTION = "Defines the types of accessories that can be key-bound";
            public static final List<String> KEYBOUND_SLOT_TYPES_DEFAULT = List.of(UTILITY, SPECIAL);
            public static final String KEYBOUND_SLOT_TYPES_NEW_VALUE_DEFAULT = "";
            public static final String KEEP_ACCESSORIES_BEHAVIOUR_KEY = "keepAccessoriesBehaviour";
            public static final String KEEP_ACCESSORIES_BEHAVIOUR_DESCRIPTION = "Defines how to handle player death in terms of dropping accessories\nDEFAULT: Uses the vanilla \"keepInventory\" game-rule\nALWAYS_ON: Will never drop accessories on death\nALWAYS_OFF: Will always drop accessories on death";
            public static final String DISABLE_ACCESSORY_TYPES_KEY = "disableAccessoryTypes";
            public static final String DISABLE_ACCESSORY_TYPES_DESCRIPTION = "If true, effectively no accessory types will be used, and they will all be overridden, changing them all to \"ohmega:generic\"";
            public static final boolean DISABLE_ACCESSORY_TYPES_DEFAULT = false;

            public List<? extends String> slotTypes();

            public Set<? extends String> keyboundSlotTypes();

            public KeepAccessoriesBehaviour keepAccessoriesBehaviour();

            public boolean disableAccessoryTypes();

            public static enum KeepAccessoriesBehaviour {
                DEFAULT,
                ALWAYS_ON,
                ALWAYS_OFF;

            }
        }
    }

    public static final class Client {
        private static final Service IMPL = OhmegaCommon.loadService(Service.class);

        public static void bootstrap() {
        }

        public static boolean compatibilityMode() {
            return IMPL.compatibilityMode();
        }

        public static Service.ButtonStyle buttonStyle() {
            return IMPL.buttonStyle();
        }

        public static Service.Side side() {
            return IMPL.side();
        }

        public static boolean showHoverTooltip() {
            return IMPL.showHoverTooltip();
        }

        public static int maxColumns() {
            return IMPL.maxColumns();
        }

        public static int maxColumnSlots() {
            return IMPL.maxColumnSlots();
        }

        public static int maxColumnRenderSlots() {
            return IMPL.maxColumnRenderSlots();
        }

        public static interface Service {
            public static final String COMPATIBILITY_MODE_KEY = "compatibilityMode";
            public static final String COMPATIBILITY_MODE_DESCRIPTION = "Disables some useful yet mostly unnoticeable features that may improve mod compatibility in rare cases";
            public static final boolean COMPATIBILITY_MODE_DEFAULT = false;
            public static final String BUTTON_STYLE_KEY = "buttonStyle";
            public static final String BUTTON_STYLE_DESCRIPTION = "Style of the accessory inventory button\nDEFAULT: The normal Ohmega button style\nLEGACY: A curios/baubles inspired button that renders next to the inventory player model\nTAG: A small tag-like button appearing just off the top corner of the inventory\nHIDDEN: Will not show, use the dedicated keybind to open the accessory inventory instead";
            public static final String INVENTORY_SIDE_KEY = "inventorySide";
            public static final String INVENTORY_SIDE_DESCRIPTION = "The side of the inventory that the accessory inventory will be placed";
            public static final Side INVENTORY_SIDE_DEFAULT = Side.RIGHT;
            public static final String SHOW_HOVER_TOOLTIP_KEY = "showHoverTooltip";
            public static final String SHOW_HOVER_TOOLTIP_DESCRIPTION = "If true, will display a tooltip box of the type of accessory slot when it is hovered over";
            public static final boolean SHOW_HOVER_TOOLTIP_DEFAULT = true;
            public static final String MAX_COLUMNS_KEY = "maxColumns";
            public static final String MAX_COLUMNS_DESCRIPTION = "The maximum columns to render";
            public static final int MAX_COLUMNS_DEFAULT = 1;
            public static final int MAX_COLUMNS_MIN = 1;
            public static final int MAX_COLUMNS_MAX = 4;
            public static final String MAX_COLUMN_SLOTS_KEY = "maxColumnSlots";
            public static final String MAX_COLUMN_SLOTS_DESCRIPTION = "The maximum amount of slots per column\nIf exceeded, a new column will be made if it does not exceed \"maxColumns\"";
            public static final int MAX_COLUMN_SLOTS_DEFAULT = 8;
            public static final int MAX_COLUMN_SLOTS_MIN = 1;
            public static final int MAX_COLUMN_SLOTS_MAX = 32;
            public static final String MAX_COLUMN_RENDER_SLOTS_KEY = "maxColumnRenderSlots";
            public static final String MAX_COLUMN_RENDER_SLOTS_DESCRIPTION = "The maximum amount of slots to render per column";
            public static final int MAX_COLUMN_RENDER_SLOTS_DEFAULT = 6;
            public static final int MAX_COLUMN_RENDER_SLOTS_MIN = 1;
            public static final int MAX_COLUMN_RENDER_SLOTS_MAX = 6;

            public boolean compatibilityMode();

            public ButtonStyle buttonStyle();

            public Side side();

            public boolean showHoverTooltip();

            public int maxColumns();

            public int maxColumnSlots();

            public int maxColumnRenderSlots();

            public static enum Side {
                LEFT,
                RIGHT;

            }

            public static enum ButtonStyle {
                DEFAULT(new Builder().both(new Data(132, 61, 20, 18, 0, 26))),
                LEGACY(new Builder().both(new Data(27, 9, 9, 9, 0, 62)).offsetWidthHighlighted()),
                TAG(new Builder().left(new Data(-11, 8, 14, 8, 0, 87)).right(new Data(173, 8, 14, 8, 0, 71)).noHoverHighlight()),
                HIDDEN(new Builder().both(new Data(0, 0, 0, 0, 0, 0)));

                private final Data left;
                private final Data right;
                private final boolean offsetWidthHighlighted;
                private final boolean highlightWhenHovered;

                private ButtonStyle(Builder builder) {
                    if (builder.left == null || builder.right == null) {
                        throw new NullPointerException("ButtonStyle builder has not been properly configured. Ensure both left and right data are set");
                    }
                    this.left = builder.left;
                    this.right = builder.right;
                    this.offsetWidthHighlighted = builder.offsetWidthHighlighted;
                    this.highlightWhenHovered = builder.highlightWhenHovered;
                }

                public Data getData() {
                    return Client.side() == Side.LEFT ? this.left : this.right;
                }

                public boolean offsetWidthHighlighted() {
                    return this.offsetWidthHighlighted;
                }

                public boolean highlightWhenHovered() {
                    return this.highlightWhenHovered;
                }

                private static final class Builder {
                    private Data left;
                    private Data right;
                    private boolean offsetWidthHighlighted;
                    private boolean highlightWhenHovered = true;

                    private Builder() {
                    }

                    private Builder left(Data left) {
                        this.left = left;
                        return this;
                    }

                    private Builder right(Data right) {
                        this.right = right;
                        return this;
                    }

                    private Builder both(Data data) {
                        this.left = data;
                        this.right = data;
                        return this;
                    }

                    private Builder offsetWidthHighlighted() {
                        this.offsetWidthHighlighted = true;
                        return this;
                    }

                    private Builder noHoverHighlight() {
                        this.highlightWhenHovered = false;
                        return this;
                    }
                }

                public record Data(int x, int y, int width, int height, int u, int v) {
                }
            }
        }
    }
}

