/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.item;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.AccessoryModifiers;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.OhmegaCommon;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AngelRing
extends Item
implements IAccessory {
    public AngelRing(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(@NonNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Item.TooltipContext context, @NonNull TooltipDisplay tooltipDisplay, Consumer<Component> tooltip, @NonNull TooltipFlag flag) {
        tooltip.accept((Component)AccessoryHelper.getBindTooltip(stack));
    }

    @Override
    public void onEquip(@NonNull Player player, @NonNull ItemStack stack) {
        AccessoryHelper.setActive(player, stack, true);
    }

    @Override
    public void onUnequip(@NonNull Player player, @NonNull ItemStack stack) {
        if (!player.isCreative() && !player.isSpectator()) {
            player.getAbilities().mayfly = false;
            player.getAbilities().flying = false;
        }
        AccessoryHelper.setActive(player, stack, false);
    }

    @Override
    public void tick(@NonNull Player player, @NonNull ItemStack stack) {
        if (!player.isCreative() && !player.isSpectator()) {
            if (AccessoryHelper.isActive(stack)) {
                player.getAbilities().mayfly = true;
            } else {
                player.getAbilities().mayfly = false;
                player.getAbilities().flying = false;
            }
        }
    }

    @Override
    public void onUse(@NonNull Player player, @NonNull ItemStack stack) {
        AccessoryHelper.toggleActive(player, stack);
    }

    public boolean isFoil(@NonNull ItemStack stack) {
        return AccessoryHelper.isActive(stack);
    }

    @Override
    public void addDefaultAttributeModifiers(@NonNull AccessoryModifiers.Builder builder) {
        builder.addPassive((Holder<Attribute>)Attributes.ATTACK_DAMAGE, new AttributeModifier(OhmegaCommon.rl(BuiltInRegistries.ITEM.getKey((Object)this).toLanguageKey() + ".effect.strength"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        builder.addActive((Holder<Attribute>)Attributes.MAX_HEALTH, new AttributeModifier(OhmegaCommon.rl(BuiltInRegistries.ITEM.getKey((Object)this).toLanguageKey() + ".effect.health_boost"), 4.0, AttributeModifier.Operation.ADD_VALUE));
    }

    @Override
    public @Nullable Holder<SoundEvent> getEquipSound() {
        return SoundEvents.ARMOR_EQUIP_GOLD;
    }
}

