/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.inv;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.event.EquipContext;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.dataattachment.AccessoryContainer;
import com.swacky.ohmega.event.OhmegaHooks;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jspecify.annotations.NonNull;

public final class AccessorySlot
extends Slot {
    private static final Container EMPTY_CONTAINER = new SimpleContainer(0);
    private final Player player;
    private final AccessoryContainer handler;
    private final AccessoryType type;

    public AccessorySlot(Player player, AccessoryContainer handler, int index, int x, int y, AccessoryType type) {
        super(EMPTY_CONTAINER, index, x, y);
        this.player = player;
        this.handler = handler;
        this.type = type;
    }

    public AccessoryType getType() {
        return this.type;
    }

    public boolean mayPlace(@NonNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        IAccessory accessory = AccessoryHelper.getBoundAccessory(item);
        if (accessory != null) {
            return this.handler.isItemValid(this.player, this.getContainerSlot(), stack, EquipContext.SLOT_PLACE) && AccessoryHelper.getType(item) == this.type;
        }
        return false;
    }

    public boolean mayPickup(@NonNull Player player) {
        boolean original;
        ItemStack stack = this.getItem();
        if (stack.isEmpty()) {
            return false;
        }
        IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
        boolean bl = original = !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
        if (accessory != null) {
            original &= accessory.canUnequip(player, this.getItem());
        }
        return OhmegaHooks.accessoryCanUnequipEvent(player, this.getItem(), original);
    }

    public @NonNull ItemStack getItem() {
        return this.handler.getStackInSlot(this.getContainerSlot());
    }

    public void onQuickCraft(@NonNull ItemStack oldStack, @NonNull ItemStack newStack) {
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(@NonNull ItemStack stack) {
        return this.getMaxStackSize();
    }

    public @NonNull ItemStack remove(int amount) {
        int index = this.getContainerSlot();
        ItemStack stack = ContainerHelper.removeItem(this.handler.getStacks(), (int)index, (int)amount);
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.handler.getStackInSlot(index), (ItemStack)stack)) {
            this.handler.doUnequip(this.player, stack);
            this.handler.onContentsChanged(index);
        }
        return stack;
    }

    public void set(@NonNull ItemStack stack) {
        this.handler.setStackInSlot(this.player, this.getContainerSlot(), stack, EquipContext.SLOT_PLACE);
    }

    public ResourceLocation getNoItemIcon() {
        return this.type.getEmptySlotLocation();
    }
}

