/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.inv;

import com.google.common.collect.ImmutableList;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.dataattachment.AccessoryContainer;
import com.swacky.ohmega.common.init.OhmegaMenus;
import com.swacky.ohmega.common.inv.AccessorySlot;
import com.swacky.ohmega.config.OhmegaConfig;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.NonNull;

public final class AccessoryInventoryMenu
extends AbstractContainerMenu {
    public static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Player player;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();

    public AccessoryInventoryMenu(int id, Inventory inv) {
        super(OhmegaMenus.getAccessoryMenu(), id);
        this.player = inv.player;
        ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();
        int x = this.player.level().isClientSide() && OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? 10 + 18 * (int)Math.min(Math.ceil((double)slotTypes.size() / (double)Math.min(OhmegaConfig.Client.maxColumnRenderSlots(), OhmegaConfig.Client.maxColumnSlots())), (double)OhmegaConfig.Client.maxColumns()) : 0;
        this.addResultSlot(this.player, x + 154, 28);
        this.addCraftingGridSlots(2, 2, x + 98, 18);
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlotType = VALID_EQUIPMENT_SLOTS[i];
            this.addSlot((Slot)new ArmorSlot((Container)inv, (LivingEntity)this.player, equipmentSlotType, 39 - i, x + 8, 8 + i * 18, ARMOR_SLOT_TEXTURES[equipmentSlotType.getIndex()]));
        }
        this.addStandardInventorySlots((Container)inv, x + 8, 84);
        this.addSlot(new OffhandSlot((Container)inv, 40, x + 77, 62));
        AccessoryContainer container = AccessoryHelper.getContainer(this.player);
        if (!this.player.level().isClientSide()) {
            for (int i = 0; i < slotTypes.size(); ++i) {
                this.addSlot(new AccessorySlot(this.player, container, i, 0, 0, (AccessoryType)slotTypes.get(i)));
            }
        } else {
            int renderSlots = Math.min(OhmegaConfig.Client.maxColumnSlots(), OhmegaConfig.Client.maxColumnRenderSlots());
            int renderColumns = (int)Math.min(Math.ceil((double)slotTypes.size() / (double)renderSlots), (double)OhmegaConfig.Client.maxColumns());
            int slotsAvailable = Math.min(renderColumns * renderSlots, slotTypes.size());
            x = OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? (x += -10 - 18 * renderColumns + 1) : (x += 179);
            boolean stop = false;
            int index = 0;
            block2: for (int i = 0; i < renderColumns && !stop; ++i) {
                int slotsCreatedCurrentColumn = 0;
                int j = 0;
                while (true) {
                    this.addSlot(new AccessorySlot(this.player, container, index, x + 4 + 18 * i, 25 + j * 18, (AccessoryType)slotTypes.get(index++)));
                    if (++slotsCreatedCurrentColumn >= renderSlots) continue block2;
                    if (index >= slotsAvailable) {
                        stop = true;
                        continue block2;
                    }
                    ++j;
                }
            }
        }
    }

    private void addResultSlot(Player pPlayer, int x, int y) {
        this.addSlot((Slot)new ResultSlot(pPlayer, this.craftMatrix, (Container)this.craftResult, 0, x, y));
    }

    private void addCraftingGridSlots(int width, int height, int x, int y) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.addSlot(new Slot((Container)this.craftMatrix, j + i * width, x + j * 18, y + i * 18));
            }
        }
    }

    public boolean stillValid(@NonNull Player player) {
        return true;
    }

    public void slotsChanged(@NonNull Container container) {
        Level level = this.player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            CraftingMenu.slotChangedCraftingGrid((AbstractContainerMenu)this, (ServerLevel)level2, (Player)this.player, (CraftingContainer)this.craftMatrix, (ResultContainer)this.craftResult, null);
        }
        super.slotsChanged(container);
    }

    public void removed(@NonNull Player player) {
        super.removed(player);
        this.craftResult.clearContent();
        if (!player.level().isClientSide()) {
            this.clearContainer(player, (Container)this.craftMatrix);
        }
    }

    public boolean canTakeItemForPickAll(@NonNull ItemStack stack, Slot slot) {
        return slot.container != this.craftResult && super.canTakeItemForPickAll(stack, slot);
    }

    public @NonNull ItemStack quickMoveStack(@NonNull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        ItemStack stack = ItemStack.EMPTY;
        if (slot.hasItem()) {
            ItemStack stack0 = slot.getItem();
            stack = stack0.copy();
            if (index == 0) {
                if (!this.moveItemStackTo(stack0, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack0, stack);
            } else if (index >= 1 && index < 5) {
                if (!this.moveItemStackTo(stack0, 9, 45, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= 5 && index < 9) {
                if (!this.moveItemStackTo(stack0, 9, 45, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                int i;
                Item item = stack0.getItem();
                AccessoryType type = AccessoryHelper.getType(item);
                int openIndex = AccessoryHelper.getFirstOpenSlot(player, type);
                IAccessory accessory = AccessoryHelper.getBoundAccessory(item);
                EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(stack);
                if (accessory != null && index > 8 && index < 45 && openIndex != -1 && this.getSlot(46 + openIndex).mayPlace(stack)) {
                    stack0.shrink(1);
                    stack.setCount(1);
                    this.getSlot(46 + openIndex).set(stack);
                } else if (index > 45 && index < 52) {
                    if (this.moveItemStackTo(stack0, 9, 45, false)) {
                        AccessoryHelper.getContainer(player).doUnequip(player, stack);
                        return ItemStack.EMPTY;
                    }
                } else if (equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - equipmentSlot.getIndex())).hasItem() && player.isEquippableInSlot(stack0, equipmentSlot) ? !this.moveItemStackTo(stack0, i = 8 - equipmentSlot.getIndex(), i + 1, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(stack0, 45, 46, false) : (index >= 9 && index < 36 ? !this.moveItemStackTo(stack0, 36, 45, false) : (index > 35 && index < 45 ? !this.moveItemStackTo(stack0, 9, 36, false) : !this.moveItemStackTo(stack0, 9, 45, false))))) {
                    return ItemStack.EMPTY;
                }
            }
            if (stack0.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, stack);
            } else {
                slot.setChanged();
            }
            if (stack0.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack0);
            if (index == 0) {
                player.drop(stack0, false);
            }
        }
        return stack;
    }

    public void initializeContents(int stateId, List<ItemStack> items, @NonNull ItemStack carried) {
        for (int i = 0; i < Math.min(this.slots.size(), items.size()); ++i) {
            Slot slot = this.getSlot(i);
            ItemStack stack = items.get(i);
            if (ItemStack.matches((ItemStack)slot.getItem(), (ItemStack)stack)) continue;
            slot.set(stack);
        }
        this.setCarried(carried);
        this.stateId = stateId;
    }

    private static class OffhandSlot
    extends Slot {
        public OffhandSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(@NonNull ItemStack stack) {
            return super.mayPlace(stack);
        }

        public ResourceLocation getNoItemIcon() {
            return InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD;
        }
    }
}

