/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.init;

import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public final class OhmegaTags {
    private static final ArrayList<TagHolder> TAGS = new ArrayList();

    public static void refresh() {
        TAGS.clear();
        for (AccessoryType type : AccessoryTypeManager.getInstance().getTypes()) {
            TAGS.add(new TagHolder(type, OhmegaTags.register(type.getId())));
        }
    }

    private static TagKey<Item> register(ResourceLocation id) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
    }

    public static ArrayList<TagHolder> getTags() {
        return TAGS;
    }

    public static TagHolder get(ResourceLocation id) {
        for (TagHolder holder : TAGS) {
            if (!holder.getType().getId().equals((Object)id)) continue;
            return holder;
        }
        return null;
    }

    public static class TagHolder {
        private final AccessoryType type;
        private final TagKey<Item> tag;

        private TagHolder(AccessoryType type, TagKey<Item> tag) {
            this.type = type;
            this.tag = tag;
        }

        public AccessoryType getType() {
            return this.type;
        }

        public TagKey<Item> getTag() {
            return this.tag;
        }
    }
}

