/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.InputConstants;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.init.OhmegaTags;
import com.swacky.ohmega.config.OhmegaConfig;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;

public final class OhmegaBinds {
    private static final Service INST = OhmegaCommon.loadService(Service.class);
    public static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((ResourceLocation)OhmegaCommon.rl("ohmega"));
    public static final KeyMapping OPEN_ACC_INV = new KeyMapping("key.ohmega.open_acc_inv", InputConstants.Type.KEYSYM, -1, CATEGORY);

    public static void bootstrap() {
    }

    public static boolean isInstance(KeyMapping other) {
        return INST.isInstance(other);
    }

    public static interface Service {
        public KeyMapping createMapping(String var1, int var2);

        public boolean isInstance(KeyMapping var1);
    }

    public static class Generated {
        private static ImmutableMap<AccessoryType, ImmutableList<KeyMapping>> SLOT_KEYS;
        private static ArrayList<KeyMapping> ORDERED_SLOT_KEYS;

        private static ImmutableMap<AccessoryType, ImmutableList<KeyMapping>> createSlotKeys() {
            ORDERED_SLOT_KEYS = new ArrayList();
            ImmutableList<AccessoryType> keyBoundSlotTypes = AccessoryHelper.getKeyboundSlotTypes();
            WeakHashMap<AccessoryType, ImmutableList.Builder> builder = new WeakHashMap<AccessoryType, ImmutableList.Builder>(keyBoundSlotTypes.size());
            WeakHashMap<AccessoryType, Integer> typeCountMap = new WeakHashMap<AccessoryType, Integer>();
            if (OhmegaConfig.Server.disableAccessoryTypes()) {
                OhmegaTags.TagHolder holder = OhmegaTags.get(OhmegaCommon.rl("generic"));
                if (holder != null) {
                    typeCountMap.put(holder.getType(), 0);
                }
            } else {
                for (OhmegaTags.TagHolder holder : OhmegaTags.getTags()) {
                    typeCountMap.put(holder.getType(), 0);
                }
            }
            block1: for (AccessoryType slotType : AccessoryHelper.getSlotTypes()) {
                for (AccessoryType type : keyBoundSlotTypes) {
                    if (type != slotType) continue;
                    int count = (Integer)typeCountMap.get(type);
                    int key = type == AccessoryType.UTILITY.get() ? (count == 0 ? 71 : (count == 1 ? 86 : -1)) : (type == AccessoryType.SPECIAL.get() && count == 0 ? 66 : -1);
                    builder.computeIfAbsent(type, k -> new ImmutableList.Builder());
                    ResourceLocation id = type.getId();
                    KeyMapping mapping = INST.createMapping("key." + id.getNamespace() + "." + id.getPath() + "_" + count, key);
                    ((ImmutableList.Builder)builder.get(type)).add((Object)mapping);
                    ORDERED_SLOT_KEYS.add(mapping);
                    typeCountMap.put(type, count + 1);
                    continue block1;
                }
            }
            ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)builder.size());
            for (AccessoryType key : builder.keySet()) {
                map.put((Object)key, (Object)((ImmutableList.Builder)builder.get(key)).build());
            }
            return map.build();
        }

        public static ImmutableMap<AccessoryType, ImmutableList<KeyMapping>> getSlotKeys() {
            SLOT_KEYS = Generated.createSlotKeys();
            return SLOT_KEYS;
        }

        public static KeyMapping getMapping(AccessoryType type, int index) {
            ImmutableList list = (ImmutableList)SLOT_KEYS.get((Object)type);
            if (list != null) {
                return (KeyMapping)list.get(index);
            }
            return null;
        }

        public static ImmutableList<KeyMapping> getMappings() {
            return ImmutableList.copyOf(ORDERED_SLOT_KEYS);
        }

        public static int size() {
            int size = 0;
            for (ImmutableList list : SLOT_KEYS.values()) {
                size += list.size();
            }
            return size;
        }
    }
}

