/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.dataattachment;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.event.EquipContext;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.event.OhmegaHooks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import org.apache.commons.lang3.ArrayUtils;
import org.jspecify.annotations.NonNull;

public final class AccessoryContainer {
    public static final Codec<AccessoryContainer> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("stacks").forGetter(inst -> inst.stacks), (App)Codec.BOOL.listOf().fieldOf("changed").forGetter(inst -> Booleans.asList((boolean[])inst.changed))).apply((Applicative)builder, AccessoryContainer::new));
    public static final MapCodec<AccessoryContainer> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("stacks").forGetter(inst -> inst.stacks), (App)Codec.BOOL.listOf().fieldOf("changed").forGetter(inst -> Booleans.asList((boolean[])inst.changed))).apply((Applicative)builder, AccessoryContainer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AccessoryContainer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, inst -> inst.stacks, (StreamCodec)new StreamCodec<RegistryFriendlyByteBuf, boolean[]>(){

        public void encode(@NonNull RegistryFriendlyByteBuf buf, boolean @NonNull [] values) {
            buf.writeVarInt(values.length);
            for (boolean value : values) {
                buf.writeBoolean(value);
            }
        }

        public boolean @NonNull [] decode(@NonNull RegistryFriendlyByteBuf buf) {
            int size = buf.readVarInt();
            boolean[] values = new boolean[size];
            for (int i = 0; i < size; ++i) {
                values[i] = buf.readBoolean();
            }
            return values;
        }
    }, inst -> inst.changed, AccessoryContainer::new);
    private NonNullList<ItemStack> stacks;
    private boolean[] changed;

    private AccessoryContainer(List<ItemStack> stacks, boolean[] changed) {
        this.stacks = NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks.toArray(new ItemStack[0]));
        this.changed = changed;
    }

    private AccessoryContainer(List<ItemStack> stacks, List<Boolean> changed) {
        this(stacks, Booleans.toArray(changed));
    }

    public AccessoryContainer() {
        int size = AccessoryHelper.getSlotTypes().size();
        this.stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.changed = new boolean[size];
    }

    public boolean isItemValid(Player player, int slot, @NonNull ItemStack stack, EquipContext context) {
        Item item;
        IAccessory accessory;
        if (slot >= 0 && slot < this.stacks.size() && (accessory = AccessoryHelper.getBoundAccessory(item = stack.getItem())) != null && (AccessoryHelper.compatibleWith(player, accessory) || ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot))))) {
            return OhmegaHooks.accessoryCanEquipEvent(player, stack, context, accessory.canEquip(player, stack)) && AccessoryHelper.getType(item) == AccessoryHelper.getSlotTypes().get(slot);
        }
        return false;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public void onContentsChanged(int index) {
        this.changed[index] = true;
    }

    public ItemStack getStackInSlot(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public void doUnequip(Player player, ItemStack stack) {
        IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
        if (accessory != null) {
            if (!OhmegaHooks.accessoryUnequipEvent(player, stack)) {
                accessory.onUnequip(player, stack);
            }
            AccessoryHelper.changeModifiers(player, AccessoryHelper.getModifiers(stack).getPassive(), true);
            AccessoryHelper.setNoSlot(stack);
        }
    }

    private void doEquip(Player player, ItemStack stack, int index, EquipContext context) {
        IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
        if (accessory != null) {
            AccessoryHelper.setSlot(stack, index);
            AccessoryHelper.changeModifiers(player, AccessoryHelper.getModifiers(stack).getPassive(), true);
            if (!OhmegaHooks.accessoryEquipEvent(player, stack, context)) {
                accessory.onEquip(player, stack);
            }
        }
    }

    private void doSetStackInSlot(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        this.onContentsChanged(index);
    }

    public boolean setStackInSlot(Player player, int index, @NonNull ItemStack stack, EquipContext context) {
        if (stack.isEmpty() || this.isItemValid(player, index, stack, context) && AccessoryHelper.isItemAccessoryBound(stack.getItem())) {
            ItemStack current = (ItemStack)this.stacks.get(index);
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)stack)) {
                this.doUnequip(player, current);
                this.doSetStackInSlot(index, stack);
                this.doEquip(player, stack, index, context);
            } else if (this.changed[index]) {
                this.changed[index] = false;
            }
            return true;
        }
        return false;
    }

    private void removeStackFromSlot(Player player, int index, boolean fromDeath) {
        ItemStack stack = (ItemStack)this.stacks.get(index);
        if (!stack.isEmpty()) {
            this.doUnequip(player, stack);
            if (fromDeath) {
                player.drop(stack, true, false);
                this.doSetStackInSlot(index, ItemStack.EMPTY);
            } else {
                if (!player.addItem(stack)) {
                    player.drop(stack, true);
                }
                this.onContentsChanged(index);
            }
        }
    }

    public void onAttach(Player player) {
        this.reloadCfg(player);
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            this.doSetStackInSlot(i, stack);
            if (!AccessoryHelper.isActive(stack)) continue;
            this.doEquip(player, stack, i, EquipContext.GENERIC);
        }
    }

    public void syncSlots(Player player, int[] indexes, List<ItemStack> stacks) {
        for (int i = 0; i < indexes.length; ++i) {
            ItemStack stack = stacks.get(i);
            int index = indexes[i];
            this.doSetStackInSlot(index, stack);
            if (!AccessoryHelper.isActive(stack)) continue;
            this.doEquip(player, stack, index, EquipContext.GENERIC);
        }
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void tick(Player player) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
            if (accessory == null || OhmegaHooks.accessoryTickEventPre(player, stack)) continue;
            accessory.tick(player, stack);
            OhmegaHooks.accessoryTickEventPost(player, stack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer svr = (ServerPlayer)player;
            ArrayList<Integer> slots = new ArrayList<Integer>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!this.changed[i]) continue;
                slots.add(i);
                stacks.add(this.getStackInSlot(i));
                this.changed[i] = false;
            }
            if (!slots.isEmpty()) {
                AccessoryHelper.syncSlots(svr, slots.stream().mapToInt(Integer::intValue).toArray(), stacks, svr.level().getPlayers(svr0 -> true));
            }
        }
    }

    public void onDeath(ServerPlayer player) {
        boolean flag;
        switch (OhmegaConfig.Server.keepAccessoriesBehaviour()) {
            default: {
                throw new MatchException(null, null);
            }
            case ALWAYS_ON: {
                boolean bl = false;
                break;
            }
            case ALWAYS_OFF: {
                boolean bl = true;
                break;
            }
            case DEFAULT: {
                boolean bl = flag = !player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
            }
        }
        if (flag) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.removeStackFromSlot((Player)player, i, true);
            }
        }
    }

    public void reloadCfg(Player player) {
        int oldSize = this.changed.length;
        int newSize = AccessoryHelper.getSlotTypes().size();
        if (newSize > oldSize) {
            Object[] newStacks = new ItemStack[newSize - oldSize];
            Arrays.fill(newStacks, ItemStack.EMPTY);
            this.stacks = NonNullList.of((Object)ItemStack.EMPTY, (Object[])((ItemStack[])ArrayUtils.addAll((Object[])((ItemStack[])this.stacks.toArray((Object[])new ItemStack[0])), (Object[])newStacks)));
            this.changed = ArrayUtils.addAll((boolean[])this.changed, (boolean[])new boolean[newSize - oldSize]);
        } else if (newSize < oldSize) {
            for (int i = newSize; i < oldSize; ++i) {
                this.removeStackFromSlot(player, i, false);
            }
            this.stacks = NonNullList.of((Object)ItemStack.EMPTY, (Object[])Arrays.copyOfRange((ItemStack[])this.stacks.toArray((Object[])new ItemStack[0]), 0, newSize));
            this.changed = Arrays.copyOfRange(this.changed, 0, newSize);
        }
        ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (slotTypes.get(i) == AccessoryHelper.getType(((ItemStack)this.stacks.get(i)).getItem())) continue;
            this.removeStackFromSlot(player, i, false);
        }
    }
}

