/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.accessorytype;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.ProtoAccessoryType;
import com.swacky.ohmega.common.init.OhmegaTags;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jspecify.annotations.NonNull;

public final class AccessoryTypeManager
extends SimplePreparableReloadListener<ImmutableSet<AccessoryType>> {
    private static final AccessoryTypeManager INSTANCE = new AccessoryTypeManager();
    private static final int DEFAULT_SIZE = 4;
    private static final String LOCATION = "ohmega/accessory_types.json";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ProtoAccessoryType.class, (Object)ProtoAccessoryType.Deserializer.getInstance()).create();
    private static final TypeToken<Map<String, ProtoAccessoryType>> TOKEN = new TypeToken<Map<String, ProtoAccessoryType>>(){};
    private final HashSet<AccessoryType> types = new HashSet();

    private AccessoryTypeManager() {
    }

    public static AccessoryTypeManager getInstance() {
        return INSTANCE;
    }

    protected @NonNull ImmutableSet<AccessoryType> prepare(@NonNull ResourceManager manager, @NonNull ProfilerFiller profiler) {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)4);
        for (String namespace : manager.getNamespaces()) {
            for (Resource resource : manager.getResourceStack(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)LOCATION))) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        Map map = (Map)GsonHelper.fromJson((Gson)GSON, (Reader)reader, TOKEN);
                        for (Map.Entry entry : map.entrySet()) {
                            builder.add((Object)new AccessoryType(namespace, (String)entry.getKey(), (ProtoAccessoryType)entry.getValue()));
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    OhmegaCommon.LOGGER.warn("Could not read '{}' in DataPack: '{}'", (Object)LOCATION, (Object)resource.sourcePackId(), (Object)e);
                }
            }
        }
        return builder.build();
    }

    public void apply(ImmutableSet<AccessoryType> types) {
        this.types.clear();
        this.types.addAll((Collection<AccessoryType>)types);
        OhmegaTags.refresh();
    }

    public void clear() {
        this.types.clear();
    }

    protected void apply(@NonNull ImmutableSet<AccessoryType> types, @NonNull ResourceManager resourceManager, @NonNull ProfilerFiller profiler) {
        this.apply(types);
    }

    public ImmutableSet<AccessoryType> getTypes() {
        return ImmutableSet.copyOf(this.types);
    }

    public @NonNull AccessoryType get(ResourceLocation id) {
        for (AccessoryType type : this.types) {
            if (!type.getId().equals((Object)id)) continue;
            return type;
        }
        return AccessoryType.NORMAL.get();
    }

    public boolean exists(String id) {
        for (AccessoryType type : this.types) {
            if (!type.getId().equals((Object)ResourceLocation.parse((String)id))) continue;
            return true;
        }
        return false;
    }
}

