/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.common.accessorytype;

import com.google.common.collect.ImmutableSet;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.common.accessorytype.ProtoAccessoryType;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.NonNull;

public final class AccessoryType {
    public static final StreamCodec<FriendlyByteBuf, AccessoryType> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, AccessoryType::getId, (StreamCodec)ResourceLocation.STREAM_CODEC, AccessoryType::getEmptySlotLocation, (StreamCodec)ByteBufCodecs.INT, AccessoryType::getPriority, (StreamCodec)ByteBufCodecs.INT, AccessoryType::getHoverTextColour, (StreamCodec)ByteBufCodecs.BOOL, AccessoryType::displayHoverText, AccessoryType::new);
    public static final StreamCodec<FriendlyByteBuf, ImmutableSet<AccessoryType>> SET_STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ImmutableSet<AccessoryType>>(){

        public @NonNull ImmutableSet<AccessoryType> decode(@NonNull FriendlyByteBuf buf) {
            int size = VarInt.read((ByteBuf)buf);
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                builder.add((Object)((AccessoryType)STREAM_CODEC.decode((Object)buf)));
            }
            return builder.build();
        }

        public void encode(@NonNull FriendlyByteBuf buf, @NonNull ImmutableSet<AccessoryType> values) {
            VarInt.write((ByteBuf)buf, (int)values.size());
            for (AccessoryType value : values) {
                STREAM_CODEC.encode((Object)buf, (Object)value);
            }
        }
    };
    private static final String LOCATION_PREFIX = "container/slot/";
    public static final ResourceLocation GENERIC_ID = OhmegaCommon.rl("generic");
    public static final ResourceLocation NORMAL_ID = OhmegaCommon.rl("normal");
    public static final ResourceLocation UTILITY_ID = OhmegaCommon.rl("utility");
    public static final ResourceLocation SPECIAL_ID = OhmegaCommon.rl("special");
    public static final Supplier<AccessoryType> GENERIC = () -> AccessoryTypeManager.getInstance().get(GENERIC_ID);
    public static final Supplier<AccessoryType> NORMAL = () -> AccessoryTypeManager.getInstance().get(NORMAL_ID);
    public static final Supplier<AccessoryType> UTILITY = () -> AccessoryTypeManager.getInstance().get(UTILITY_ID);
    public static final Supplier<AccessoryType> SPECIAL = () -> AccessoryTypeManager.getInstance().get(SPECIAL_ID);
    private final ResourceLocation id;
    private final ResourceLocation emptySlotLocation;
    private final int priority;
    private final int hoverTextColour;
    private final boolean displayHoverText;

    private AccessoryType(ResourceLocation id, ResourceLocation emptySlotLocation, int priority, int hoverTextColour, boolean displayHoverText) {
        this.id = id;
        this.emptySlotLocation = emptySlotLocation;
        this.priority = priority;
        this.hoverTextColour = hoverTextColour;
        this.displayHoverText = displayHoverText;
    }

    AccessoryType(String namespace, String path, ProtoAccessoryType data) {
        this(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path), data.emptySlotPath.indexOf(58) == -1 ? ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(LOCATION_PREFIX + data.emptySlotPath)) : ResourceLocation.parse((String)data.emptySlotPath).withPrefix(LOCATION_PREFIX), data.priority, data.hoverTextColour, data.displayHoverText);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getEmptySlotLocation() {
        return this.emptySlotLocation;
    }

    public int getHoverTextColour() {
        return this.hoverTextColour;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean displayHoverText() {
        return this.displayHoverText;
    }

    public boolean isDefault() {
        return this == NORMAL.get();
    }

    public String getTranslationKey() {
        return "accessory_type." + this.id.getNamespace() + "." + this.id.getPath();
    }

    public MutableComponent getTranslation() {
        return Component.translatable((String)this.getTranslationKey()).withStyle(Style.EMPTY.withColor(this.getHoverTextColour()));
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof AccessoryType) {
            AccessoryType other = (AccessoryType)obj;
            return this.id.equals((Object)other.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

