/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.client.screen;

import com.swacky.ohmega.api.AccessoryHelper;
import com.swacky.ohmega.client.screen.AccessoryInventoryButton;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.inv.AccessoryInventoryMenu;
import com.swacky.ohmega.common.inv.AccessorySlot;
import com.swacky.ohmega.config.OhmegaConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectsInInventory;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.jspecify.annotations.NonNull;

public final class AccessoryInventoryScreen
extends AbstractContainerScreen<AccessoryInventoryMenu> {
    private final EffectsInInventory effects = new EffectsInInventory((AbstractContainerScreen)this);
    private final int extraWidth = 10 + 18 * (int)Math.min(Math.ceil((double)AccessoryHelper.getSlotTypes().size() / (double)Math.min(OhmegaConfig.Client.maxColumnRenderSlots(), OhmegaConfig.Client.maxColumnSlots())), (double)OhmegaConfig.Client.maxColumns());

    public AccessoryInventoryScreen(AccessoryInventoryMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, (Component)Component.translatable((String)"container.crafting"));
        this.imageWidth += this.extraWidth;
        this.titleLabelX = OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? 97 + this.extraWidth : 97;
    }

    protected void init() {
        this.renderables.clear();
        AccessoryInventoryButton button = new AccessoryInventoryButton(OhmegaConfig.Client.buttonStyle(), this);
        this.addRenderableWidget((GuiEventListener)button);
        this.leftPos = OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? (this.width - this.imageWidth - this.extraWidth) / 2 : (this.width - this.imageWidth + this.extraWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }

    public void render(@NonNull GuiGraphics gui, int mx, int my, float partialTicks) {
        super.render(gui, mx, my, partialTicks);
        this.effects.renderEffects(gui, mx, my);
        this.renderTooltip(gui, mx, my);
    }

    public boolean showsActiveEffects() {
        return this.effects.canSeeEffects();
    }

    private void renderAccInv(GuiGraphics gui) {
        int i;
        int renderSlots = Math.min(OhmegaConfig.Client.maxColumnSlots(), OhmegaConfig.Client.maxColumnRenderSlots());
        int renderColumns = (int)Math.min(Math.ceil((double)AccessoryHelper.getSlotTypes().size() / (double)renderSlots), (double)OhmegaConfig.Client.maxColumns());
        int slotsAvailable = Math.min(renderColumns * renderSlots, AccessoryHelper.getSlotTypes().size());
        int mostSlotsPerColumn = Math.min(renderSlots, AccessoryHelper.getSlotTypes().size());
        int x = OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? this.leftPos : this.leftPos + 175 + 2 + 1;
        int lastColumnSlots = slotsAvailable % mostSlotsPerColumn == 0 ? mostSlotsPerColumn : slotsAvailable % mostSlotsPerColumn;
        int index = 0;
        for (i = 0; i < renderColumns; ++i) {
            int slotsCreatedCurrentColumn = 0;
            int j = 0;
            while (true) {
                gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.topPos + 24 + j * 18, 4.0f, 4.0f, 18, 18, 26, 103);
                if (++slotsCreatedCurrentColumn >= mostSlotsPerColumn || ++index >= slotsAvailable) break;
                ++j;
            }
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.topPos + 20, 4.0f, 0.0f, 18, 4, 26, 103);
            if (i >= renderColumns - 1 && lastColumnSlots != mostSlotsPerColumn) {
                gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.topPos + 24 + 18 * lastColumnSlots, 4.0f, 22.0f, 18, 4, 26, 103);
                continue;
            }
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * i, this.topPos + 24 + 18 * mostSlotsPerColumn, 4.0f, 22.0f, 18, 4, 26, 103);
        }
        for (i = 0; i < mostSlotsPerColumn; ++i) {
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x, this.topPos + 24 + 18 * i, 0.0f, 4.0f, 4, 18, 26, 103);
            if (i >= lastColumnSlots) {
                gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * (renderColumns - 1), this.topPos + 24 + 18 * i, 22.0f, 4.0f, 4, 18, 26, 103);
                continue;
            }
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.topPos + 24 + 18 * i, 22.0f, 4.0f, 4, 18, 26, 103);
        }
        gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x, this.topPos + 20, 0.0f, 0.0f, 4, 4, 26, 103);
        gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.topPos + 20, 22.0f, 0.0f, 4, 4, 26, 103);
        gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x, this.topPos + 24 + 18 * mostSlotsPerColumn, 0.0f, 22.0f, 4, 4, 26, 103);
        gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * renderColumns, this.topPos + 24 + 18 * lastColumnSlots, 22.0f, 22.0f, 4, 4, 26, 103);
        if (lastColumnSlots != mostSlotsPerColumn) {
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 4 + 18 * (renderColumns - 1), this.topPos + 24 + 18 * mostSlotsPerColumn, 22.0f, 22.0f, 4, 4, 26, 103);
        }
        if (lastColumnSlots != mostSlotsPerColumn) {
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, x + 5 + 18 * (renderColumns - 1), this.topPos + 24 + 18 * lastColumnSlots, 20.0f, 26.0f, 3, 3, 26, 103);
        }
    }

    protected void renderBg(@NonNull GuiGraphics gui, float partialTicks, int mx, int my) {
        LocalPlayer player;
        if (this.minecraft != null && (player = this.minecraft.player) != null) {
            int x = OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT ? this.leftPos + this.extraWidth : this.leftPos;
            gui.blit(RenderPipelines.GUI_TEXTURED, InventoryScreen.INVENTORY_LOCATION, x, this.topPos, 0.0f, 0.0f, 176, 166, 256, 256);
            this.renderAccInv(gui);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)gui, (int)(x + 26), (int)(this.topPos + 8), (int)(x + 75), (int)(this.topPos + 78), (int)30, (float)0.0625f, (float)mx, (float)my, (LivingEntity)player);
        }
    }

    protected void renderLabels(@NonNull GuiGraphics gui, int mx, int my) {
        gui.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
    }

    protected void renderTooltip(@NonNull GuiGraphics gui, int mx, int my) {
        AccessorySlot accSlot;
        Slot slot;
        if (((AccessoryInventoryMenu)this.menu).getCarried().isEmpty() && (slot = this.hoveredSlot) instanceof AccessorySlot && (accSlot = (AccessorySlot)slot).getType().displayHoverText() && OhmegaConfig.Client.showHoverTooltip() && !this.hoveredSlot.hasItem()) {
            gui.setTooltipForNextFrame((Component)accSlot.getType().getTranslation(), mx, my);
        } else {
            super.renderTooltip(gui, mx, my);
        }
    }

    protected boolean hasClickedOutside(double x, double y, int left, int top) {
        if (super.hasClickedOutside(x, y, left, top)) {
            return true;
        }
        if (OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT) {
            if (x < (double)(this.leftPos + this.extraWidth)) {
                if (y > (double)this.topPos && y < (double)(this.topPos + 20)) {
                    return true;
                }
                int renderSlots = Math.min(OhmegaConfig.Client.maxColumnSlots(), OhmegaConfig.Client.maxColumnRenderSlots());
                int mostSlotsPerColumn = Math.min(renderSlots, AccessoryHelper.getSlotTypes().size());
                return y > (double)(this.topPos + 20 + 4 + mostSlotsPerColumn * 18 + 4);
            }
        } else if (x > (double)(this.leftPos + 175)) {
            if (y > (double)this.topPos && y < (double)(this.topPos + 20)) {
                return true;
            }
            int renderSlots = Math.min(OhmegaConfig.Client.maxColumnSlots(), OhmegaConfig.Client.maxColumnRenderSlots());
            int mostSlotsPerColumn = Math.min(renderSlots, AccessoryHelper.getSlotTypes().size());
            return y > (double)(this.topPos + 20 + 4 + mostSlotsPerColumn * 18 + 4);
        }
        return false;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }
}

