/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.client.screen;

import com.swacky.ohmega.client.screen.AccessoryInventoryScreen;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.network.C2S.OpenAccessoryInventoryPacket;
import com.swacky.ohmega.network.C2S.OpenInventoryPacket;
import com.swacky.ohmega.network.OhmegaNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.world.entity.player.Player;
import org.jspecify.annotations.NonNull;

public final class AccessoryInventoryButton
extends AbstractButton {
    private final AbstractContainerScreen<?> screen;
    private final OhmegaConfig.Client.Service.ButtonStyle style;

    public AccessoryInventoryButton(OhmegaConfig.Client.Service.ButtonStyle style, AbstractContainerScreen<?> screen) {
        super(AccessoryInventoryButton.getXAdjusted(screen, style), screen.topPos + style.getData().y(), style.getData().width(), style.getData().height(), (Component)MutableComponent.create((ComponentContents)PlainTextContents.EMPTY));
        this.screen = screen;
        this.style = style;
    }

    private static int getXAdjusted(AbstractContainerScreen<?> screen, OhmegaConfig.Client.Service.ButtonStyle style) {
        if (screen instanceof AccessoryInventoryScreen) {
            AccessoryInventoryScreen accScreen = (AccessoryInventoryScreen)screen;
            if (OhmegaConfig.Client.side() == OhmegaConfig.Client.Service.Side.LEFT) {
                return screen.leftPos + style.getData().x() + accScreen.getExtraWidth();
            }
        }
        return screen.leftPos + style.getData().x();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVisible() {
        if (!this.visible) return false;
        if (this.screen instanceof AccessoryInventoryScreen) return true;
        AbstractContainerScreen<?> abstractContainerScreen = this.screen;
        if (!(abstractContainerScreen instanceof InventoryScreen)) return false;
        InventoryScreen inventoryScreen = (InventoryScreen)abstractContainerScreen;
        if (inventoryScreen.recipeBookComponent.isVisible()) return false;
        return true;
    }

    private void fixPos() {
        this.setX(AccessoryInventoryButton.getXAdjusted(this.screen, this.style));
        this.setY(this.screen.topPos + this.style.getData().y());
    }

    protected boolean isValidClickButton(@NonNull MouseButtonInfo info) {
        return this.isVisible() && super.isValidClickButton(info);
    }

    public void onPress(@NonNull InputWithModifiers input) {
        LocalPlayer player;
        Minecraft mc = this.screen.minecraft;
        if (mc != null && (player = mc.player) != null) {
            if (!player.isCreative() && !player.isSpectator()) {
                if (this.screen instanceof AccessoryInventoryScreen) {
                    player.containerMenu = player.inventoryMenu;
                    mc.setScreen((Screen)new InventoryScreen((Player)player));
                    OhmegaNetworking.C2S.send(OpenInventoryPacket.INSTANCE);
                } else {
                    OhmegaNetworking.C2S.send(OpenAccessoryInventoryPacket.INSTANCE);
                }
            } else {
                player.containerMenu = player.inventoryMenu;
                mc.setScreen((Screen)new InventoryScreen((Player)player));
                OhmegaNetworking.C2S.send(OpenInventoryPacket.INSTANCE);
            }
        }
    }

    public void updateWidgetNarration(@NonNull NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    protected void renderWidget(@NonNull GuiGraphics gui, int mx, int my, float partialTicks) {
        if (this.isVisible()) {
            int hoveredOffsY;
            int hoveredOffsX;
            this.fixPos();
            if (this.style.highlightWhenHovered() && this.isHoveredOrFocused() || this.screen instanceof AccessoryInventoryScreen) {
                if (this.style.offsetWidthHighlighted()) {
                    hoveredOffsX = this.width;
                    hoveredOffsY = 0;
                } else {
                    hoveredOffsX = 0;
                    hoveredOffsY = this.height;
                }
            } else {
                hoveredOffsX = 0;
                hoveredOffsY = 0;
            }
            gui.blit(RenderPipelines.GUI_TEXTURED, OhmegaCommon.ACCESSORY_LOCATION, this.getX(), this.getY(), (float)this.style.getData().u() + (float)hoveredOffsX, (float)this.style.getData().v() + (float)hoveredOffsY, this.width, this.height, 26, 103);
        }
    }
}

