/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.api.datagen;

import java.util.function.BiConsumer;
import net.minecraft.world.item.Item;

public final class OhmegaLangHelper {
    private final BiConsumer<String, String> adder;
    private final String namespace;

    public OhmegaLangHelper(BiConsumer<String, String> adder, String namespace) {
        this.adder = adder;
        this.namespace = namespace;
    }

    public void addType(String typeKey, String translation) {
        this.adder.accept("accessory_type." + this.namespace + "." + typeKey, translation);
        this.adder.accept("key." + this.namespace + "." + typeKey, translation + " %s");
        this.adder.accept("tag.item." + this.namespace + "." + typeKey, translation);
    }

    public void addItemTooltip(Item item, String translation) {
        this.adder.accept(item.getDescriptionId() + ".tooltip", translation);
    }

    public void addItemKeybindTooltip(Item item, String translation) {
        this.adder.accept(item.getDescriptionId() + ".tooltip.keybind", translation);
    }

    public void addKeyboundItem(Item item, String translation, String tooltipTranslation, String tooltipKeyboundTranslation) {
        this.adder.accept(item.getDescriptionId(), translation);
        this.addItemTooltip(item, tooltipTranslation);
        this.addItemKeybindTooltip(item, tooltipKeyboundTranslation);
    }
}

