/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public final class AccessoryModifiers {
    public static final Codec<AccessoryModifiers> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemAttributeModifiers.CODEC.fieldOf("passiveModifiers").forGetter(AccessoryModifiers::getPassive), (App)ItemAttributeModifiers.CODEC.fieldOf("activeModifiers").forGetter(AccessoryModifiers::getActive)).apply((Applicative)inst, AccessoryModifiers::new));
    private final ItemAttributeModifiers passiveModifiers;
    private final ItemAttributeModifiers activeModifiers;

    private AccessoryModifiers(ItemAttributeModifiers passiveModifiers, ItemAttributeModifiers activeModifiers) {
        this.passiveModifiers = passiveModifiers;
        this.activeModifiers = activeModifiers;
    }

    public ItemAttributeModifiers getPassive() {
        return this.passiveModifiers;
    }

    public ItemAttributeModifiers getActive() {
        return this.activeModifiers;
    }

    public static class Builder {
        private ItemAttributeModifiers.Builder passiveModifiers = ItemAttributeModifiers.builder();
        private ItemAttributeModifiers.Builder activeModifiers = ItemAttributeModifiers.builder();

        public void add(Holder<Attribute> attribute, AttributeModifier modifier, boolean active) {
            if (active) {
                this.activeModifiers.add(attribute, modifier, EquipmentSlotGroup.ANY);
            } else {
                this.passiveModifiers.add(attribute, modifier, EquipmentSlotGroup.ANY);
            }
        }

        public void addPassive(Holder<Attribute> attribute, AttributeModifier modifier) {
            this.add(attribute, modifier, false);
        }

        public void addActive(Holder<Attribute> attribute, AttributeModifier modifier) {
            this.add(attribute, modifier, true);
        }

        public ItemAttributeModifiers getPassiveModifiers() {
            return this.passiveModifiers.build();
        }

        public ItemAttributeModifiers getActiveModifiers() {
            return this.activeModifiers.build();
        }

        public void clear() {
            this.passiveModifiers = ItemAttributeModifiers.builder();
            this.activeModifiers = ItemAttributeModifiers.builder();
        }

        public AccessoryModifiers build() {
            return new AccessoryModifiers(this.passiveModifiers.build(), this.activeModifiers.build());
        }
    }
}

