/*
 * Decompiled with CFR 0.152.
 */
package com.swacky.ohmega.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.swacky.ohmega.api.AccessoryModifiers;
import com.swacky.ohmega.api.IAccessory;
import com.swacky.ohmega.api.event.EquipContext;
import com.swacky.ohmega.common.OhmegaCommon;
import com.swacky.ohmega.common.accessorytype.AccessoryType;
import com.swacky.ohmega.common.accessorytype.AccessoryTypeManager;
import com.swacky.ohmega.common.dataattachment.AccessoryContainer;
import com.swacky.ohmega.common.datacomponent.AccessoryItemDataComponent;
import com.swacky.ohmega.common.init.OhmegaBinds;
import com.swacky.ohmega.common.init.OhmegaDataComponents;
import com.swacky.ohmega.common.init.OhmegaTags;
import com.swacky.ohmega.config.OhmegaConfig;
import com.swacky.ohmega.event.OhmegaHooks;
import com.swacky.ohmega.network.OhmegaNetworking;
import com.swacky.ohmega.network.S2C.SyncAccessorySlotsPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jspecify.annotations.Nullable;

public final class AccessoryHelper {
    private static final Service IMPL = OhmegaCommon.loadService(Service.class);

    public static void bootstrap() {
    }

    public static @Nullable AccessoryItemDataComponent getItemData(ItemStack stack) {
        DataComponentType<AccessoryItemDataComponent> type = OhmegaDataComponents.getItemDataComponent();
        if (stack.has(type)) {
            return (AccessoryItemDataComponent)stack.get(type);
        }
        if (AccessoryHelper.isItemAccessoryBound(stack.getItem())) {
            stack.set(type, (Object)new AccessoryItemDataComponent());
            return (AccessoryItemDataComponent)stack.get(type);
        }
        return null;
    }

    public static AccessoryContainer getContainer(Player player) {
        return IMPL.getContainer(player);
    }

    public static boolean bindAccessory(Item item, IAccessory binding) {
        return OhmegaCommon.bindAccessory(item, binding);
    }

    public static boolean isItemAccessoryBound(Item item) {
        return OhmegaCommon.isItemAccessoryBound(item);
    }

    public static IAccessory getBoundAccessory(Item item) {
        return OhmegaCommon.getBoundAccessory(item);
    }

    public static ImmutableList<AccessoryType> getTypes(Item item) {
        AccessoryType override;
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        if (OhmegaConfig.Server.disableAccessoryTypes()) {
            builder.add((Object)AccessoryType.GENERIC.get());
        }
        if ((override = OhmegaCommon.getTypeOverride(item)) != null) {
            builder.add((Object)override);
        }
        for (OhmegaTags.TagHolder holder : OhmegaTags.getTags()) {
            if (!item.builtInRegistryHolder().is(holder.getTag())) continue;
            builder.add((Object)holder.getType());
        }
        ImmutableSet set = builder.build();
        if (set.isEmpty()) {
            return ImmutableList.of((Object)AccessoryType.NORMAL.get());
        }
        return ImmutableList.copyOf((Collection)set);
    }

    public static AccessoryType getType(Item item) {
        if (OhmegaConfig.Server.disableAccessoryTypes()) {
            return AccessoryType.GENERIC.get();
        }
        AccessoryType override = OhmegaCommon.getTypeOverride(item);
        if (override != null) {
            return override;
        }
        AccessoryType type = null;
        for (OhmegaTags.TagHolder holder : OhmegaTags.getTags()) {
            if (!item.builtInRegistryHolder().is(holder.getTag())) continue;
            AccessoryType holderType = holder.getType();
            if (type != null && holderType.getPriority() >= type.getPriority()) continue;
            type = holderType;
        }
        return type;
    }

    public static int getSlot(ItemStack stack) {
        AccessoryItemDataComponent data = AccessoryHelper.getItemData(stack);
        if (data != null) {
            return data.getSlot();
        }
        return -1;
    }

    public static void setSlot(ItemStack stack, int slot) {
        AccessoryItemDataComponent data = AccessoryHelper.getItemData(stack);
        if (data != null) {
            data.setSlot(slot);
        }
    }

    public static void setNoSlot(ItemStack stack) {
        AccessoryHelper.setSlot(stack, -1);
    }

    public static boolean isActive(ItemStack stack) {
        AccessoryItemDataComponent data = AccessoryHelper.getItemData(stack);
        if (data != null) {
            return data.isActive();
        }
        return false;
    }

    public static void setActive(Player player, ItemStack stack, boolean value) {
        AccessoryItemDataComponent data = AccessoryHelper.getItemData(stack);
        if (data != null) {
            data.setActive(value);
        }
        AccessoryHelper.changeModifiers(player, AccessoryHelper.getModifiers(stack).getActive(), value);
    }

    public static void toggleActive(Player player, ItemStack stack) {
        AccessoryHelper.setActive(player, stack, !AccessoryHelper.isActive(stack));
    }

    public static AccessoryModifiers getModifiers(ItemStack stack) {
        IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
        AccessoryModifiers.Builder builder = new AccessoryModifiers.Builder();
        if (accessory != null) {
            accessory.addDefaultAttributeModifiers(builder);
            OhmegaHooks.accessoryAttributeModifiersEvent(stack, builder);
        }
        return builder.build();
    }

    public static void changeModifiers(Player player, ItemAttributeModifiers modifiers, boolean add) {
        for (ItemAttributeModifiers.Entry entry : modifiers.modifiers()) {
            AttributeInstance attribute = player.getAttribute(entry.attribute());
            if (attribute == null) continue;
            if (add) {
                if (attribute.hasModifier(entry.modifier().id())) continue;
                attribute.addTransientModifier(entry.modifier());
                continue;
            }
            attribute.removeModifier(entry.modifier());
        }
    }

    public static ImmutableList<AccessoryType> getSlotTypes() {
        int size = OhmegaConfig.Server.slotTypes().size();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)size);
        if (OhmegaConfig.Server.disableAccessoryTypes()) {
            for (int i = 0; i < size; ++i) {
                builder.add((Object)AccessoryType.GENERIC.get());
            }
            return builder.build();
        }
        for (String id : OhmegaConfig.Server.slotTypes()) {
            builder.add((Object)AccessoryTypeManager.getInstance().get(ResourceLocation.parse((String)id)));
        }
        return builder.build();
    }

    public static ImmutableList<AccessoryType> getKeyboundSlotTypes() {
        if (OhmegaConfig.Server.disableAccessoryTypes()) {
            return ImmutableList.of((Object)AccessoryType.GENERIC.get());
        }
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String id : OhmegaConfig.Server.keyboundSlotTypes()) {
            builder.add((Object)AccessoryTypeManager.getInstance().get(ResourceLocation.parse((String)id)));
        }
        return builder.build().asList();
    }

    public static MutableComponent getBindTooltip(ItemStack stack, String bindKey, String nonBindKey) {
        int slot = AccessoryHelper.getSlot(stack);
        ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();
        AccessoryType type = slot < 0 || slot >= slotTypes.size() ? null : (AccessoryType)slotTypes.get(slot);
        int typeIndex = 0;
        if (type != null) {
            for (int i = 0; i < slot; ++i) {
                if (slotTypes.get(i) != type) continue;
                ++typeIndex;
            }
        }
        IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
        boolean flag = false;
        if (accessory != null) {
            for (AccessoryType type0 : AccessoryHelper.getKeyboundSlotTypes()) {
                if (!slotTypes.contains((Object)type0)) continue;
                flag = true;
                break;
            }
        }
        KeyMapping mapping = OhmegaBinds.Generated.getMapping(type, typeIndex);
        if (slot < 0 || !flag || mapping == null) {
            return Component.translatable((String)nonBindKey).withStyle(ChatFormatting.GRAY);
        }
        return Component.translatable((String)bindKey, (Object[])new Object[]{mapping.getTranslatedKeyMessage()}).withStyle(ChatFormatting.GRAY);
    }

    public static MutableComponent getBindTooltip(ItemStack stack) {
        String id = stack.getItem().getDescriptionId();
        return AccessoryHelper.getBindTooltip(stack, id + ".tooltip.keybind", id + ".tooltip");
    }

    public static MutableComponent getTypeTooltip(Item item) {
        AccessoryType type = AccessoryHelper.getType(item);
        if (type.displayHoverText()) {
            return Component.translatable((String)"accessory_type", (Object[])new Object[]{type.getTranslation().getString()}).withStyle(ChatFormatting.DARK_GRAY);
        }
        return Component.empty();
    }

    public static int getFirstOpenSlot(Player player, AccessoryType type) {
        AccessoryContainer container = AccessoryHelper.getContainer(player);
        ImmutableList<AccessoryType> slotTypes = AccessoryHelper.getSlotTypes();
        for (int i = 0; i < container.getSlots(); ++i) {
            if (slotTypes.get(i) != type || !container.getStackInSlot(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static InteractionResult tryEquip(Player player, InteractionHand hand) {
        int slot;
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        IAccessory accessory = AccessoryHelper.getBoundAccessory(item);
        if (accessory != null && (slot = AccessoryHelper.getFirstOpenSlot(player, AccessoryHelper.getType(item))) >= 0) {
            ItemStack stack0 = stack.copyWithCount(1);
            if (AccessoryHelper.getContainer(player).setStackInSlot(player, slot, stack0, EquipContext.RIGHT_CLICK_HELD_ITEM)) {
                stack.shrink(1);
                if (accessory.getEquipSound() != null) {
                    player.playSound((SoundEvent)accessory.getEquipSound().value(), 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Deprecated(forRemoval=true, since="1.5.4")
    public static boolean compatibleWith(IAccessory first, IAccessory second) {
        if (first != null && second != null) {
            return first.compatibleWith(second) && second.compatibleWith(first);
        }
        return false;
    }

    @Deprecated(since="1.5.4")
    public static boolean compatibleWith(Player player, IAccessory accessory) {
        for (IAccessory other : AccessoryHelper.getAccessories(player)) {
            if (AccessoryHelper.compatibleWith(accessory, other)) continue;
            return false;
        }
        return true;
    }

    public static NonNullList<ItemStack> getStacks(Player player) {
        return AccessoryHelper.getContainer(player).getStacks();
    }

    public static ArrayList<@Nullable IAccessory> getAccessories(Player player) {
        NonNullList<ItemStack> stacks = AccessoryHelper.getStacks(player);
        ArrayList<IAccessory> accessories = new ArrayList<IAccessory>(stacks.size());
        for (ItemStack stack : stacks) {
            IAccessory accessory = AccessoryHelper.getBoundAccessory(stack.getItem());
            if (accessory == null) continue;
            accessories.add(accessory);
        }
        return accessories;
    }

    public static void syncSlots(ServerPlayer player, int[] slots, List<ItemStack> stacks, Collection<ServerPlayer> receivers) {
        for (ServerPlayer receiver : receivers) {
            OhmegaNetworking.S2C.send(receiver, new SyncAccessorySlotsPacket(player.getId(), slots, stacks));
        }
    }

    public static void syncAllSlots(ServerPlayer player, Set<ServerPlayer> receivers) {
        NonNullList<ItemStack> stacks = AccessoryHelper.getStacks((Player)player);
        int size = stacks.size();
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        AccessoryHelper.syncSlots(player, slots, stacks, receivers);
    }

    public static interface Service {
        public AccessoryContainer getContainer(Player var1);
    }
}

