/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import com.minecolonies.core.tileentities.TileEntityCompostedDirt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final String LEVEL_SIGN_TEXT = "level_placeholder";
    public static List<Tuple<EquipmentTypeEntry, ItemStack>> tools;

    private WorkerUtil() {
    }

    public static List<Tuple<EquipmentTypeEntry, ItemStack>> getOrInitTestTools() {
        if (tools == null) {
            tools = new ArrayList<Tuple<EquipmentTypeEntry, ItemStack>>();
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), new ItemStack((ItemLike)Items.f_42397_)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), new ItemStack((ItemLike)Items.f_42394_)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.axe.get(), new ItemStack((ItemLike)Items.f_42396_)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), new ItemStack((ItemLike)Items.f_42395_)));
        }
        return tools;
    }

    public static boolean isPathBlock(Block block) {
        return block.m_49966_().m_204336_(ModTags.pathingBlocks);
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull AbstractEntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.m_7678_((double)spawnPoint.m_123341_() + 0.5, spawnPoint.m_123342_(), (double)spawnPoint.m_123343_() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        citizen.getNavigation().m_26573_();
        return true;
    }

    public static EquipmentTypeEntry getBestToolForBlock(BlockState state, float blockHardness, AbstractBuilding building, BlockGetter level, BlockPos pos) {
        if (state.m_60734_() instanceof IForgeShearable && building.hasModule(SettingsModule.class) && ((SettingsModule)building.getFirstModuleOccurance(SettingsModule.class)).getSettingValueOrDefault(AbstractBuilding.USE_SHEARS, true).booleanValue()) {
            return (EquipmentTypeEntry)ModEquipmentTypes.shears.get();
        }
        if (blockHardness > 0.0f) {
            for (Tuple<EquipmentTypeEntry, ItemStack> tool : WorkerUtil.getOrInitTestTools()) {
                IMateriallyTexturedBlock materiallyTexturedBlock;
                if (tool.getB() == null || !(tool.getB().m_41720_() instanceof DiggerItem)) continue;
                Block block = state.m_60734_();
                if (block instanceof IMateriallyTexturedBlock && (materiallyTexturedBlock = (IMateriallyTexturedBlock)block).isCorrectToolForDrops(state, tool.getB(), level, pos)) {
                    return tool.getA();
                }
                if (!tool.getB().m_41735_(state)) continue;
                return tool.getA();
            }
        }
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    public static int getCorrectHarvestLevelForBlock(BlockState target) {
        int required = 0;
        List tiers = TierSortingRegistry.getSortedTiers();
        for (Tier tier : tiers) {
            TagKey tag = tier.getTag();
            if (tag == null || !target.m_204336_(tag)) continue;
            required = tier.m_6604_();
            break;
        }
        if (required < 0 || target.m_60734_() instanceof GlazedTerracottaBlock) {
            return 0;
        }
        return required;
    }

    public static void faceBlock(@Nullable BlockPos block, AbstractEntityCitizen citizen) {
        if (block == null) {
            return;
        }
        double xDifference = block.m_123341_() - citizen.m_20183_().m_123341_();
        double zDifference = block.m_123343_() - citizen.m_20183_().m_123343_();
        double yDifference = (float)block.m_123342_() - ((float)citizen.m_20183_().m_123342_() + citizen.m_20192_());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.setOwnRotation((float)EntityUtils.updateRotation(citizen.getRotationYaw(), intendedRotationYaw, 30.0), (float)EntityUtils.updateRotation(citizen.getRotationPitch(), intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        citizen.m_6478_(MoverType.SELF, new Vec3((double)((float)goToX), 0.0, (double)((float)goToZ)));
    }

    @Nullable
    public static BlockPos findFirstLevelSign(Blueprint structure, BlockPos pos) {
        for (int j = 0; j < structure.getSizeY(); ++j) {
            for (int k = 0; k < structure.getSizeZ(); ++k) {
                for (int i = 0; i < structure.getSizeX(); ++i) {
                    SignBlockEntity sign;
                    BlockEntity blockEntity;
                    BlockEntityType teType;
                    @NotNull BlockPos localPos = new BlockPos(i, j, k);
                    BlockInfo te = (BlockInfo)structure.getBlockInfoAsMap().get(localPos);
                    if (te == null) continue;
                    CompoundTag teData = te.getTileEntityData();
                    ResourceLocation teId = teData == null ? null : ResourceLocation.m_135820_((String)teData.m_128461_("id"));
                    BlockEntityType blockEntityType = teType = teId == null ? null : (BlockEntityType)ForgeRegistries.BLOCK_ENTITY_TYPES.getValue(teId);
                    if (teType != BlockEntityType.f_58924_ && teType != BlockEntityType.f_244529_ || !((blockEntity = BlockEntity.m_155241_((BlockPos)te.getPos(), (BlockState)te.getState(), (CompoundTag)te.getTileEntityData())) instanceof SignBlockEntity) || !(sign = (SignBlockEntity)blockEntity).m_277142_().m_277138_(0, false).getString().equals(LEVEL_SIGN_TEXT)) continue;
                    return pos.m_121996_((Vec3i)structure.getPrimaryBlockOffset()).m_121955_((Vec3i)localPos);
                }
            }
        }
        return null;
    }

    public static void updateLevelSign(Level world, MinerLevel level, int levelId) {
        BlockEntity blockEntity;
        @Nullable BlockPos levelSignPos = level.getLevelSign();
        if (levelSignPos != null && (blockEntity = world.m_7702_(levelSignPos)) instanceof SignBlockEntity) {
            SignBlockEntity teLevelSign = (SignBlockEntity)blockEntity;
            BlockState blockState = world.m_8055_(levelSignPos);
            SignText text = new SignText().m_276913_(0, (Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.minerminenode").m_130946_(": " + levelId)).m_276913_(1, (Component)Component.m_237113_((String)("Y: " + (level.getDepth() + 1)))).m_276913_(2, (Component)Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.minernode").m_130946_(": " + level.getNumberOfBuiltNodes())).m_276913_(3, (Component)Component.m_237113_((String)""));
            teLevelSign.m_276956_(text, true);
            teLevelSign.m_276956_(text, false);
            teLevelSign.m_6596_();
            world.m_7260_(levelSignPos, blockState, blockState, 3);
        }
    }

    public static boolean isThereCompostedLand(BuildingFlorist buildingFlorist, Level world) {
        for (BlockPos pos : buildingFlorist.getPlantGround()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (!((TileEntityCompostedDirt)entity).isComposted()) continue;
                return true;
            }
            buildingFlorist.removePlantableGround(pos);
        }
        return false;
    }

    public static int getLastLadder(@NotNull BlockPos pos, Level world) {
        if (world.m_8055_(pos).m_60734_().isLadder(world.m_8055_(pos), (LevelReader)world, pos, null)) {
            return WorkerUtil.getLastLadder(pos.m_7495_(), world);
        }
        return pos.m_123342_() + 1;
    }

    public static boolean hasTooManyExternalItemsInInv(IRecipeStorage currentRecipeStorage, @NotNull InventoryCitizen inv) {
        int count = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_() || WorkerUtil.isPartOfRecipe(stack, currentRecipeStorage) || ++count <= 3) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfRecipe(ItemStack stack, IRecipeStorage currentRecipeStorage) {
        if (ItemStackUtils.compareItemStacksIgnoreStackSize(stack, currentRecipeStorage.getPrimaryOutput()).booleanValue()) {
            return true;
        }
        for (ItemStack itemStack : currentRecipeStorage.getCraftingToolsAndSecondaryOutputs()) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack).booleanValue()) continue;
            return true;
        }
        for (ItemStorage itemStorage : currentRecipeStorage.getCleanedInput()) {
            if (!itemStorage.equals(new ItemStorage(stack))) continue;
            return true;
        }
        return false;
    }
}

