/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.ColonyConnectionNode;
import com.minecolonies.api.tileentities.ITickable;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TileEntityColonySign
extends BlockEntity
implements ITickable {
    private int colonyId = -1;
    private int targetColonyId = -1;
    private BlockPos anchor = null;
    private String colonyNameCache = "";
    private String targetColonyNameCache = "";
    private float rotation;
    private int distance;
    private int targetColonyDistance;
    private final int tickOffset;
    private int cachedSignAboveColony = -1;
    private BlockPos previousPosition = BlockPos.f_121853_;
    private BlockPos nextPosition = BlockPos.f_121853_;

    public TileEntityColonySign(BlockPos pos, BlockState state) {
        super((BlockEntityType)MinecoloniesTileEntities.COLONY_SIGN.get(), pos, state);
        this.tickOffset = MathUtils.RANDOM.nextInt(20);
    }

    public void m_6596_() {
        if (this.f_58857_ != null) {
            WorldUtil.markChunkDirty(this.f_58857_, this.f_58858_);
        }
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.colonyId = compound.m_128451_("colony");
        this.colonyNameCache = compound.m_128461_("name");
        if (compound.m_128441_("pos")) {
            this.anchor = BlockPosUtil.read(compound, "pos");
        }
        this.rotation = compound.m_128457_("rotation");
        this.targetColonyId = compound.m_128451_("targetcolony");
        this.targetColonyNameCache = compound.m_128461_("targetname");
        this.distance = compound.m_128451_("distance");
        this.targetColonyDistance = compound.m_128451_("targetdistance");
        if (compound.m_128441_("cachedabove")) {
            this.cachedSignAboveColony = compound.m_128451_("cachedabove");
        }
        if (compound.m_128441_("prevpos")) {
            this.previousPosition = BlockPosUtil.read(compound, "prevpos");
        }
        if (compound.m_128441_("nextpos")) {
            this.nextPosition = BlockPosUtil.read(compound, "nextpos");
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("colony", this.colonyId);
        compound.m_128359_("name", this.colonyNameCache);
        if (this.anchor != null) {
            BlockPosUtil.write(compound, "pos", this.anchor);
        }
        compound.m_128350_("rotation", this.rotation);
        compound.m_128405_("targetcolony", this.targetColonyId);
        compound.m_128359_("targetname", this.targetColonyNameCache);
        compound.m_128405_("distance", this.distance);
        compound.m_128405_("targetdistance", this.targetColonyDistance);
        compound.m_128405_("cachedabove", this.cachedSignAboveColony);
        BlockPosUtil.write(compound, "nextpos", this.nextPosition);
        BlockPosUtil.write(compound, "prevpos", this.previousPosition);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag compound = packet.m_131708_();
        this.m_142466_(compound);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && (this.f_58857_.m_46467_() + (long)this.tickOffset) % 20L * 60L == 0L) {
            IColony colony;
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
            if (blockEntity instanceof TileEntityColonySign) {
                TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
                if (this.cachedSignAboveColony != tileEntityColonySign.getColonyId()) {
                    this.cachedSignAboveColony = tileEntityColonySign.getColonyId();
                    this.m_6596_();
                }
            } else {
                this.cachedSignAboveColony = -1;
            }
            if ((colony = IColonyManager.getInstance().getColonyByDimension(this.colonyId, (ResourceKey<Level>)this.f_58857_.m_46472_())) != null) {
                ColonyConnectionNode node;
                if (!colony.getName().equals(this.colonyNameCache)) {
                    this.colonyNameCache = colony.getName();
                    this.m_6596_();
                }
                if ((node = colony.getConnectionManager().getNode(this.m_58899_())) != null) {
                    BlockPos nextNodePos;
                    this.calculateRotation(node.getPreviousNode());
                    BlockPos previousNodePos = node.getPreviousNode();
                    if (!previousNodePos.equals((Object)BlockPos.f_121853_) && WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, previousNodePos)) {
                        int prevDistance = this.distance;
                        BlockEntity blockEntity2 = this.f_58857_.m_7702_(previousNodePos);
                        if (blockEntity2 instanceof TileEntityColonySign) {
                            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity2;
                            this.distance = (int)BlockPosUtil.dist(previousNodePos, this.m_58899_()) + tileEntityColonySign.distance;
                        } else {
                            this.distance = (int)BlockPosUtil.dist(previousNodePos, this.m_58899_());
                        }
                        if (prevDistance != this.distance) {
                            this.m_6596_();
                        }
                    }
                    if (!previousNodePos.equals((Object)BlockPos.f_121853_) && !previousNodePos.equals((Object)this.previousPosition)) {
                        this.previousPosition = previousNodePos;
                        this.m_6596_();
                    }
                    if (!(nextNodePos = node.getNextNode()).equals((Object)this.nextPosition)) {
                        this.nextPosition = nextNodePos;
                        this.m_6596_();
                    }
                    this.targetColonyId = node.getTargetColonyId();
                    if (this.targetColonyId != -1) {
                        IColony targetColony;
                        if (!nextNodePos.equals((Object)BlockPos.f_121853_) && WorldUtil.isBlockLoaded((LevelAccessor)this.f_58857_, nextNodePos)) {
                            int prevDistance = this.targetColonyDistance;
                            BlockEntity blockEntity3 = this.f_58857_.m_7702_(nextNodePos);
                            if (blockEntity3 instanceof TileEntityColonySign) {
                                TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity3;
                                this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.m_58899_()) + tileEntityColonySign.targetColonyDistance;
                            } else {
                                this.targetColonyDistance = (int)BlockPosUtil.dist(nextNodePos, this.m_58899_());
                            }
                            if (prevDistance != this.targetColonyDistance) {
                                this.m_6596_();
                            }
                        }
                        if ((targetColony = IColonyManager.getInstance().getColonyByDimension(this.targetColonyId, (ResourceKey<Level>)this.f_58857_.m_46472_())) != null && !this.targetColonyNameCache.equals(targetColony.getName())) {
                            this.targetColonyNameCache = targetColony.getName();
                            this.m_6596_();
                        }
                    }
                }
            }
        }
    }

    private void calculateRotation(BlockPos previousNode) {
        double dx = (double)previousNode.m_123341_() + 0.5 - ((double)this.m_58899_().m_123341_() + 0.5);
        double dz = (double)previousNode.m_123343_() + 0.5 - ((double)this.m_58899_().m_123343_() + 0.5);
        double angleRad = Math.atan2(-dz, dx);
        float angleDeg = (float)Math.toDegrees(angleRad);
        this.rotation = (angleDeg + 360.0f) % 360.0f;
    }

    public void setColonyAndAnchor(IColony colony, @Nullable BlockPos anchor) {
        this.colonyId = colony.getID();
        this.anchor = anchor == null ? colony.getCenter() : anchor;
        this.distance = (int)BlockPosUtil.dist(colony.getCenter(), this.m_58899_());
        this.colonyNameCache = colony.getName();
        this.calculateRotation(this.anchor);
    }

    public String getColonyName() {
        return this.colonyNameCache;
    }

    public float getRelativeRotation() {
        return this.rotation;
    }

    public int getColonyDistance() {
        return this.distance;
    }

    public int getColonyId() {
        return this.colonyId;
    }

    public int getTargetColonyId() {
        return this.targetColonyId;
    }

    public String getTargetColonyName() {
        return this.targetColonyNameCache;
    }

    public int getTargetColonyDistance() {
        return this.targetColonyDistance;
    }

    public int getCachedSignAboveColony() {
        return this.cachedSignAboveColony;
    }

    @NotNull
    public BlockPos getPreviousPos() {
        return this.previousPosition;
    }

    @NotNull
    public BlockPos getNextPosition() {
        return this.nextPosition;
    }
}

