/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.FinishedQuest;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestTemplate;
import com.minecolonies.core.quests.QuestInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class QuestManager
implements IQuestManager {
    private final Map<ResourceLocation, IQuestInstance> availableQuests = new HashMap<ResourceLocation, IQuestInstance>();
    private final Map<ResourceLocation, Integer> finishedQuests = new HashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, IQuestInstance> inProgressQuests = new HashMap<ResourceLocation, IQuestInstance>();
    private final List<ResourceLocation> unlockedQuests = new ArrayList<ResourceLocation>();
    private List<FinishedQuest> finishedQuestsCache = null;
    private double questReputation = 0.0;
    private final IColony colony;
    private boolean isDirty = true;

    public QuestManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public boolean attemptAcceptQuest(ResourceLocation questID, Player player) {
        IQuestInstance quest = this.availableQuests.getOrDefault(questID, null);
        if (quest == null || !quest.isValid(this.colony)) {
            return false;
        }
        this.inProgressQuests.put(questID, quest);
        this.availableQuests.remove(questID);
        this.markDirty();
        return true;
    }

    @Override
    public void alterReputation(double difference) {
        this.questReputation += difference;
        this.markDirty();
    }

    @Override
    public double getReputation() {
        return this.questReputation;
    }

    @Override
    public void completeQuest(ResourceLocation questId) {
        if (this.inProgressQuests.containsKey(questId)) {
            this.inProgressQuests.remove(questId);
            this.finishedQuests.put(questId, this.finishedQuests.getOrDefault(questId, 0) + 1);
            this.markDirty();
        } else if (this.availableQuests.containsKey(questId)) {
            this.availableQuests.remove(questId);
            this.finishedQuests.put(questId, this.finishedQuests.getOrDefault(questId, 0) + 1);
            this.markDirty();
        }
        this.finishedQuestsCache = null;
    }

    @Override
    public void onColonyTick() {
        for (Map.Entry entry : GLOBAL_SERVER_QUESTS.entrySet()) {
            IQuestInstance colonyQuest;
            if (this.availableQuests.containsKey(entry.getKey()) || this.inProgressQuests.containsKey(entry.getKey()) || this.finishedQuests.getOrDefault(entry.getKey(), 0) >= ((IQuestTemplate)entry.getValue()).getMaxOccurrence()) continue;
            boolean missingParent = false;
            for (ResourceLocation parent : ((IQuestTemplate)entry.getValue()).getParents()) {
                if (this.finishedQuests.containsKey(parent)) continue;
                missingParent = true;
                break;
            }
            if (missingParent || (colonyQuest = ((IQuestTemplate)entry.getValue()).attemptStart(this.colony)) == null) continue;
            this.availableQuests.put((ResourceLocation)entry.getKey(), colonyQuest);
            this.markDirty();
        }
        for (Map.Entry<Object, Object> entry : new ArrayList<Map.Entry<ResourceLocation, IQuestInstance>>(this.availableQuests.entrySet())) {
            if (GLOBAL_SERVER_QUESTS.containsKey(entry.getKey()) && ((IQuestInstance)entry.getValue()).isValid(this.colony)) continue;
            ((IQuestInstance)entry.getValue()).onDeletion();
            this.availableQuests.remove(entry.getKey());
            this.markDirty();
        }
        for (Map.Entry<Object, Object> entry : new ArrayList<Map.Entry<ResourceLocation, IQuestInstance>>(this.inProgressQuests.entrySet())) {
            if (GLOBAL_SERVER_QUESTS.containsKey(entry.getKey()) && ((IQuestInstance)entry.getValue()).isValid(this.colony)) continue;
            ((IQuestInstance)entry.getValue()).onDeletion();
            this.inProgressQuests.remove(entry.getKey());
            this.markDirty();
        }
    }

    @Override
    public void deleteQuest(ResourceLocation questID) {
        this.availableQuests.remove(questID);
        this.inProgressQuests.remove(questID);
        this.markDirty();
    }

    @Override
    public IQuestInstance getAvailableOrInProgressQuest(ResourceLocation questId) {
        return this.availableQuests.containsKey(questId) ? this.availableQuests.get(questId) : this.inProgressQuests.get(questId);
    }

    @Override
    public void onWorldLoad() {
        for (IQuestInstance colonyQuest : this.inProgressQuests.values()) {
            colonyQuest.onWorldLoad();
        }
    }

    @Override
    public void unlockQuest(ResourceLocation questId) {
        this.unlockedQuests.add(questId);
        this.markDirty();
    }

    @Override
    public boolean isUnlocked(ResourceLocation questId) {
        return this.unlockedQuests.contains(questId);
    }

    public CompoundTag serializeNBT() {
        CompoundTag managerCompound = new CompoundTag();
        ListTag availableListTag = new ListTag();
        for (Map.Entry<ResourceLocation, IQuestInstance> entry : this.availableQuests.entrySet()) {
            availableListTag.add((Object)entry.getValue().serializeNBT());
        }
        managerCompound.m_128365_("availquests", (Tag)availableListTag);
        ListTag inProgressListTag = new ListTag();
        for (Map.Entry<ResourceLocation, IQuestInstance> entry : this.inProgressQuests.entrySet()) {
            inProgressListTag.add((Object)entry.getValue().serializeNBT());
        }
        managerCompound.m_128365_("inprogquests", (Tag)inProgressListTag);
        ListTag listTag = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.finishedQuests.entrySet()) {
            CompoundTag finishedTag = new CompoundTag();
            finishedTag.m_128359_("id", entry.getKey().toString());
            finishedTag.m_128405_("quantity", entry.getValue().intValue());
            listTag.add((Object)finishedTag);
        }
        managerCompound.m_128365_("finishedquests", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (ResourceLocation unlocked : this.unlockedQuests) {
            CompoundTag unlockedTag = new CompoundTag();
            unlockedTag.m_128359_("id", unlocked.toString());
            listTag2.add((Object)unlockedTag);
        }
        managerCompound.m_128365_("unlockedquests", (Tag)listTag2);
        managerCompound.m_128347_("questreputation", this.questReputation);
        return managerCompound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        HashMap<ResourceLocation, IQuestInstance> localAvailableQuests = new HashMap<ResourceLocation, IQuestInstance>();
        ListTag availableListTag = nbt.m_128437_("availquests", 10);
        for (Tag element : availableListTag) {
            ResourceLocation key = new ResourceLocation(((CompoundTag)element).m_128461_("id"));
            if (!GLOBAL_SERVER_QUESTS.containsKey(key)) continue;
            IQuestInstance colonyQuest = this.availableQuests.containsKey(key) ? this.availableQuests.get(key) : new QuestInstance(this.colony);
            colonyQuest.deserializeNBT((Tag)((CompoundTag)element));
            localAvailableQuests.put(colonyQuest.getId(), colonyQuest);
        }
        this.availableQuests.clear();
        this.availableQuests.putAll(localAvailableQuests);
        HashMap<ResourceLocation, IQuestInstance> localInProgressQuests = new HashMap<ResourceLocation, IQuestInstance>();
        ListTag inProgressListTag = nbt.m_128437_("inprogquests", 10);
        for (Object element : inProgressListTag) {
            ResourceLocation key = new ResourceLocation(((CompoundTag)element).m_128461_("id"));
            if (!GLOBAL_SERVER_QUESTS.containsKey(key)) continue;
            IQuestInstance colonyQuest = this.inProgressQuests.containsKey(key) ? this.inProgressQuests.get(key) : new QuestInstance(this.colony);
            colonyQuest.deserializeNBT((Tag)((CompoundTag)element));
            localInProgressQuests.put(colonyQuest.getId(), colonyQuest);
        }
        this.inProgressQuests.clear();
        this.inProgressQuests.putAll(localInProgressQuests);
        this.finishedQuests.clear();
        ListTag finishedListTag = nbt.m_128437_("finishedquests", 10);
        for (Tag element : finishedListTag) {
            this.finishedQuests.put(new ResourceLocation(((CompoundTag)element).m_128461_("id")), ((CompoundTag)element).m_128451_("quantity"));
        }
        this.finishedQuestsCache = null;
        this.unlockedQuests.clear();
        ListTag unlockedListTag = nbt.m_128437_("unlockedquests", 10);
        for (Tag element : unlockedListTag) {
            this.unlockedQuests.add(new ResourceLocation(((CompoundTag)element).m_128461_("id")));
        }
        this.questReputation = nbt.m_128459_("questreputation");
    }

    @Override
    public void serialize(FriendlyByteBuf buf, boolean hasNewSubscribers) {
        buf.writeBoolean(this.isDirty || hasNewSubscribers);
        if (this.isDirty || hasNewSubscribers) {
            buf.m_130079_(this.serializeNBT());
        }
    }

    @Override
    public void deserialize(FriendlyByteBuf buf) {
        boolean hasData = buf.readBoolean();
        if (hasData) {
            this.deserializeNBT(buf.m_130260_());
        }
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    @Override
    public List<IQuestInstance> getAvailableQuests() {
        return new ArrayList<IQuestInstance>(this.availableQuests.values());
    }

    @Override
    public List<IQuestInstance> getInProgressQuests() {
        return new ArrayList<IQuestInstance>(this.inProgressQuests.values());
    }

    @Override
    public List<FinishedQuest> getFinishedQuests() {
        if (this.finishedQuestsCache == null) {
            ArrayList<FinishedQuest> data = new ArrayList<FinishedQuest>();
            for (Map.Entry<ResourceLocation, Integer> entry : this.finishedQuests.entrySet()) {
                IQuestTemplate template = (IQuestTemplate)GLOBAL_SERVER_QUESTS.get(entry.getKey());
                if (template == null) continue;
                data.add(new FinishedQuest(template, entry.getValue()));
            }
            this.finishedQuestsCache = Collections.unmodifiableList(data);
        }
        return this.finishedQuestsCache;
    }

    @Override
    public void injectAvailableQuest(IQuestInstance questInstance) {
        this.availableQuests.put(questInstance.getId(), questInstance);
        this.markDirty();
    }
}

