/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScepterPermission
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final String TAG_ITEM_MODE = "scepterMode";
    private static final String TAG_VALUE_MODE_BLOCK = "modeBlock";
    private static final String TAG_VALUE_MODE_LOCATION = "modeLocation";
    private static final int GREEN_OVERLAY = -16711936;
    private static final int BLOCK_OVERLAY_RANGE_XZ = 32;
    private static final int BLOCK_OVERLAY_RANGE_Y = 6;

    public ItemScepterPermission(Item.Properties properties) {
        super("scepterpermission", properties.m_41487_(1).m_41503_(2));
    }

    @NotNull
    private static InteractionResult handleAddBlockType(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        BlockState blockState = iColonyView.getWorld().m_8055_(pos);
        Block block = blockState.m_60734_();
        ChangeFreeToInteractBlockMessage.MessageType type = Screen.m_96637_() ? ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK : ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK;
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, block, type);
        Network.getNetwork().sendToServer(message);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private static InteractionResult handleAddLocation(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        ChangeFreeToInteractBlockMessage.MessageType type = Screen.m_96637_() ? ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK : ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK;
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, pos, type);
        Network.getNetwork().sendToServer(message);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        IColonyView iColonyView;
        if (!ctx.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack scepter = ctx.m_43723_().m_21120_(ctx.m_43724_());
        if (!scepter.m_41782_()) {
            scepter.m_41751_(new CompoundTag());
        }
        if ((iColonyView = IColonyManager.getInstance().getClosestColonyView(ctx.m_43725_(), ctx.m_8083_())) == null) {
            return InteractionResult.FAIL;
        }
        CompoundTag compound = scepter.m_41783_();
        return ItemScepterPermission.handleItemAction(compound, ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), iColonyView);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack scepter = playerIn.m_21120_(hand);
        if (worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
        }
        if (!scepter.m_41782_()) {
            scepter.m_41751_(new CompoundTag());
        }
        CompoundTag compound = scepter.m_41783_();
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
    }

    private static void toggleItemMode(Player playerIn, CompoundTag compound) {
        String itemMode;
        switch (itemMode = compound.m_128461_(TAG_ITEM_MODE)) {
            case "modeBlock": {
                compound.m_128359_(TAG_ITEM_MODE, TAG_VALUE_MODE_LOCATION);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.location", new Object[0]).create()).sendTo(playerIn);
                break;
            }
            default: {
                compound.m_128359_(TAG_ITEM_MODE, TAG_VALUE_MODE_BLOCK);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.block", new Object[0]).create()).sendTo(playerIn);
            }
        }
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        String itemMode;
        ArrayList<IBlockOverlayItem.OverlayBox> boxes = new ArrayList<IBlockOverlayItem.OverlayBox>();
        IColonyView colony = IColonyManager.getInstance().getClosestColonyView(world, player.m_20183_());
        if (colony == null || !colony.getPermissions().hasPermission(player, Action.EDIT_PERMISSIONS)) {
            return boxes;
        }
        switch (itemMode = stack.m_41784_().m_128461_(TAG_ITEM_MODE)) {
            case "modeBlock": {
                HashSet<Block> freeBlocks = new HashSet<Block>(colony.getFreeBlocks());
                for (BlockPos pos : BlockPos.m_121925_((BlockPos)player.m_20183_(), (int)32, (int)6, (int)32)) {
                    if (!world.m_46749_(pos) || !freeBlocks.contains(world.m_8055_(pos).m_60734_())) continue;
                    boxes.add(new IBlockOverlayItem.OverlayBox(AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)pos)), -16711936, 0.02f, true));
                }
                break;
            }
            default: {
                for (BlockPos pos : colony.getFreePositions()) {
                    boxes.add(new IBlockOverlayItem.OverlayBox(AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)pos)), -16711936, 0.02f, true));
                }
            }
        }
        return boxes;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        String itemMode;
        tooltip.add((Component)Component.m_237110_((String)"com.minecolonies.coremod.item.permissionscepter.mode", (Object[])new Object[]{(switch (itemMode = stack.m_41784_().m_128461_(TAG_ITEM_MODE)) {
            case TAG_VALUE_MODE_BLOCK -> Component.m_237115_((String)"com.minecolonies.coremod.item.permissionscepter.mode.block");
            default -> Component.m_237115_((String)"com.minecolonies.coremod.item.permissionscepter.mode.location");
        }).m_130940_(ChatFormatting.YELLOW)}));
        super.m_7373_(stack, level, tooltip, flags);
    }

    @NotNull
    private static InteractionResult handleItemAction(CompoundTag compound, Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        String tagItemMode;
        switch (tagItemMode = compound.m_128461_(TAG_ITEM_MODE)) {
            case "modeBlock": {
                return ItemScepterPermission.handleAddBlockType(playerIn, worldIn, pos, iColonyView);
            }
            case "modeLocation": {
                return ItemScepterPermission.handleAddLocation(playerIn, worldIn, pos, iColonyView);
            }
        }
        ItemScepterPermission.toggleItemMode(playerIn, compound);
        return ItemScepterPermission.handleItemAction(compound, playerIn, worldIn, pos, iColonyView);
    }
}

