/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;

public class PathJobPathway
extends AbstractPathJob
implements IDestinationPathJob {
    private final List<IBuilding> buildings;
    private int colonyid = -1;
    private double addCost = 1.0;
    private final BlockPos end;

    public PathJobPathway(int colonyID, List<IBuilding> buildings, Level world, @NotNull BlockPos start, BlockPos end, EntityCitizen citizen) {
        super(world, start, end, new PathResult(), (Mob)citizen);
        this.colonyid = colonyID;
        this.buildings = buildings;
        this.end = end;
        this.setPathingOptions(new PathingOptions().withJumpCost(30.0).withStartSwimCost(30.0).withSwimCost(5.0).withCanSwim(true).withCanEnterDoors(true).withCanEnterGates(true));
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        LevelChunk chunk = (LevelChunk)this.world.m_6325_(x >> 4, z >> 4);
        if (ColonyUtils.getOwningColony(chunk) == this.colonyid) {
            return Math.sqrt(BlockPosUtil.distSqr(this.end.m_123341_(), this.end.m_123342_(), this.end.m_123343_(), x, y, z)) / (double)(ColonyUtils.getAllClaimingBuildings(chunk).size() + 1);
        }
        return Math.sqrt(BlockPosUtil.distSqr(this.end.m_123341_(), this.end.m_123342_(), this.end.m_123343_(), x, y, z));
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        return BlockPosUtil.distSqr(this.end, n.x, n.y, n.z) < 25;
    }

    @Override
    protected double getEndNodeScore(MNode n) {
        double dist = BlockPosUtil.dist(this.end, n.x, n.y, n.z);
        if (dist < 15.0) {
            return n.getCost();
        }
        return dist;
    }

    @Override
    protected boolean isPassable(int x, int y, int z, boolean head, MNode currentnode) {
        if (super.isPassable(x, y, z, head, currentnode)) {
            for (IBuilding building : this.buildings) {
                if (!BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), (BlockPos)this.tempWorldPos.m_122178_(x, y, z)) || BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), this.end) || BlockPosUtil.isInArea((BlockPos)building.getCorners().m_14418_(), (BlockPos)building.getCorners().m_14419_(), this.start)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected double modifyCost(double stepCost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        if (parent.parent != null && parent.x == parent.parent.x && x != parent.x) {
            return stepCost * 10.0;
        }
        if (parent.parent != null && parent.z == parent.parent.z && z != parent.z) {
            return stepCost * 10.0;
        }
        return stepCost;
    }

    @Override
    public BlockPos getDestination() {
        return this.end;
    }
}

