/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class NewBobberEntity
extends Projectile
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.m_135353_(NewBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int XP_PER_CATCH = 2;
    private boolean inGround;
    private int ticksInGround;
    private EntityCitizen angler;
    private int tickRemove = 100;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    public Entity caughtEntity;
    private State currentState = State.FLYING;
    private int luck;
    private int lureSpeed;
    private int anglerId = -1;
    private boolean readyToCatch = false;
    private Vec3 onWaterPos;

    public NewBobberEntity(EntityType<? extends Projectile> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public NewBobberEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(ModEntities.FISHHOOK, world);
    }

    public void setAngler(EntityCitizen citizen, int luck, int lureSpeed) {
        this.angler = citizen;
        float pitch = (float)(Math.random() * 40.0 - 10.0);
        float yaw = this.angler.m_146908_();
        float cowYaw = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        double xYaw = this.angler.m_20185_() - (double)sinYaw * 0.3;
        double eyePos = this.angler.m_20188_();
        double zYaw = this.angler.m_20189_() - (double)cowYaw * 0.3;
        this.m_7678_(xYaw, eyePos, zYaw, yaw, pitch);
        Vec3 vec = new Vec3((double)(-sinYaw), (double)Mth.m_14036_((float)(-(sinPitch / cosPitch)), (float)-5.0f, (float)5.0f), (double)(-cowYaw));
        double d3 = vec.m_82553_();
        vec = vec.m_82542_(0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045, 0.6 / d3 + 0.5 + this.f_19796_.m_188583_() * 0.0045);
        this.m_20256_(vec);
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)Mth.m_14116_((float)((float)vec.m_165925_()))) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.m_20088_().m_135370_(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.f_19853_.m_6815_(i - 1) : null;
        }
        super.m_7350_(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_() && --this.tickRemove <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.angler == null) {
            if (this.f_19853_.f_46443_) {
                if (this.anglerId > -1) {
                    this.angler = (EntityCitizen)this.f_19853_.m_6815_(this.anglerId);
                }
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else if (this.f_19853_.f_46443_ || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = this.m_20183_();
            FluidState ifluidstate = this.f_19853_.m_6425_(blockpos);
            if (ifluidstate.m_205070_(FluidTags.f_13131_)) {
                f = ifluidstate.m_76155_((BlockGetter)this.f_19853_, blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.m_20256_(Vec3.f_82478_);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.f_19853_.f_46443_) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.m_20096_() || this.f_19862_)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (this.caughtEntity.m_213877_()) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.m_6034_(this.caughtEntity.m_20185_(), this.caughtEntity.m_20227_(0.8), this.caughtEntity.m_20189_());
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vec3 Vector3d = this.m_20184_();
                    double d0 = this.m_20186_() + Vector3d.f_82480_ - (double)blockpos.m_123342_() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.m_20334_(Vector3d.f_82479_ * 0.9, Vector3d.f_82480_ - d0 * (double)this.f_19796_.m_188501_() * 0.2, Vector3d.f_82481_ * 0.9);
                    if (!this.f_19853_.f_46443_ && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.m_205070_(FluidTags.f_13131_)) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_37283_();
            this.m_20256_(this.m_20184_().m_82490_(0.92));
            this.m_20090_();
        }
    }

    public boolean shouldStopFishing() {
        ItemStack itemstack = this.angler.m_21205_();
        ItemStack itemstack1 = this.angler.m_21206_();
        boolean flag = itemstack.canPerformAction(ToolActions.FISHING_ROD_CAST);
        boolean flag1 = itemstack1.canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (!this.angler.m_213877_() && this.angler.m_6084_() && (flag || flag1) && !(this.m_20280_((Entity)this.angler) > 1024.0)) {
            return false;
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return true;
    }

    protected void m_37283_() {
        Vec3 vec = this.m_20184_();
        float f = Mth.m_14116_((float)((float)vec.m_165925_()));
        this.m_146922_((float)(Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec.f_82480_, (double)f) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitresult.m_6662_() == HitResult.Type.MISS || !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    private void setHookedEntity() {
        this.m_20088_().m_135381_(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.m_19879_() + 1));
    }

    private void catchingFish(BlockPos p_190621_1_) {
        ServerLevel serverworld = (ServerLevel)this.f_19853_;
        int i = 1;
        BlockPos blockpos = p_190621_1_.m_7494_();
        if (this.f_19796_.m_188501_() < 0.25f && this.f_19853_.m_46758_(blockpos)) {
            ++i;
        }
        if (this.f_19796_.m_188501_() < 0.5f && !this.f_19853_.m_45527_(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.2 * (double)this.f_19796_.m_188501_() * (double)this.f_19796_.m_188501_(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                double d1;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.f_19796_.m_188583_() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = Mth.m_14031_((float)f);
                float f2 = Mth.m_14089_((float)f);
                double d0 = this.m_20185_() + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                if (serverworld.m_8055_(new BlockPos((int)d0, (int)(d1 = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1, (int)(d2 = this.m_20189_() + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)))).m_60713_(Blocks.f_49990_)) {
                    if (this.f_19796_.m_188501_() < 0.15f) {
                        serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.readyToCatch = true;
                this.onWaterPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Vec3 Vector3d = this.m_20184_();
                this.m_20334_(Vector3d.f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.f_19796_, (float)0.6f, (float)1.0f), Vector3d.f_82481_);
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
                double d3 = this.m_20186_() + 0.5;
                serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), d3, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                this.ticksCatchable = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.f_19796_.m_188501_() < f5) {
                double d6;
                double d5;
                float f6 = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.m_216267_((RandomSource)this.f_19796_, (float)25.0f, (float)60.0f);
                double d4 = this.m_20185_() + (double)(Mth.m_14031_((float)f6) * f7 * 0.1f);
                if (serverworld.m_8055_(BlockPos.m_274561_((double)d4, (double)((d5 = (double)((float)Mth.m_14107_((double)this.m_20186_()) + 1.0f)) - 1.0), (double)(d6 = this.m_20189_() + (double)(Mth.m_14089_((float)f6) * f7 * 0.1f)))).m_60713_(Blocks.f_49990_)) {
                    serverworld.m_8767_((ParticleOptions)ParticleTypes.f_123769_, d4, d5, d6, 2 + this.f_19796_.m_188503_(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = Mth.m_216267_((RandomSource)this.f_19796_, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = Mth.m_216271_((RandomSource)this.f_19796_, (int)1060, (int)1300);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
            this.ticksCaughtDelay = Math.max(5, this.ticksCaughtDelay);
        }
    }

    public int getDamage() {
        if (!this.f_19853_.f_46443_ && this.angler != null) {
            int i = 0;
            Object event = null;
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.f_19853_.m_7605_((Entity)this, (byte)31);
                i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)this.f_19853_).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81463_, (Object)this.getAngler().m_21205_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287239_((float)this.luck);
                lootcontext$builder.m_287286_(LootContextParams.f_81458_, (Object)this.angler).m_287286_(LootContextParams.f_81455_, (Object)this);
                LootTable loottable = this.f_19853_.m_7654_().m_278653_().m_278676_(ModLootTables.FISHING);
                ObjectArrayList list = loottable.m_287195_(lootcontext$builder.m_287235_(LootContextParamSets.f_81414_));
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.f_19853_, this.onWaterPos.f_82479_, this.onWaterPos.f_82480_, this.onWaterPos.f_82481_, itemstack);
                    double d0 = this.angler.m_20185_() - this.onWaterPos.f_82479_;
                    double d1 = this.angler.m_20186_() + 0.5 - this.onWaterPos.f_82480_;
                    double d2 = this.angler.m_20189_() - this.onWaterPos.f_82481_;
                    itementity.f_19794_ = true;
                    itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.f_19853_.m_7967_((Entity)itementity);
                    this.angler.f_19853_.m_7967_((Entity)new ExperienceOrb(this.angler.f_19853_, this.angler.m_20185_(), this.angler.m_20186_() + 0.5, this.angler.m_20189_() + 0.5, 2));
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 31 && this.f_19853_.f_46443_ && this.caughtEntity instanceof EntityCitizen) {
            this.bringInHookedEntity();
        }
        super.m_7822_(id);
    }

    protected void bringInHookedEntity() {
        if (this.angler != null) {
            Vec3 Vector3d = new Vec3(this.angler.m_20185_() - this.m_20185_(), this.angler.m_20186_() - this.m_20186_(), this.angler.m_20189_() - this.m_20189_()).m_82490_(0.1);
            this.caughtEntity.m_20256_(this.caughtEntity.m_20184_().m_82549_(Vector3d));
        }
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    @Nullable
    public EntityCitizen getAngler() {
        return this.angler;
    }

    public boolean m_6072_() {
        return false;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.angler != null) {
            buffer.writeInt(this.angler.m_19879_());
        } else {
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int citizenId = additionalData.readInt();
        if (citizenId != -1) {
            this.anglerId = citizenId;
        }
    }

    public boolean isReadyToCatch() {
        return this.readyToCatch;
    }

    public void setInUse() {
        this.tickRemove = 100;
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

