/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.loot.ModLootTables;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFisherman;
import com.minecolonies.core.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobFisherman;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAISkill;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.NewBobberEntity;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobFindWater;
import com.minecolonies.core.entity.pathfinding.pathresults.WaterPathResult;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFisherman
extends AbstractEntityAISkill<JobFisherman, BuildingFisherman> {
    public static final String RENDER_META_FISH = "fish";
    public static final String RENDER_META_ROD = "rod";
    public static final int SUBOPTIMAL_POND_COMPLAINT_DISTANCE = 12;
    private static final int MAX_PONDS = 20;
    private static final int FISHING_SKILL_CHANCE = 10;
    private static final int CHANCE = 2;
    private static final int MIN_DISTANCE_TO_WATER = 3;
    private static final int MAX_FISHES_IN_INV = 10;
    private static final int MAX_ROTATIONS = 6;
    private static final int SEARCH_RANGE = 50;
    private static final double CHANCE_NEW_POND = 0.05;
    private static final int FISHING_TIMEOUT = 5;
    private static final int LURE_SPEED_DIVIDER = 25;
    private int executedRotations = 0;
    @Nullable
    private WaterPathResult pathResult;
    @Nullable
    private WaterPathResult lastPathResult;
    @Nullable
    private NewBobberEntity entityFishHook;
    private int stuckCounter = 3;

    public EntityAIWorkFisherman(@NotNull JobFisherman job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForFishing, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_CHECK_WATER, this::tryDifferentAngles, 1), new AITarget<Object>(AIWorkerState.FISHERMAN_SEARCHING_WATER, this::findWater, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_WALKING_TO_WATER, this::getToWater, 20), new AITarget<Object>(AIWorkerState.FISHERMAN_START_FISHING, this::doFishing, 20));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingFisherman> getExpectedBuildingClass() {
        return BuildingFisherman.class;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForFishing() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get())) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            this.playNeedRodSound();
            return this.getState();
        }
        return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
    }

    private void playNeedRodSound() {
        SoundUtils.playSoundAtCitizenWith(this.world, this.worker.m_20183_(), EventType.MISSING_EQUIPMENT, this.worker.getCitizenData());
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    protected void updateRenderMetaData() {
        if (this.hasFish() && this.hasRodButNotEquipped()) {
            this.worker.setRenderMetadata("rodfish");
        } else if (this.hasRodButNotEquipped() && !this.hasFish()) {
            this.worker.setRenderMetadata(RENDER_META_ROD);
        } else {
            this.worker.setRenderMetadata(this.hasFish() ? RENDER_META_FISH : "");
        }
    }

    private boolean hasFish() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), item -> item.m_204117_(ItemTags.f_13156_));
    }

    private boolean hasRodButNotEquipped() {
        return InventoryUtils.hasItemHandlerEquipmentWithLevel((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get(), 0, ((BuildingFisherman)this.building).getMaxEquipmentLevel()) && this.worker.m_21205_() != null && !((EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get()).checkIsEquipment(this.worker.m_21205_());
    }

    private IAIState getToWater() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (!this.walkToWater()) {
            return this.getState();
        }
        if (this.lastPathResult != null && this.lastPathResult.pondState == Pond.PondState.SUBOPTIMAL) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((Component)Component.m_237110_((String)"entity.fisherman.messagesuboptimalpond", (Object[])new Object[]{this.lastPathResult.pond.m_123341_(), this.lastPathResult.pond.m_123342_(), this.lastPathResult.pond.m_123343_()}), ChatPriority.IMPORTANT, (Component)Component.m_237115_((String)"entity.fisherman.messagesuboptimalpond"), this.lastPathResult.pond));
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private boolean walkToWater() {
        return ((JobFisherman)this.job).getWater() != null && this.walkToSafePos(((JobFisherman)this.job).getWater().getB());
    }

    @NotNull
    private IAIState tryDifferentAngles() {
        if (((JobFisherman)this.job).getWater() == null) {
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.executedRotations >= 6) {
            ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
            ((JobFisherman)this.job).setWater(null);
            this.executedRotations = 0;
            return AIWorkerState.FISHERMAN_SEARCHING_WATER;
        }
        if (this.world.m_8055_(this.worker.m_20183_()).m_278721_()) {
            if (!BlockUtils.isAnySolid((BlockState)this.world.m_8055_(((JobFisherman)this.job).getWater().getB().m_7495_()))) {
                ((JobFisherman)this.job).removeFromPonds(((JobFisherman)this.job).getWater());
                ((JobFisherman)this.job).setWater(null);
                this.executedRotations = 0;
                return AIWorkerState.START_WORKING;
            }
            ++this.executedRotations;
        }
        WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
        ++this.executedRotations;
        return AIWorkerState.FISHERMAN_START_FISHING;
    }

    private IAIState findWater() {
        this.executedRotations = 0;
        if (((JobFisherman)this.job).getPonds().size() >= 20 || this.lastPathResult != null && this.lastPathResult.pond == null && ((JobFisherman)this.job).getPonds().size() > 0) {
            return this.setRandomWater();
        }
        return this.findNewWater();
    }

    public WaterPathResult searchWater(int range, double speed, List<Tuple<BlockPos, BlockPos>> ponds) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.worker);
        PathJobFindWater job = new PathJobFindWater(CompatibilityUtils.getWorldFromEntity((Entity)this.worker), start, this.worker.getCitizenColonyHandler().getWorkBuilding().getPosition(), range, ponds, (Mob)this.worker);
        job.setPathingOptions(this.worker.getNavigation().getPathingOptions());
        WaterPathResult waterPathresult = job.getResult();
        waterPathresult.startJob(Pathfinding.getExecutor());
        return waterPathresult;
    }

    private IAIState setRandomWater() {
        if (((JobFisherman)this.job).getPonds().isEmpty()) {
            if ((this.pathResult != null && this.pathResult.failedToReachDestination() && this.lastPathResult == null || this.lastPathResult != null && this.lastPathResult.isEmpty && !this.lastPathResult.isCancelled()) && this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"entity.fisherman.messagewatertoofar"), ChatPriority.IMPORTANT));
            }
            if (this.pathResult == null || !this.pathResult.isInProgress()) {
                this.pathResult = this.searchWater(50, 1.0, ((JobFisherman)this.job).getPonds());
            }
            return AIWorkerState.START_WORKING;
        }
        ((JobFisherman)this.job).setWater(((JobFisherman)this.job).getPonds().get(this.worker.m_217043_().m_188503_(((JobFisherman)this.job).getPonds().size())));
        return AIWorkerState.FISHERMAN_CHECK_WATER;
    }

    private IAIState findNewWater() {
        if (this.pathResult == null) {
            this.pathResult = this.searchWater(150, 1.0, ((JobFisherman)this.job).getPonds());
            return this.getState();
        }
        if (this.pathResult.failedToReachDestination()) {
            return this.setRandomWater();
        }
        if (this.pathResult.isPathReachingDestination()) {
            if (this.pathResult.pond != null) {
                ((JobFisherman)this.job).setWater(new Tuple<BlockPos, BlockPos>(this.pathResult.pond, this.pathResult.parent));
                ((JobFisherman)this.job).addToPonds(this.pathResult.pond, this.pathResult.parent);
            }
            this.lastPathResult = this.pathResult;
            this.pathResult = null;
            return AIWorkerState.FISHERMAN_CHECK_WATER;
        }
        if (this.pathResult.isCancelled()) {
            this.pathResult = null;
            return AIWorkerState.PREPARING;
        }
        return this.getState();
    }

    @Nullable
    private IAIState doFishing() {
        @Nullable IAIState notReadyState = this.isReadyToFish();
        if (notReadyState != null) {
            return notReadyState;
        }
        if (this.caughtFish()) {
            this.playCaughtFishSound();
            this.incrementActionsDoneAndDecSaturation();
            if (this.worker.m_217043_().m_188500_() < 0.05) {
                ((JobFisherman)this.job).setWater(null);
                return AIWorkerState.FISHERMAN_SEARCHING_WATER;
            }
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        return this.throwOrRetrieveHook();
    }

    private void playCaughtFishSound() {
        SoundUtils.playSoundAtCitizenWith(this.world, this.worker.m_20183_(), EventType.SUCCESS, this.worker.getCitizenData());
    }

    private IAIState throwOrRetrieveHook() {
        if (this.entityFishHook == null) {
            if (this.testRandomChance()) {
                return this.getState();
            }
            this.throwRod();
        } else {
            if (this.isFishHookStuck()) {
                if (this.stuckCounter > 3) {
                    this.stuckCounter = 0;
                    this.retrieveRod();
                    return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
                }
                ++this.stuckCounter;
            } else {
                this.stuckCounter = 0;
            }
            this.entityFishHook.setInUse();
        }
        return this.getState();
    }

    private void throwRod() {
        if (!this.world.f_46443_) {
            WorkerUtil.faceBlock(((JobFisherman)this.job).getWater().getA(), this.worker);
            this.world.m_5594_(null, this.worker.m_20183_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, (float)(0.4 / ((double)this.world.f_46441_.m_188501_() * 0.4 + 0.8)));
            this.entityFishHook = (NewBobberEntity)ModEntities.FISHHOOK.m_20615_(this.world);
            this.entityFishHook.setAngler((EntityCitizen)this.worker, EnchantmentHelper.m_44904_((ItemStack)this.worker.m_21205_()), 5 + this.getPrimarySkillLevel() / 25 + EnchantmentHelper.m_44916_((ItemStack)this.worker.m_21205_()));
            this.world.m_7967_((Entity)this.entityFishHook);
        }
        this.worker.m_6674_(this.worker.m_7655_());
    }

    private boolean isFishHookStuck() {
        return !this.entityFishHook.m_20069_() && (this.entityFishHook.m_20096_() || this.entityFishHook.shouldStopFishing()) || !this.entityFishHook.m_6084_() || this.entityFishHook.caughtEntity != null;
    }

    private boolean testRandomChance() {
        this.setDelay(5);
        double chance = this.worker.m_217043_().m_188503_(10 + this.getSecondarySkillLevel() / 5);
        return chance <= 2.0;
    }

    private IAIState isReadyToFish() {
        int rodSlot = this.getRodSlot();
        if (rodSlot == -1) {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.PREPARING;
        }
        if (!Utils.isBlockInRange(this.world, Blocks.f_49990_, (int)this.worker.m_20185_(), (int)this.worker.m_20186_(), (int)this.worker.m_20189_(), 3)) {
            return AIWorkerState.FISHERMAN_WALKING_TO_WATER;
        }
        if (this.worker.m_21205_() == null || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.worker.m_21205_(), this.worker.getItemHandlerCitizen().getStackInSlot(rodSlot), false, true)) {
            this.equipRod();
            return this.getState();
        }
        return null;
    }

    private void equipRod() {
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, this.getRodSlot());
    }

    private int getRodSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.fishing_rod.get(), 0, ((BuildingFisherman)this.building).getMaxEquipmentLevel());
    }

    private boolean caughtFish() {
        if (this.entityFishHook == null) {
            return false;
        }
        if (!this.entityFishHook.isReadyToCatch()) {
            return false;
        }
        if (this.testRandomChance()) {
            return false;
        }
        this.worker.m_21553_(true);
        this.retrieveRod();
        return true;
    }

    private void retrieveRod() {
        if (this.entityFishHook != null) {
            this.worker.m_6674_(this.worker.m_7655_());
            int i = this.entityFishHook.getDamage();
            this.generateBonusLoot();
            CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, i);
            this.entityFishHook = null;
        }
    }

    private void generateBonusLoot() {
        LootParams context = new LootParams.Builder((ServerLevel)this.world).m_287286_(LootContextParams.f_81460_, (Object)this.entityFishHook.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.entityFishHook).m_287286_(LootContextParams.f_81463_, (Object)this.worker.m_21205_()).m_287286_(LootContextParams.f_81458_, (Object)this.worker).m_287239_((float)this.getPrimarySkillLevel()).m_287235_(LootContextParamSets.f_81414_);
        LootTable bonusLoot = this.world.m_7654_().m_278653_().m_278676_(ModLootTables.FISHERMAN_BONUS.getOrDefault(((BuildingFisherman)this.building).getBuildingLevel(), new ResourceLocation("")));
        ObjectArrayList loot = bonusLoot.m_287195_(context);
        for (ItemStack itemstack : loot) {
            ItemEntity itementity = new ItemEntity(this.world, this.entityFishHook.m_20182_().f_82479_, this.entityFishHook.m_20182_().f_82480_, this.entityFishHook.m_20182_().f_82481_, itemstack);
            double d0 = this.worker.m_20185_() - this.entityFishHook.m_20182_().f_82479_;
            double d1 = this.worker.m_20186_() + 0.5 - this.entityFishHook.m_20182_().f_82480_;
            double d2 = this.worker.m_20189_() - this.entityFishHook.m_20182_().f_82481_;
            itementity.f_19794_ = true;
            itementity.m_20334_(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
            this.world.m_7967_((Entity)itementity);
            this.worker.f_19853_.m_7967_((Entity)new ExperienceOrb(this.worker.f_19853_, this.worker.m_20185_(), this.worker.m_20186_() + 0.5, this.worker.m_20189_() + 0.5, 2));
        }
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

