/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.debug.messages.DebugEnablePathfindingMessage;
import com.minecolonies.core.debug.messages.QueryCitizenAIHistoryMessage;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DebugWindowCitizen
extends AbstractWindowSkeleton {
    public static MutableComponent outputMessage = Component.m_237119_();
    private static boolean trackingDebug = false;

    public DebugWindowCitizen(ICitizenDataView citizen) {
        super(new ResourceLocation("minecolonies", "gui/citizen/debug.xml"));
        if (Objects.equals(outputMessage, Component.m_237119_())) {
            outputMessage = Component.m_237113_((String)"Enabled Citizen AI History!");
        }
        ((Text)this.findPaneOfTypeByID("citizenid", Text.class)).setText(Component.m_237113_((String)("Citizen ID:" + citizen.getId())));
        ((Text)this.findPaneOfTypeByID("colonyid", Text.class)).setText(Component.m_237113_((String)("Colony ID:" + citizen.getColonyId())));
        ((Button)this.findPaneOfTypeByID("aihistory", Button.class)).setHandler(b -> Network.getNetwork().sendToServer(new QueryCitizenAIHistoryMessage(citizen)));
        ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setHandler(b -> {
            boolean bl = trackingDebug = !trackingDebug;
            if (trackingDebug) {
                outputMessage = Component.m_237113_((String)"Receiving pathfinding data");
            }
            Network.getNetwork().sendToServer(new DebugEnablePathfindingMessage(citizen, trackingDebug));
            ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setText(Component.m_237113_((String)(trackingDebug ? "disable Pathfinding tracking" : "enable Pathfinding tracking")));
        });
        ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setText(Component.m_237113_((String)(trackingDebug ? "disable Pathfinding tracking" : "enable Pathfinding tracking")));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        ((Text)this.findPaneOfTypeByID("output", Text.class)).setText(outputMessage);
    }
}

