/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.items.CheckedNbtKey;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.generation.ItemNbtCalculator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ItemNbtListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ItemNbtListener() {
        super(GSON, "compatibility");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        ItemStackUtils.CHECKED_NBT_KEYS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            this.tryParse(entry);
        }
    }

    private void tryParse(Map.Entry<ResourceLocation, JsonElement> entry) {
        for (JsonElement element : entry.getValue().getAsJsonArray()) {
            try {
                JsonObject jsonObj = element.getAsJsonObject();
                ResourceLocation itemLoc = new ResourceLocation(jsonObj.get("item").getAsString());
                if (jsonObj.has("checkednbtkeys")) {
                    HashSet<CheckedNbtKey> set = new HashSet<CheckedNbtKey>();
                    JsonArray jsonArray = jsonObj.getAsJsonArray("checkednbtkeys");
                    for (JsonElement subElement : jsonArray) {
                        set.add(ItemNbtCalculator.deserializeKeyFromJson(subElement.getAsJsonObject()));
                    }
                    ItemStackUtils.CHECKED_NBT_KEYS.put((Item)ForgeRegistries.ITEMS.getValue(itemLoc), set);
                    continue;
                }
                ItemStackUtils.CHECKED_NBT_KEYS.put((Item)ForgeRegistries.ITEMS.getValue(itemLoc), new HashSet());
            }
            catch (Exception e) {
                Log.getLogger().warn("Could not nbt comparator for:" + String.valueOf(entry.getKey()), (Throwable)e);
            }
        }
        Log.getLogger().warn("Read " + ItemStackUtils.CHECKED_NBT_KEYS.size() + " items with their nbt keys for compatibility.");
    }
}

