/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.jei;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ldtteam.blockui.UiRenderMacros;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.colony.crafting.RecipeAnalyzer;
import com.minecolonies.core.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.core.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class GenericRecipeCategory
extends JobBasedRecipeCategory<IGenericRecipe> {
    @NotNull
    private final List<ICraftingBuildingModule> crafting = new ArrayList<ICraftingBuildingModule>();
    @NotNull
    private final List<AnimalHerdingModule> herding = new ArrayList<AnimalHerdingModule>();
    @NotNull
    private final IDrawableStatic arrow;
    @NotNull
    private final IModIdHelper modIdHelper;
    @NotNull
    private final ITickTimer animalTimer;
    private static final Cache<EntityType<?>, Entity> entityCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(2L)).build();
    private static final int ANIMAL_W = 60;
    private static final int ANIMAL_H = 61;
    private static final int ANIMAL_X = 78;
    private static final int ANIMAL_Y = 26;
    private static final int LOOT_SLOTS_X = 53;
    private static final int LOOT_SLOTS_W = 114;
    private static final int INPUT_SLOT_X = 81;
    private static final int INPUT_SLOT_W = 86;
    private final int outputSlotX;
    private final int outputSlotY;

    public GenericRecipeCategory(@NotNull BuildingEntry building, @NotNull IJob<?> job, @NotNull IGuiHelper guiHelper, @NotNull IModIdHelper modIdHelper) {
        super(job, GenericRecipeCategory.createRecipeType(job), GenericRecipeCategory.getCatalyst(building), guiHelper);
        this.arrow = guiHelper.createDrawable(TEXTURE, 20, 121, 24, 18);
        this.modIdHelper = modIdHelper;
        this.animalTimer = guiHelper.createTickTimer(200, 359, false);
        this.outputSlotX = 51 + (30 - this.slot.getWidth()) / 2;
        this.outputSlotY = 118 - this.slot.getHeight();
    }

    public void addModule(@NotNull ICraftingBuildingModule module) {
        this.crafting.add(module);
    }

    public void addModule(@NotNull AnimalHerdingModule module) {
        this.herding.add(module);
    }

    @NotNull
    private static RecipeType<IGenericRecipe> createRecipeType(@NotNull IJob<?> job) {
        ResourceLocation uid = job.getJobRegistryEntry().getKey();
        return RecipeType.create((String)uid.m_135827_(), (String)uid.m_135815_(), IGenericRecipe.class);
    }

    @Override
    @NotNull
    protected List<Component> generateInfoBlocks(@NotNull IGenericRecipe recipe) {
        return recipe.getRestrictions().get();
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull IGenericRecipe recipe, @NotNull IFocusGroup focuses) {
        if (GenericRecipeCategory.isLootBasedRecipe(recipe)) {
            this.setLootBasedRecipe(builder, recipe, focuses);
        } else {
            this.setNormalRecipe(builder, recipe, focuses);
        }
    }

    private void setNormalRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull IGenericRecipe recipe, @NotNull IFocusGroup focuses) {
        List<List<ItemStack>> inputs;
        ResourceLocation id = recipe.getRecipeId();
        this.addToolSlot(builder, recipe.getRequiredTool(), 149, 26, true);
        int x = this.outputSlotX;
        int y = this.outputSlotY;
        IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.slot, -1, -1).addItemStacks(recipe.getAllMultiOutputs());
        if (id != null) {
            slot.addTooltipCallback((IRecipeSlotTooltipCallback)new JobBasedRecipeCategory.RecipeIdTooltipCallback(id, this.modIdHelper));
        }
        x += this.slot.getWidth();
        for (ItemStack itemStack : recipe.getAdditionalOutputs()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.slot, -1, -1).addItemStack(itemStack);
            x += this.slot.getWidth();
        }
        if (recipe.getLootTable() != null) {
            List<LootTableAnalyzer.LootDrop> drops = GenericRecipeCategory.getLootDrops(recipe.getLootTable());
            for (LootTableAnalyzer.LootDrop drop : drops) {
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.chanceSlot, -1, -1).addItemStacks(drop.getItemStacks())).addTooltipCallback((IRecipeSlotTooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(drop, recipe.getLootTable()));
                x += this.chanceSlot.getWidth();
            }
        }
        if (!(inputs = recipe.getInputs()).isEmpty()) {
            int n = 86 / this.slot.getWidth();
            int inputRows = (inputs.size() + n - 1) / n;
            int inputColumns = (inputs.size() + inputRows - 1) / inputRows;
            x = 81;
            y = 46 + (71 - inputRows * this.slot.getHeight()) / 2;
            int c = 0;
            for (List<ItemStack> input : inputs) {
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(input);
                if (++c >= inputColumns) {
                    c = 0;
                    x = 81;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    private void setLootBasedRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull IGenericRecipe recipe, @NotNull IFocusGroup focuses) {
        List<List<ItemStack>> inputs;
        assert (recipe.getLootTable() != null);
        List<LootTableAnalyzer.LootDrop> drops = GenericRecipeCategory.getLootDrops(recipe.getLootTable());
        ResourceLocation id = recipe.getRecipeId();
        this.addToolSlot(builder, recipe.getRequiredTool(), 149, 26, true);
        int x = 53;
        int y = 46;
        if (recipe.getIntermediate() != Blocks.f_50016_) {
            x += 30;
        }
        if (!(inputs = recipe.getInputs()).isEmpty()) {
            for (List<ItemStack> input : inputs) {
                builder.addSlot(RecipeIngredientRole.INPUT, x, y).addItemStacks(input);
                x += this.slot.getWidth() + 2;
            }
        }
        boolean showLootTooltip = true;
        if (drops.isEmpty()) {
            showLootTooltip = false;
            drops.addAll(recipe.getAdditionalOutputs().stream().map(stack -> new LootTableAnalyzer.LootDrop(Collections.singletonList(stack), 0.0f, 0.0f, false)).collect(Collectors.toList()));
        }
        if (!drops.isEmpty()) {
            int startX;
            int initialColumns = 114 / this.slot.getWidth();
            int rows = (drops.size() + initialColumns - 1) / initialColumns;
            int columns = (drops.size() + rows - 1) / rows;
            x = startX = 53 + (114 - columns * this.slot.getWidth()) / 2;
            y = 117 - rows * this.slot.getHeight() + 1;
            int c = 0;
            for (LootTableAnalyzer.LootDrop drop : drops) {
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.chanceSlot, -1, -1).addItemStacks(drop.getItemStacks());
                if (showLootTooltip) {
                    slot.addTooltipCallback((IRecipeSlotTooltipCallback)new JobBasedRecipeCategory.LootTableTooltipCallback(drop, recipe.getLootTable()));
                }
                if (id != null) {
                    slot.addTooltipCallback((IRecipeSlotTooltipCallback)new JobBasedRecipeCategory.RecipeIdTooltipCallback(id, this.modIdHelper));
                }
                if (++c >= columns) {
                    c = 0;
                    x = startX;
                    y += this.slot.getHeight();
                    continue;
                }
                x += this.slot.getWidth();
            }
        }
    }

    @Override
    public void draw(@NotNull IGenericRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        EntityType<?> entityType;
        super.draw(recipe, recipeSlotsView, stack, mouseX, mouseY);
        if (!GenericRecipeCategory.isLootBasedRecipe(recipe)) {
            this.arrow.draw(stack, 53, 46 + (71 - this.arrow.getHeight()) / 2);
        }
        if (recipe.getIntermediate() != Blocks.f_50016_) {
            BlockState block = recipe.getIntermediate().m_49966_();
            RenderHelper.renderBlock(stack.m_280168_(), block, this.outputSlotX + 8, 52.0f, 100.0f, -30.0f, 30.0f, 16.0f);
        }
        if ((entityType = recipe.getRequiredEntity()) != null) {
            try {
                Entity entity = (Entity)entityCache.get(entityType, () -> entityType.m_20615_((Level)Minecraft.m_91087_().f_91073_));
                float scale = 25.416666f;
                int animal_cx = 108;
                int animal_cy = 56;
                int animal_by = 87;
                int offsetY = 16;
                float yaw = this.animalTimer.getValue();
                float headYaw = (float)Math.atan((108.0 - mouseX) / 40.0) * 40.0f + yaw;
                float pitch = (float)Math.atan((40.0 - mouseY) / 40.0) * 20.0f;
                Lighting.m_84930_();
                UiRenderMacros.drawEntity((PoseStack)stack.m_280168_(), (int)108, (int)71, (double)25.41666603088379, (float)headYaw, (float)yaw, (float)pitch, (Entity)entity);
                Lighting.m_84931_();
            }
            catch (Throwable e) {
                Log.getLogger().error("Error drawing {}", (Object)entityType.m_20675_(), (Object)e);
            }
        }
    }

    @Override
    @NotNull
    public List<Component> getTooltipStrings(@NotNull IGenericRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        List<Component> tooltips = super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        if (recipe.getIntermediate() != Blocks.f_50016_ && new Rect2i(53, 44, 24, 24).m_110087_((int)mouseX, (int)mouseY)) {
            tooltips.add((Component)Component.m_237110_((String)"com.minecolonies.coremod.jei.intermediate.tip", (Object[])new Object[]{recipe.getIntermediate().m_49954_()}));
        }
        return tooltips;
    }

    private static boolean isLootBasedRecipe(@NotNull IGenericRecipe recipe) {
        return recipe.getLootTable() != null && recipe.getPrimaryOutput().m_41619_();
    }

    private static List<LootTableAnalyzer.LootDrop> getLootDrops(@NotNull ResourceLocation lootTableId) {
        List<LootTableAnalyzer.LootDrop> drops = CustomRecipeManager.getInstance().getLootDrops(lootTableId);
        return drops.size() > 18 ? LootTableAnalyzer.consolidate(drops) : drops;
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull List<Animal> animals, @NotNull Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (ICraftingBuildingModule iCraftingBuildingModule : this.crafting) {
            recipes.addAll(RecipeAnalyzer.findRecipes(vanilla, iCraftingBuildingModule, world));
        }
        for (AnimalHerdingModule animalHerdingModule : this.herding) {
            recipes.addAll(RecipeAnalyzer.findRecipes(animals, animalHerdingModule));
        }
        return recipes.stream().sorted(Comparator.comparing(IGenericRecipe::getLevelSort).thenComparing(r -> ForgeRegistries.ITEMS.getKey((Object)r.getPrimaryOutput().m_41720_()))).collect(Collectors.toList());
    }
}

