/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.minecolonies.core.util.ChunkDataHelper;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandClaimChunks
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(sender instanceof Player)) {
            return 0;
        }
        int colonyID = ColonyIdArgument.getColonyId(context, "colonyID");
        int range = IntegerArgumentType.getInteger(context, (String)"range");
        if (range > (Integer)MineColonies.getConfig().getServer().maxColonySize.get()) {
            MessageUtils.format("com.minecolonies.command.claim.toolarge", colonyID).sendTo((Player)sender);
            return 0;
        }
        boolean add = BoolArgumentType.getBool(context, (String)"add");
        IChunkmanagerCapability chunkManager = sender.f_19853_.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null).resolve().orElse(null);
        if (chunkManager == null) {
            Log.getLogger().error("Unable to find Chunk manager in world capability, please report this to the mod author!", (Throwable)new Exception());
            return 0;
        }
        if (chunkManager.getAllChunkStorages().size() > 5000) {
            MessageUtils.format("com.minecolonies.command.claim.maxchunks", new Object[0]).sendTo((Player)sender);
            return 0;
        }
        ChunkDataHelper.staticClaimInRange(colonyID, add, sender.m_20183_(), range, sender.f_19853_, true);
        if (add) {
            MessageUtils.format("com.minecolonies.command.claim.success", new Object[0]).sendTo((Player)sender);
        } else {
            MessageUtils.format("com.minecolonies.command.claim.unclaim", new Object[0]).sendTo((Player)sender);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "claim";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("range", IntegerArgumentType.integer((int)0, (int)10)).then(IMCCommand.newArgument("add", BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }
}

