/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class CommandCitizenList
implements IMCColonyOfficerCommand {
    private static final String LIST_COMMAND_SUGGESTED = "/minecolonies citizens list %d %d";
    private static final String COMMAND_CITIZEN_INFO_SUGGESTED = "/minecolonies citizens info %d %d";
    private static final int CITIZENS_ON_PAGE = 9;

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.displayListFor(context, 1);
    }

    private int executeWithPage(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.displayListFor(context, IntegerArgumentType.getInteger(context, (String)"startpage"));
    }

    private int displayListFor(CommandContext<CommandSourceStack> context, int page) {
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        List<ICitizenData> citizens = colony.getCitizenManager().getCitizens();
        int citizenCount = citizens.size();
        int halfPage = citizenCount % 9 == 0 ? 0 : 1;
        int pageCount = citizenCount / 9 + halfPage;
        if (page < 1 || page > pageCount) {
            page = 1;
        }
        int pageStartIndex = 9 * (page - 1);
        int pageStopIndex = Math.min(9 * page, citizenCount);
        List<ICitizenData> citizensPage = this.getCitizensOnPage(citizens, citizenCount, pageStartIndex, pageStopIndex);
        MutableComponent headerLine = Component.m_237110_((String)"com.minecolonies.command.citizenlist.pagetop", (Object[])new Object[]{page, pageCount});
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandCitizenList.lambda$displayListFor$0((Component)headerLine), true);
        this.drawCitizens(context, citizensPage);
        CommandCitizenList.drawPageSwitcher(context, page, citizenCount, halfPage, colony.getID());
        return 1;
    }

    @NotNull
    private List<ICitizenData> getCitizensOnPage(List<ICitizenData> citizens, int citizenCount, int pageStartIndex, int pageStopIndex) {
        List<ICitizenData> citizensPage = pageStartIndex < 0 || pageStartIndex >= citizenCount ? new ArrayList<ICitizenData>() : citizens.subList(pageStartIndex, pageStopIndex);
        return citizensPage;
    }

    private void drawCitizens(@NotNull CommandContext<CommandSourceStack> context, List<ICitizenData> citizensPage) {
        for (ICitizenData citizen : citizensPage) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizen.getId(), citizen.getName()}).m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(COMMAND_CITIZEN_INFO_SUGGESTED, citizen.getColony().getID(), citizen.getId())))), true);
            citizen.getEntity().ifPresent(entityCitizen -> {
                BlockPos position = entityCitizen.m_20183_();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{position.m_123341_(), position.m_123342_(), position.m_123343_()}), true);
            });
        }
    }

    private static void drawPageSwitcher(@NotNull CommandContext<CommandSourceStack> context, int page, int count, int halfPage, int colonyId) {
        int prevPage = Math.max(0, page - 1);
        int nextPage = Math.min(page + 1, count / 9 + halfPage);
        MutableComponent prevButton = Component.m_237115_((String)"com.minecolonies.command.citizenlist.prev").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, prevPage))));
        MutableComponent nextButton = Component.m_237115_((String)"com.minecolonies.command.citizenlist.next").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(LIST_COMMAND_SUGGESTED, colonyId, nextPage))));
        MutableComponent beginLine = Component.m_237115_((String)"com.minecolonies.command.citizenlist.pageline");
        MutableComponent endLine = Component.m_237115_((String)"com.minecolonies.command.citizenlist.pageline");
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandCitizenList.lambda$drawPageSwitcher$4(beginLine, (Component)prevButton, (Component)nextButton, endLine), true);
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).executes(this::checkPreConditionAndExecute)).then(IMCCommand.newArgument("startpage", IntegerArgumentType.integer((int)1)).executes(this::executeWithPage)));
    }

    private static /* synthetic */ Component lambda$drawPageSwitcher$4(MutableComponent beginLine, Component prevButton, Component nextButton, MutableComponent endLine) {
        return beginLine.m_7220_(prevButton).m_7220_((Component)Component.m_237115_((String)"com.minecolonies.command.citizenlist.pagestyle")).m_7220_(nextButton).m_7220_((Component)endLine);
    }

    private static /* synthetic */ Component lambda$displayListFor$0(Component headerLine) {
        return headerLine;
    }
}

