/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.arguments;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.arguments.MultipleOptionsArgument;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyIdArgument
extends MultipleOptionsArgument<Integer> {
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.player.unknown"));
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_COLONY = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"com.minecolonies.command.argument.colony.unknown"));

    private ColonyIdArgument() {
        super(List.of(new HereOption(), new MineOption(), new ColonyIdOption(), new PlayerUuidOption(), new PlayerNameOption()));
    }

    public static ColonyIdArgument id() {
        return new ColonyIdArgument();
    }

    @Nullable
    public static IColony tryGetColony(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name, boolean report) {
        int colonyId = ColonyIdArgument.getColonyId(context, name);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)((CommandSourceStack)context.getSource()).m_81372_());
        if (colony == null) {
            if (report) {
                MutableComponent message = Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyId});
                ((CommandSourceStack)context.getSource()).m_81352_((Component)message);
            }
            return null;
        }
        return colony;
    }

    public static int getColonyId(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        try {
            return (Integer)ColonyIdArgument.getValue(context, name);
        }
        catch (CommandSyntaxException e) {
            Component message = ComponentUtils.m_130729_((Message)e.getRawMessage());
            ((CommandSourceStack)context.getSource()).m_81352_(message);
            throw new RuntimeException(message.getString());
        }
    }

    @NotNull
    public static IColony getColony(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        int colonyId = ColonyIdArgument.getColonyId(context, name);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)((CommandSourceStack)context.getSource()).m_81372_());
        if (colony == null) {
            MutableComponent message = Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyId});
            ((CommandSourceStack)context.getSource()).m_81352_((Component)message);
            throw new CommandRuntimeException((Component)message);
        }
        return colony;
    }

    private static int resolveByOwner(@NotNull CommandSourceStack source, @NotNull UUID id) throws CommandSyntaxException {
        IColony colony = IColonyManager.getInstance().getIColonyByOwner((Level)source.m_81372_(), id);
        if (colony == null) {
            throw ERROR_UNKNOWN_COLONY.create();
        }
        return colony.getID();
    }

    public static class HereOption
    implements MultipleOptionsArgument.ArgumentOption<Integer> {
        @Override
        public boolean matches(String value) {
            return Objects.equals(value, "@here");
        }

        @Override
        public Integer resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            IColony colony = IColonyManager.getInstance().getIColony((Level)source.m_81372_(), BlockPos.m_274446_((Position)source.m_81371_()));
            if (colony == null) {
                throw ERROR_UNKNOWN_COLONY.create();
            }
            return colony.getID();
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            builder.suggest("@here", (Message)Component.m_237115_((String)"com.minecolonies.command.argument.colony.here"));
        }
    }

    public static class MineOption
    implements MultipleOptionsArgument.ArgumentOption<Integer> {
        @Override
        public boolean matches(String value) {
            return Objects.equals(value, "@mine");
        }

        @Override
        public Integer resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            return ColonyIdArgument.resolveByOwner(source, source.m_81375_().m_36316_().getId());
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            builder.suggest("@mine", (Message)Component.m_237115_((String)"com.minecolonies.command.argument.colony.mine"));
        }
    }

    public static class ColonyIdOption
    implements MultipleOptionsArgument.ArgumentOption<Integer> {
        @Override
        public boolean matches(String value) {
            try {
                Integer.parseInt(value);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Integer resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            return Integer.parseInt(value);
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            IColonyManager.getInstance().getIColonies(world).stream().map(IColony::getID).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
    }

    public static class PlayerUuidOption
    implements MultipleOptionsArgument.ArgumentOption<Integer> {
        @Override
        public boolean matches(String value) {
            try {
                UUID.fromString(value);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        @Override
        public Integer resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            return ColonyIdArgument.resolveByOwner(source, UUID.fromString(value));
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
        }
    }

    public static class PlayerNameOption
    implements MultipleOptionsArgument.ArgumentOption<Integer> {
        @Override
        public boolean matches(String value) {
            return true;
        }

        @Override
        public Integer resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            Optional profile = Optional.ofNullable(source.m_81377_().m_129927_()).flatMap(m -> m.m_10996_(value));
            if (profile.isPresent()) {
                return ColonyIdArgument.resolveByOwner(source, ((GameProfile)profile.get()).getId());
            }
            throw ERROR_UNKNOWN_PLAYER.create();
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            suggestionProvider.m_5982_().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
    }
}

