/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IAnimalData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingAddedModEvent;
import com.minecolonies.api.eventbus.events.colony.buildings.BuildingRemovedModEvent;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildingextensions.registry.BuildingExtensionDataManager;
import com.minecolonies.core.colony.buildings.BuildingMysticalSite;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.event.QuestObjectiveEventHandler;
import com.minecolonies.core.network.messages.client.colony.ColonyViewBuildingExtensionsUpdateMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisteredStructureManager
implements IRegisteredStructureManager {
    @NotNull
    private ImmutableMap<BlockPos, IBuilding> buildings = ImmutableMap.of();
    private final Map<IBuildingExtension.ExtensionId, IBuildingExtension> buildingExtensions = new HashMap<IBuildingExtension.ExtensionId, IBuildingExtension>();
    private final List<IWareHouse> wareHouses = new ArrayList<IWareHouse>();
    private final List<IMysticalSite> mysticalSites = new ArrayList<IMysticalSite>();
    private ImmutableList<BlockPos> leisureSites = ImmutableList.of();
    @Nullable
    private ITownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isBuildingExtensionsDirty = false;
    private final Colony colony;
    private int minChunkX;
    private int maxChunkX;
    private int minChunkZ;
    private int maxChunkZ;

    public RegisteredStructureManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.buildings = ImmutableMap.of();
        this.maxChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.minChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.maxChunkZ = this.colony.getCenter().m_123343_() >> 4;
        this.minChunkZ = this.colony.getCenter().m_123343_() >> 4;
        ListTag extensionsTagList = compound.m_128441_("fields") ? compound.m_128437_("fields", 10) : compound.m_128437_("building_extensions", 10);
        for (int i = 0; i < extensionsTagList.size(); ++i) {
            try {
                CompoundTag extensionCompound = extensionsTagList.m_128728_(i);
                IBuildingExtension extension = BuildingExtensionDataManager.compoundToExtension(extensionCompound);
                if (extension == null) continue;
                this.addBuildingExtension(extension);
                continue;
            }
            catch (Exception e) {
                Log.getLogger().error("Failure loading building extension", (Throwable)e);
            }
        }
        ListTag buildingTagList = compound.m_128437_("buildings", 10);
        for (int i = 0; i < buildingTagList.size(); ++i) {
            CompoundTag buildingCompound = buildingTagList.m_128728_(i);
            @Nullable IBuilding b = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
            this.setMaxChunk(b);
        }
        if (compound.m_128441_("leisureSites")) {
            ListTag leisureTagList = compound.m_128437_("leisureSites", 10);
            ArrayList<BlockPos> leisureSitesList = new ArrayList<BlockPos>();
            for (int i = 0; i < leisureTagList.size(); ++i) {
                BlockPos pos = BlockPosUtil.read(leisureTagList.m_128728_(i), "pos");
                if (leisureSitesList.contains(pos)) continue;
                leisureSitesList.add(pos);
            }
            this.leisureSites = ImmutableList.copyOf(leisureSitesList);
        }
        for (IBuildingExtension extension : this.buildingExtensions.values()) {
            if (!extension.isTaken()) continue;
            IBuilding building = (IBuilding)this.buildings.get((Object)extension.getBuildingId());
            if (building == null) {
                extension.resetOwningBuilding();
                continue;
            }
            BuildingExtensionsModule extensionsModule = (BuildingExtensionsModule)building.getFirstModuleOccurance(BuildingExtensionsModule.class);
            if (extensionsModule != null && extension.getClass().equals(extensionsModule.getExpectedExtensionType())) continue;
            extension.resetOwningBuilding();
            if (extensionsModule == null) continue;
            extensionsModule.freeExtension(extension);
        }
    }

    private void setMaxChunk(IBuilding b) {
        int chunkX = b.getPosition().m_123341_() >> 4;
        int chunkZ = b.getPosition().m_123343_() >> 4;
        if (chunkX >= this.maxChunkX) {
            this.maxChunkX = chunkX + 1;
        }
        if (chunkX <= this.minChunkX) {
            this.minChunkX = chunkX - 1;
        }
        if (chunkZ >= this.maxChunkZ) {
            this.maxChunkZ = chunkZ + 1;
        }
        if (chunkZ <= this.minChunkZ) {
            this.minChunkZ = chunkZ - 1;
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag buildingTagList = new ListTag();
        for (IBuilding b : this.buildings.values()) {
            @NotNull CompoundTag buildingCompound = b.serializeNBT();
            buildingTagList.add((Object)buildingCompound);
        }
        compound.m_128365_("buildings", (Tag)buildingTagList);
        compound.m_128365_("building_extensions", (Tag)this.buildingExtensions.values().stream().map(BuildingExtensionDataManager::extensionToCompound).collect(NBTUtils.toListNBT()));
        @NotNull ListTag leisureTagList = new ListTag();
        for (BlockPos pos : this.leisureSites) {
            @NotNull CompoundTag leisureCompound = new CompoundTag();
            BlockPosUtil.write(leisureCompound, "pos", pos);
            leisureTagList.add((Object)leisureCompound);
        }
        compound.m_128365_("leisureSites", (Tag)leisureTagList);
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.isBuildingExtensionsDirty = false;
        this.buildings.values().forEach(ISchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        this.sendBuildingPackets(closeSubscribers, newSubscribers);
        this.sendBuildingExtensionPackets(closeSubscribers, newSubscribers);
        this.isBuildingsDirty = false;
        this.isBuildingExtensionsDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        for (IBuilding building : this.buildings.values()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), building.getPosition())) continue;
            building.onColonyTick(colony);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull IColony colony) {
        @Nullable ArrayList<IBuilding> removedBuildings = new ArrayList<IBuilding>();
        ArrayList tempBuildings = new ArrayList(this.buildings.values());
        for (IBuilding building : tempBuildings) {
            BlockPos loc = building.getPosition();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), loc) || building.isMatchingBlock(colony.getWorld().m_8055_(loc).m_60734_())) continue;
            removedBuildings.add(building);
        }
        if (this.buildingExtensions.entrySet().removeIf(extension -> WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), ((IBuildingExtension)extension.getValue()).getPosition()) && (!colony.isCoordInColony(colony.getWorld(), ((IBuildingExtension)extension.getValue()).getPosition()) || !((IBuildingExtension)extension.getValue()).isValidPlacement(colony)))) {
            this.markBuildingExtensionsDirty();
        }
        for (BlockPos pos : this.leisureSites) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), pos) || colony.getWorld().m_7702_(pos) instanceof TileEntityDecorationController) continue;
            this.removeLeisureSite(pos);
        }
        if (!removedBuildings.isEmpty() && removedBuildings.size() >= this.buildings.values().size()) {
            Log.getLogger().warn("Colony:" + colony.getID() + " is removing all buildings at once. Did you just load a backup? If not there is a chance that colony data got corrupted and you want to restore a backup.");
        }
        removedBuildings.forEach(IBuilding::destroy);
    }

    @Override
    public IBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return (IBuilding)this.buildings.get((Object)buildingId);
        }
        return null;
    }

    @Override
    public List<BlockPos> getLeisureSites() {
        return this.leisureSites;
    }

    @Override
    public BlockPos getRandomLeisureSite() {
        boolean isRaining = this.colony.getWorld().m_46471_();
        BlockPos building = null;
        int randomDist = MathUtils.RANDOM.nextInt(4);
        if (randomDist < 1) {
            BlockPos blockPos = building = this.townHall != null && this.townHall.getBuildingLevel() >= 3 ? this.townHall.getPosition() : null;
            if (building != null) {
                return building;
            }
        }
        if (randomDist < 2) {
            building = !isRaining && MathUtils.RANDOM.nextBoolean() ? this.getRandomBuilding(b -> b instanceof BuildingMysticalSite && b.getBuildingLevel() >= 1) : (MathUtils.RANDOM.nextBoolean() ? this.getRandomBuilding(b -> b instanceof BuildingLibrary && b.getBuildingLevel() >= 1) : this.getRandomBuilding(b -> b instanceof BuildingUniversity && b.getBuildingLevel() >= 1));
        }
        if (building != null) {
            return building;
        }
        if ((randomDist < 3 || isRaining && (this.townHall == null || this.townHall.getBuildingLevel() < 1)) && (building = this.getRandomBuilding(b -> b.hasModule(BuildingModules.TAVERN_VISITOR) && b.getBuildingLevel() >= 1)) != null) {
            return building;
        }
        if (isRaining) {
            return this.townHall == null ? null : this.townHall.getPosition();
        }
        return this.leisureSites.isEmpty() ? null : (BlockPos)this.leisureSites.get(MathUtils.RANDOM.nextInt(this.leisureSites.size()));
    }

    @Override
    @Nullable
    public IBuilding getFirstBuildingMatching(Predicate<IBuilding> predicate) {
        for (IBuilding building : this.buildings.values()) {
            if (!predicate.test(building)) continue;
            return building;
        }
        return null;
    }

    @Override
    public void addLeisureSite(BlockPos pos) {
        ArrayList<BlockPos> tempList = new ArrayList<BlockPos>((Collection<BlockPos>)this.leisureSites);
        if (!tempList.contains(pos)) {
            tempList.add(pos);
            this.leisureSites = ImmutableList.copyOf(tempList);
            this.markBuildingsDirty();
        }
    }

    @Override
    public void removeLeisureSite(BlockPos pos) {
        if (this.leisureSites.contains((Object)pos)) {
            ArrayList<BlockPos> tempList = new ArrayList<BlockPos>((Collection<BlockPos>)this.leisureSites);
            tempList.remove(pos);
            this.leisureSites = ImmutableList.copyOf(tempList);
            this.markBuildingsDirty();
        }
    }

    @Override
    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos pos) {
        IWareHouse wareHouse = null;
        double dist = 0.0;
        for (IWareHouse building : this.wareHouses) {
            if (building.getBuildingLevel() <= 0 || building.getTileEntity() == null) continue;
            double tempDist = building.getPosition().m_123331_((Vec3i)pos);
            if (wareHouse != null && !(tempDist < dist)) continue;
            dist = tempDist;
            wareHouse = building;
        }
        return wareHouse;
    }

    @Override
    public boolean keepChunkColonyLoaded(LevelChunk chunk) {
        Set<BlockPos> capList = ColonyUtils.getAllClaimingBuildings(chunk).get(this.colony.getID());
        return capList != null && capList.size() >= (Integer)MineColonies.getConfig().getServer().colonyLoadStrictness.get();
    }

    @Override
    public IBuilding getHouseWithSpareBed() {
        for (IBuilding building : this.buildings.values()) {
            LivingBuildingModule module;
            if (!building.hasModule(LivingBuildingModule.class) || HiringMode.LOCKED.equals((Object)(module = (LivingBuildingModule)building.getFirstModuleOccurance(LivingBuildingModule.class)).getHiringMode()) || module.getAssignedCitizen().size() >= module.getModuleMax()) continue;
            return building;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<BlockPos, IBuilding> getBuildings() {
        return this.buildings;
    }

    @Override
    @Nullable
    public ITownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public int getMysticalSiteMaxBuildingLevel() {
        int maxLevel = 0;
        if (this.hasMysticalSite()) {
            for (IMysticalSite mysticalSite : this.mysticalSites) {
                if (mysticalSite.getBuildingLevel() <= maxLevel) continue;
                maxLevel = mysticalSite.getBuildingLevel();
            }
        }
        return maxLevel;
    }

    @Override
    public boolean hasWarehouse() {
        return !this.wareHouses.isEmpty();
    }

    @Override
    public boolean hasMysticalSite() {
        return !this.mysticalSites.isEmpty();
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public <B extends IBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((IBuilding)type.cast(this.buildings.get((Object)buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding tileEntity, Level world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey((Object)tileEntity.getPosition())) {
            @Nullable IBuilding building = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                building.upgradeBuildingLevelToSchematicData();
                Log.getLogger().debug(String.format("Colony %d - new Building %s for %s at %s", this.colony.getID(), building.getBuildingDisplayName(), tileEntity.m_58900_().m_60734_(), tileEntity.getPosition()));
                building.setIsMirrored(tileEntity.isMirrored());
                if (tileEntity.m_58900_().m_60734_() instanceof AbstractBlockHut) {
                    if (tileEntity.getStructurePack() != null) {
                        building.setStructurePack(tileEntity.getStructurePack().getName());
                        building.setBlueprintPath(tileEntity.getBlueprintPath());
                    } else {
                        building.setStructurePack(this.colony.getStructurePack());
                    }
                }
                if (world != null && !(building instanceof IRSComponent)) {
                    building.onPlacement();
                }
                this.colony.getRequestManager().onProviderAddedToColony(building);
                this.setMaxChunk(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.m_58900_().getClass(), tileEntity.getPosition()), (Throwable)new Exception());
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.colony.getPackageManager().updateSubscribers();
            IMinecoloniesAPI.getInstance().getEventBus().post(new BuildingAddedModEvent(building));
            return building;
        }
        return null;
    }

    @Override
    public void removeBuilding(@NotNull IBuilding building, Set<ServerPlayer> subscribers) {
        if (this.buildings.containsKey((Object)building.getID())) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (IBuilding tbuilding : this.buildings.values()) {
                if (tbuilding == building) continue;
                builder.put((Object)tbuilding.getID(), (Object)tbuilding);
            }
            this.buildings = builder.build();
            for (ServerPlayer player : subscribers) {
                Network.getNetwork().sendToPlayer(new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouses.remove(building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.remove(building);
        }
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
            building.cancelAllRequestsOfCitizenOrBuilding(citizen);
        }
        for (IAnimalData animal : this.colony.getAnimalManager().getAnimals()) {
            animal.onRemoveBuilding(building);
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        this.colony.getRequestManager().onRequesterRemovedFromColony(building.getRequester());
        this.colony.getCitizenManager().calculateMaxCitizens();
        IMinecoloniesAPI.getInstance().getEventBus().post(new BuildingRemovedModEvent(building));
    }

    @Override
    public BlockPos getBestBuilding(AbstractEntityCitizen citizen, Class<? extends IBuilding> building) {
        return this.getBestBuilding(citizen.m_20183_(), building);
    }

    @Override
    public <T extends IBuilding> BlockPos getBestBuilding(AbstractEntityCitizen citizen, Class<T> building, @NotNull Predicate<T> filter) {
        return this.getBestBuilding(citizen.m_20183_(), building, filter);
    }

    @Override
    public BlockPos getBestBuilding(BlockPos pos, Class<? extends IBuilding> building) {
        return this.getBestBuilding(pos, building, (T b) -> true);
    }

    @Override
    public <T extends IBuilding> BlockPos getBestBuilding(BlockPos pos, Class<T> building, @NotNull Predicate<T> filter) {
        double distance = Double.MAX_VALUE;
        BlockPos goodFit = null;
        for (IBuilding currentBuilding : this.buildings.values()) {
            double localDistance;
            if (!building.isInstance(currentBuilding) || currentBuilding.getBuildingLevel() <= 0 || !WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), currentBuilding.getPosition()) || !filter.test(currentBuilding) || !((localDistance = currentBuilding.getPosition().m_123331_((Vec3i)pos)) < distance)) continue;
            distance = localDistance;
            goodFit = currentBuilding.getPosition();
        }
        return goodFit;
    }

    @Override
    public BlockPos getRandomBuilding(Predicate<IBuilding> filterPredicate) {
        ArrayList<IBuilding> allowedBuildings = new ArrayList<IBuilding>();
        for (IBuilding building : this.buildings.values()) {
            if (!filterPredicate.test(building)) continue;
            allowedBuildings.add(building);
        }
        if (allowedBuildings.isEmpty()) {
            return null;
        }
        return ((IBuilding)allowedBuildings.get(MathUtils.RANDOM.nextInt(allowedBuildings.size()))).getPosition();
    }

    @Override
    public boolean hasGuardBuildingNear(IBuilding building) {
        if (building == null) {
            return true;
        }
        for (IBuilding colonyBuilding : this.getBuildings().values()) {
            BoundingBox guardedRegion;
            if (colonyBuilding.getBuildingLevel() <= 0 || !(colonyBuilding instanceof IGuardBuilding) && !(colonyBuilding instanceof BuildingBarracks) || !(guardedRegion = BlockPosUtil.getChunkAlignedBB(colonyBuilding.getPosition(), colonyBuilding.getClaimRadius(colonyBuilding.getBuildingLevel()))).m_71051_((Vec3i)building.getPosition())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void guardBuildingChangedAt(IBuilding guardBuilding, int newLevel) {
        int claimRadius = guardBuilding.getClaimRadius(Math.max(guardBuilding.getBuildingLevel(), newLevel));
        BoundingBox guardedRegion = BlockPosUtil.getChunkAlignedBB(guardBuilding.getPosition(), claimRadius);
        for (IBuilding building : this.getBuildings().values()) {
            if (!guardedRegion.m_71051_((Vec3i)building.getPosition())) continue;
            building.resetGuardBuildingNear();
        }
    }

    @Override
    public void setTownHall(@Nullable ITownHall building) {
        this.townHall = building;
    }

    @Override
    public List<IWareHouse> getWareHouses() {
        return this.wareHouses;
    }

    @Override
    public void removeWareHouse(IWareHouse wareHouse) {
        this.wareHouses.remove(wareHouse);
    }

    @Override
    public List<IMysticalSite> getMysticalSites() {
        return this.mysticalSites;
    }

    @Override
    public void removeMysticalSite(IMysticalSite mysticalSite) {
        this.mysticalSites.remove(mysticalSite);
    }

    @Override
    public void markBuildingExtensionsDirty() {
        this.isBuildingExtensionsDirty = true;
    }

    private void addBuilding(@NotNull IBuilding building) {
        this.buildings = new ImmutableMap.Builder().putAll(this.buildings).put((Object)building.getID(), (Object)building).build();
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (ITownHall)building;
        }
        if (building instanceof BuildingWareHouse) {
            this.wareHouses.add((IWareHouse)building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.add((IMysticalSite)building);
        }
    }

    private void sendBuildingPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isBuildingsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isBuildingsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!building.isDirty() && newSubscribers.isEmpty()) continue;
                ColonyViewBuildingViewMessage message = new ColonyViewBuildingViewMessage(building, !newSubscribers.isEmpty());
                players.forEach(player -> Network.getNetwork().sendToPlayer(message, (ServerPlayer)player));
            }
        }
    }

    private void sendBuildingExtensionPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isBuildingExtensionsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isBuildingExtensionsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewBuildingExtensionsUpdateMessage(this.colony, this.buildingExtensions.values()), (ServerPlayer)player));
        }
    }

    @Override
    public boolean canPlaceAt(Block block, BlockPos pos, Player player) {
        if (block instanceof AbstractBlockHut) {
            AbstractBlockHut hutblock = (AbstractBlockHut)block;
            return hutblock.canPlaceAt(pos, player);
        }
        return true;
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
        if (building != null) {
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.markBuildingsDirty();
            QuestObjectiveEventHandler.onBuildingUpgradeComplete(building, level);
        }
    }

    @Override
    @NotNull
    public List<IBuildingExtension> getBuildingExtensions(Predicate<IBuildingExtension> matcher) {
        return this.buildingExtensions.values().stream().filter(matcher).toList();
    }

    @Override
    public Optional<IBuildingExtension> getMatchingBuildingExtension(Predicate<IBuildingExtension> matcher) {
        return this.getBuildingExtensions(matcher).stream().findFirst();
    }

    @Override
    public boolean addBuildingExtension(IBuildingExtension extension) {
        if (this.buildingExtensions.putIfAbsent(extension.getId(), extension) == null) {
            this.markBuildingExtensionsDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removeBuildingExtension(Predicate<IBuildingExtension> matcher) {
        this.buildingExtensions.entrySet().removeIf(entry -> matcher.test((IBuildingExtension)entry.getValue()));
        this.markBuildingExtensionsDirty();
    }

    @Override
    @Nullable
    public IBuildingExtension getMatchingBuildingExtension(IBuildingExtension.ExtensionId extensionId) {
        return this.buildingExtensions.get(extensionId);
    }
}

