/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.blocks.BlockColonySign;
import com.minecolonies.core.client.render.worldevent.ColonyWorldRenderMacros;
import com.minecolonies.core.client.render.worldevent.WorldEventContext;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityColonySignRenderer
implements BlockEntityRenderer<TileEntityColonySign> {
    private final BakedModel model;
    private final BakedModel model2;
    private final BlockRenderDispatcher renderDispatcher;

    public TileEntityColonySignRenderer(BlockEntityRendererProvider.Context context) {
        this.model = context.m_173584_().m_110910_(ModBlocks.blockColonySign.m_49966_());
        this.model2 = context.m_173584_().m_110910_((BlockState)ModBlocks.blockColonySign.m_49966_().m_61124_((Property)BlockColonySign.CONNECTED, (Comparable)Boolean.valueOf(true)));
        this.renderDispatcher = context.m_173584_();
    }

    public void render(@NotNull TileEntityColonySign tileEntity, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        float relativeRotationToColony = tileEntity.getRelativeRotation();
        BlockState state = tileEntity.m_58900_();
        if (state.m_60734_() == ModBlocks.blockColonySign) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 0.5, 0.5);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(relativeRotationToColony));
            matrixStack.m_85837_(-0.5, -0.5, -0.5);
            this.renderSingleBlock(state, matrixStack, buffer, combinedLight, combinedOverlay, tileEntity.getTargetColonyId() != tileEntity.getCachedSignAboveColony());
            matrixStack.m_85849_();
            this.renderTextOnSide(matrixStack, relativeRotationToColony, tileEntity, buffer, combinedLight, true);
            this.renderTextOnSide(matrixStack, relativeRotationToColony, tileEntity, buffer, combinedLight, false);
        }
    }

    private void renderTextOnSide(PoseStack matrixStack, float relativeRotationToColony, @NotNull TileEntityColonySign tileEntity, @NotNull MultiBufferSource buffer, int combinedLight, boolean mirrored) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.5f, 0.5f, 0.5f);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(relativeRotationToColony));
        if (mirrored) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        matrixStack.m_252880_(-0.0f, -0.1f, 0.2f);
        matrixStack.m_85841_(0.007f, -0.007f, 0.007f);
        String colonyName = tileEntity.getColonyName();
        int distance = tileEntity.getColonyDistance();
        if (colonyName.isEmpty()) {
            this.renderText(matrixStack, buffer, combinedLight, "Unknown Colony", 0, 0.0f);
            this.renderText(matrixStack, buffer, combinedLight, Component.m_237110_((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, 0.0f);
        } else {
            String targetColonyName = tileEntity.getTargetColonyName();
            if (!targetColonyName.isEmpty() && tileEntity.getTargetColonyId() != tileEntity.getCachedSignAboveColony()) {
                int targetColonyDistance = tileEntity.getTargetColonyDistance();
                this.renderColonyNameOnSign(colonyName, matrixStack, buffer, combinedLight, distance, -10);
                this.renderColonyNameOnSign(targetColonyName, matrixStack, buffer, combinedLight, targetColonyDistance, -60);
            } else {
                this.renderColonyNameOnSign(colonyName, matrixStack, buffer, combinedLight, distance, -35);
            }
        }
        matrixStack.m_85849_();
    }

    private void renderColonyNameOnSign(String colonyName, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int distance, int offset) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(colonyName);
        if (textWidth > 90) {
            List splitName = Minecraft.m_91087_().f_91062_.m_92865_().m_92432_(colonyName, 90, Style.f_131099_);
            for (int i = 0; i < Math.min(2, splitName.size()); ++i) {
                this.renderText(matrixStack, buffer, combinedLight, ((FormattedText)splitName.get(i)).getString(), i, offset);
            }
            this.renderText(matrixStack, buffer, combinedLight, Component.m_237110_((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, offset);
        } else {
            this.renderText(matrixStack, buffer, combinedLight, colonyName, 0, offset);
            this.renderText(matrixStack, buffer, combinedLight, Component.m_237110_((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{distance}).getString(), 3, offset);
        }
    }

    private void renderSingleBlock(BlockState state, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay, boolean connected) {
        BakedModel usedModel = connected ? this.model2 : this.model;
        for (RenderType rt : usedModel.getRenderTypes(state, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
            this.renderDispatcher.m_110937_().renderModel(pose.m_85850_(), buffer.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), state, usedModel, 0.0f, 0.0f, 0.0f, combinedLight, combinedOverlay, ModelData.EMPTY, rt);
        }
    }

    private void renderText(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, String text, int line, float offset) {
        FormattedCharSequence iReorderingProcessor;
        int maxSize = 20;
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        if ((iReorderingProcessor = FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_)) != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            float x = -fontRenderer.m_92724_(iReorderingProcessor) / 2;
            fontRenderer.m_272191_(iReorderingProcessor, x, (float)line * 8.0f + offset, -589505536, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        }
    }

    public boolean shouldRenderOffScreen(TileEntityColonySign tileEntityMBE21) {
        return false;
    }

    public static void renderSignHover(WorldEventContext context) {
        BlockHitResult blockRayTraceResult;
        HitResult rayTraceResult = Minecraft.m_91087_().f_91077_;
        if (!(rayTraceResult instanceof BlockHitResult) || (blockRayTraceResult = (BlockHitResult)rayTraceResult).m_6662_() == HitResult.Type.MISS) {
            return;
        }
        BlockPos posAtCamera = blockRayTraceResult.m_82425_();
        if (context.clientLevel.m_8055_(posAtCamera).m_60734_() != ModBlocks.blockColonySign) {
            return;
        }
        BlockEntity blockEntity = context.clientLevel.m_7702_(posAtCamera);
        if (blockEntity instanceof TileEntityColonySign) {
            TileEntityColonySign tileEntityColonySign = (TileEntityColonySign)blockEntity;
            if (!BlockPos.f_121853_.equals((Object)tileEntityColonySign.getPreviousPos())) {
                TileEntityColonySignRenderer.renderTextBoxAtPos(context, tileEntityColonySign.getPreviousPos(), List.of(Component.m_237115_((String)"com.minecolonies.core.previous").getString()));
            }
            if (!BlockPos.f_121853_.equals((Object)tileEntityColonySign.getNextPosition())) {
                TileEntityColonySignRenderer.renderTextBoxAtPos(context, tileEntityColonySign.getNextPosition(), List.of(Component.m_237115_((String)"com.minecolonies.core.next").getString()));
            }
        }
    }

    private static void renderTextBoxAtPos(WorldEventContext context, BlockPos pos, List<String> text) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        ColonyWorldRenderMacros.renderLineBox(context.poseStack, buffer, new AABB(pos), 0.05f, -1, true);
        TileEntityColonySignRenderer.renderDebugText(pos, text, context.poseStack, true, 3, 2.5f, (MultiBufferSource)buffer);
        ColonyWorldRenderMacros.endRenderLineBox(buffer);
        buffer.m_109911_();
    }

    public static void renderDebugText(BlockPos renderPos, List<String> text, PoseStack matrixStack, boolean forceWhite, int mergeEveryXListElements, float scale, MultiBufferSource buffer) {
        if (mergeEveryXListElements < 1) {
            throw new IllegalArgumentException("mergeEveryXListElements is less than 1");
        }
        EntityRenderDispatcher erm = Minecraft.m_91087_().m_91290_();
        int cap = text.size();
        if (cap > 0) {
            Font fontrenderer = Minecraft.m_91087_().f_91062_;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)renderPos.m_123341_() + 0.5, (double)renderPos.m_123342_() + 0.6, (double)renderPos.m_123343_() + 0.5);
            matrixStack.m_252781_(erm.m_253208_());
            matrixStack.m_85841_(-0.014f, -0.014f, 0.014f);
            float backgroundTextOpacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int alphaMask = (int)(backgroundTextOpacity * 255.0f) << 24;
            Matrix4f rawPosMatrix = matrixStack.m_85850_().m_252922_();
            rawPosMatrix.scale(scale, scale, scale);
            for (int i = 0; i < cap; i += mergeEveryXListElements) {
                MutableComponent renderText = Component.m_237113_((String)(mergeEveryXListElements == 1 ? text.get(i) : text.subList(i, Math.min(i + mergeEveryXListElements, cap)).toString()));
                float textCenterShift = -fontrenderer.m_92852_((FormattedText)renderText) / 2;
                fontrenderer.m_272077_((Component)renderText, textCenterShift, 0.0f, forceWhite ? -1 : 0x20FFFFFF, false, rawPosMatrix, buffer, Font.DisplayMode.SEE_THROUGH, alphaMask, 0xF000F0);
                if (!forceWhite) {
                    fontrenderer.m_272077_((Component)renderText, textCenterShift, 0.0f, -1, false, rawPosMatrix, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                Objects.requireNonNull(fontrenderer);
                matrixStack.m_85837_(0.0, (double)(9 + 1), 0.0);
            }
            matrixStack.m_85849_();
        }
    }
}

