/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.core.entity.other.cavalry.CavalryHorseEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.horse.Horse;

public class CavalryOverlayLayer
extends RenderLayer<Horse, HorseModel<Horse>> {
    public CavalryOverlayLayer(RenderLayerParent<Horse, HorseModel<Horse>> parent) {
        super(parent);
    }

    public void render(@Nonnull PoseStack pose, @Nonnull MultiBufferSource buffer, int packedLight, @Nonnull Horse horse, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(horse instanceof CavalryHorseEntity)) {
            return;
        }
        CavalryHorseEntity cavhorse = (CavalryHorseEntity)horse;
        float threshold = horse.m_21233_() * 0.66f;
        float cooldown = Math.max(0.0f, cavhorse.getAnimalDataView() == null ? 0.0f : cavhorse.getAnimalDataView().getCombatCooldown());
        float readiness = Mth.m_14036_((float)(1.0f - cooldown / Math.max(0.001f, threshold)), (float)0.0f, (float)1.0f);
        int segments = Mth.m_14045_((int)((int)Math.floor(readiness * 5.0f + 1.0E-4f)), (int)0, (int)5);
        ResourceLocation OVERLAY_TEX = new ResourceLocation("minecolonies", "textures/entity/horse/cavalry_overlay_layer" + segments + ".png");
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)OVERLAY_TEX));
        ((HorseModel)this.m_117386_()).m_7695_(pose, vc, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.85f);
    }
}

