/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.requirements.BuildingAlternatesResearchRequirement;
import com.minecolonies.api.research.requirements.BuildingResearchRequirement;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.blockui.RotatingItemIcon;
import com.minecolonies.core.client.gui.modules.building.UniversityModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.university.TryResearchMessage;
import com.minecolonies.core.research.GlobalResearchEffect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowResearchTree
extends AbstractWindowSkeleton {
    private final ResourceLocation branch;
    private final IBuildingView building;
    private final UniversityModuleWindow last;
    private final ResearchBranchType branchType;
    private boolean hasMax;
    private final ButtonImage undoButton = new ButtonImage();
    private final Text undoText = new Text();
    private ItemIcon[] undoCostIcons = new ItemIcon[0];

    public WindowResearchTree(ResourceLocation branch, IBuildingView building, UniversityModuleWindow last) {
        super(last, new ResourceLocation("minecolonies", "gui/windowresearch.xml"));
        this.branch = branch;
        this.building = building;
        this.last = last;
        this.hasMax = false;
        this.branchType = IGlobalResearchTree.getInstance().getBranchData(branch).getType();
        List<ResourceLocation> researchList = IGlobalResearchTree.getInstance().getPrimaryResearch(branch);
        this.hasMax = building.getColony().getResearchManager().getResearchTree().branchFinishedHighestLevel(branch);
        ZoomDragView view = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        int maxHeight = this.drawTree(0, 0, view, researchList, false);
        this.drawTreeBackground(view, maxHeight);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        View parent = button.getParent();
        if (parent.getChildren().contains(this.undoButton)) {
            parent.removeChild((Pane)this.undoButton);
        }
        for (ItemIcon icon : this.undoCostIcons) {
            if (!parent.getChildren().contains(icon)) continue;
            parent.removeChild((Pane)icon);
        }
        if (parent.getChildren().contains(this.undoText)) {
            parent.removeChild((Pane)this.undoText);
        }
        if (!button.getID().isEmpty()) {
            if (button.getID().contains("undo:")) {
                String undoName = button.getID().substring(button.getID().indexOf(58) + 1);
                if (!ResourceLocation.m_135830_((String)undoName)) {
                    return;
                }
                ResourceLocation undoID = new ResourceLocation(undoName);
                ILocalResearch cancelResearch = this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, undoID);
                if (cancelResearch != null) {
                    if (cancelResearch.getState() == ResearchState.IN_PROGRESS) {
                        this.last.updateResearchCount(-1);
                    }
                    cancelResearch.setState(ResearchState.NOT_STARTED);
                    Network.getNetwork().sendToServer(new TryResearchMessage(this.building, cancelResearch.getId(), cancelResearch.getBranch(), true));
                    this.close();
                }
            } else if (ResourceLocation.m_135830_((String)button.getID()) && IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID())) != null && (this.building.getBuildingLevel() >= IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID())).getDepth() || this.building.getBuildingLevel() == this.building.getBuildingMaxLevel())) {
                IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID()));
                ILocalResearch localResearch = this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, research.getId());
                if (localResearch == null && this.building.getBuildingLevel() > this.building.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() && (research.hasEnoughResources((IItemHandler)new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_())) || this.mc.f_91074_.m_7500_())) {
                    research.startResearch(this.building.getColony().getResearchManager().getResearchTree());
                    this.last.updateResearchCount(0);
                    if (research.getDepth() > this.building.getBuildingMaxLevel()) {
                        this.hasMax = true;
                    }
                    Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch(), false));
                    this.close();
                } else if (localResearch != null) {
                    if (localResearch.getState() == ResearchState.IN_PROGRESS) {
                        this.drawUndoProgressButton(button);
                    }
                    if (localResearch.getState() == ResearchState.FINISHED) {
                        if (research.isImmutable() || research.isAutostart()) {
                            return;
                        }
                        for (ResourceLocation childId : research.getChildren()) {
                            if (this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, childId) == null || this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, childId).getState() == ResearchState.NOT_STARTED) continue;
                            return;
                        }
                        this.drawUndoCompleteButton(button);
                    }
                }
            } else if (button.getID().equals("cancel")) {
                this.last.open();
            }
        }
    }

    private int drawTree(int height, int depth, ZoomDragView view, List<ResourceLocation> researchList, boolean abandoned) {
        researchList.sort(Comparator.comparing(unsortedResearch -> IGlobalResearchTree.getInstance().getResearch(this.branch, (ResourceLocation)unsortedResearch).getSortOrder()));
        int nextHeight = height;
        for (int i = 0; i < researchList.size(); ++i) {
            IGlobalResearch research;
            if (i > 0) {
                ++nextHeight;
            }
            if ((research = IGlobalResearchTree.getInstance().getResearch(this.branch, researchList.get(i))).isHidden() && !IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirements(), this.building.getColony()) || ((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().workersAlwaysWorkInRain.get()).booleanValue() && research.getEffects().size() == 1 && research.getEffects().get(0).getId().equals((Object)ResearchConstants.WORKING_IN_RAIN) && this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, researchList.get(i)) == null) continue;
            int offsetX = depth * 215 + 10 + 3;
            int offsetY = nextHeight * 70 + 20 + 10;
            boolean trueAbandoned = this.drawResearchItem(view, offsetX, offsetY, research, abandoned);
            if (research.getParent() != null) {
                this.drawArrows(view, offsetX - 40, offsetY - 18, researchList.size(), research.getParent(), i, nextHeight, height);
            }
            if (research.getChildren().isEmpty()) continue;
            nextHeight = this.drawTree(nextHeight, depth + 1, view, research.getChildren(), trueAbandoned);
        }
        return nextHeight;
    }

    private void drawTreeBackground(ZoomDragView view, int maxHeight) {
        if (this.branchType == ResearchBranchType.UNLOCKABLES && IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(1) < 1) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            Text timeLabel = new Text();
            timeLabel.setSize(95, 12);
            timeLabel.setPosition((i - 1) * 215 + 87 - 23, 10);
            if (this.branchType == ResearchBranchType.UNLOCKABLES) {
                timeLabel.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.research.tier.header.unrestricted", (Object[])new Object[]{i > this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : i, IGlobalResearchTree.getInstance().getBranchData(this.branch).getHoursTime(i)}));
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_LABEL);
                view.addChild((Pane)timeLabel);
                continue;
            }
            timeLabel.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.research.tier.header", (Object[])new Object[]{i > this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : i, IGlobalResearchTree.getInstance().getBranchData(this.branch).getHoursTime(i)}));
            if (this.building.getBuildingLevel() < i && (this.building.getBuildingLevel() != this.building.getBuildingMaxLevel() || this.hasMax)) {
                Gradient gradient = new Gradient();
                gradient.setGradientStart(80, 80, 80, 100);
                gradient.setGradientEnd(60, 60, 60, 110);
                gradient.setSize(i == 6 ? 400 : 215, (maxHeight + 4) * 70 + 20 + 10);
                gradient.setPosition((i - 1) * 215, 0);
                view.addChild((Pane)gradient, 0);
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_NEGATIVE);
            } else {
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_LABEL);
            }
            view.addChild((Pane)timeLabel);
        }
    }

    private ResearchButtonState getResearchButtonState(boolean abandoned, boolean parentResearched, IGlobalResearch research, ResearchState state) {
        if (abandoned) {
            return ResearchButtonState.ABANDONED;
        }
        if (!parentResearched) {
            return ResearchButtonState.MISSING_PARENT;
        }
        if (state == ResearchState.FINISHED) {
            return ResearchButtonState.FINISHED;
        }
        if (state == ResearchState.IN_PROGRESS) {
            return ResearchButtonState.IN_PROGRESS;
        }
        if (research.getDepth() > this.building.getBuildingLevel() && (research.getDepth() <= this.building.getBuildingMaxLevel() || this.hasMax || this.building.getBuildingLevel() != this.building.getBuildingMaxLevel()) && this.branchType != ResearchBranchType.UNLOCKABLES) {
            return ResearchButtonState.TOO_LOW_UNIVERSITY;
        }
        if (this.mc.f_91074_.m_7500_()) {
            return ResearchButtonState.AVAILABLE;
        }
        if (!IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirements(), this.building.getColony())) {
            return ResearchButtonState.MISSING_REQUIREMENT;
        }
        if (!research.hasEnoughResources((IItemHandler)new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_()))) {
            return ResearchButtonState.MISSING_COST;
        }
        return ResearchButtonState.AVAILABLE;
    }

    private boolean drawResearchItem(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, boolean abandoned) {
        int progress;
        ILocalResearchTree tree = this.building.getColony().getResearchManager().getResearchTree();
        boolean parentResearched = tree.hasCompletedResearch(research.getParent());
        IGlobalResearch parentResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, research.getParent());
        ResearchState state = tree.getResearch(this.branch, research.getId()) == null ? ResearchState.NOT_STARTED : tree.getResearch(this.branch, research.getId()).getState();
        int n = progress = tree.getResearch(this.branch, research.getId()) == null ? 0 : tree.getResearch(this.branch, research.getId()).getProgress();
        if (this.mc.f_91074_.m_7500_() && state == ResearchState.IN_PROGRESS && ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue() && progress < IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth())) {
            Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch(), false));
        }
        if (research.getDepth() != 1 && state != ResearchState.FINISHED && state != ResearchState.IN_PROGRESS && parentResearch.hasOnlyChild() && parentResearch.hasResearchedChild(tree)) {
            abandoned = true;
        }
        ResearchButtonState researchState = this.getResearchButtonState(abandoned, parentResearched, research, state);
        this.drawResearchBoxes(view, offsetX, offsetY, research, researchState, progress);
        this.drawResearchReqsAndCosts(view, offsetX, offsetY, research, researchState);
        this.drawResearchIcons(view, offsetX, offsetY, research, researchState);
        this.drawResearchTexts(view, offsetX, offsetY, research, researchState, progress);
        return abandoned;
    }

    private void drawResearchBoxes(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state, int progress) {
        ButtonImage nameBar = new ButtonImage();
        nameBar.setSize(175, 21);
        nameBar.setPosition(offsetX, offsetY);
        ButtonImage iconBox = new ButtonImage();
        iconBox.setSize(21, 25);
        iconBox.setPosition(offsetX - 3, offsetY - 4);
        Image subBar = new Image();
        subBar.setPosition(offsetX + 7, offsetY + 18);
        subBar.setSize(164, 32);
        if (state != ResearchButtonState.FINISHED) {
            view.addChild((Pane)subBar);
        }
        view.addChild((Pane)nameBar);
        view.addChild((Pane)iconBox);
        switch (state) {
            case AVAILABLE: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_blue.png"), false);
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"), false);
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_blue.png"), false);
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                break;
            }
            case IN_PROGRESS: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_green.png"), false);
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_thin.png"), false);
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_green.png"), false);
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                this.drawProgressBar(view, offsetX, offsetY, research, progress, subBar);
                break;
            }
            case FINISHED: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_green.png"), false);
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_green.png"), false);
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                break;
            }
            case LOCKED: 
            case ABANDONED: 
            case MISSING_PARENT: 
            case TOO_LOW_UNIVERSITY: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_gray.png"), false);
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"), false);
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_gray.png"), false);
                break;
            }
            case TOO_MANY_PROGRESS: {
                ButtonImage tooMany1 = new ButtonImage();
                tooMany1.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"), false);
                tooMany1.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.research.toomanyinprogress.1"));
                tooMany1.setSize(129, 17);
                tooMany1.setPosition(offsetX + 30, offsetY + 17);
                view.addChild((Pane)tooMany1);
                ButtonImage tooMany2 = new ButtonImage();
                tooMany2.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"), false);
                tooMany2.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.research.toomanyinprogress.2"));
                tooMany2.setSize(129, 17);
                tooMany2.setPosition(offsetX + 30, offsetY + 34);
                view.addChild((Pane)tooMany2);
            }
            case MISSING_REQUIREMENT: 
            case MISSING_COST: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_plain.png"), false);
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"), false);
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini.png"), false);
                break;
            }
            default: {
                Log.getLogger().error("Error in DrawResearchBoxes for " + String.valueOf(research.getId()) + " state: " + String.valueOf((Object)state));
            }
        }
        this.generateResearchTooltips((Button)nameBar, research, state);
    }

    private void drawProgressBar(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, int progress, Image subBar) {
        Gradient nameGradient = new Gradient();
        nameGradient.setSize(175, 15);
        nameGradient.setPosition(offsetX, offsetY);
        view.addChild((Pane)nameGradient);
        nameGradient.setGradientStart(102, 225, 80, 60);
        nameGradient.setGradientEnd(102, 225, 80, 60);
        double progressRatio = (double)(progress + 1) / (double)IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth());
        subBar.setSize(164, 12);
        nameGradient.setSize((int)(progressRatio * 175.0), 18);
        Gradient subGradient = new Gradient();
        subGradient.setPosition(offsetX + 7, offsetY + 18);
        subGradient.setSize(subBar.getWidth(), subBar.getHeight());
        subGradient.setSize((int)(progressRatio * (double)subBar.getWidth()), 11);
        subGradient.setGradientStart(230, 200, 20, 60);
        subGradient.setGradientEnd(230, 200, 20, 60);
        view.addChild((Pane)subGradient);
    }

    /*
     * Unable to fully structure code
     */
    private void generateResearchTooltips(Button tipItem, IGlobalResearch research, ResearchButtonState state) {
        hoverPaneBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)tipItem).append(MutableComponent.m_237204_((ComponentContents)research.getName()).m_6881_())).bold()).color(ResearchConstants.COLOR_TEXT_NAME);
        if (!research.getSubtitle().m_237508_().isEmpty()) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).italic()).colorName("GRAY")).append(MutableComponent.m_237204_((ComponentContents)research.getSubtitle()));
        }
        for (txt = 0; txt < research.getEffects().size(); ++txt) {
            researchEffect = research.getEffects().get(txt);
            if (!(researchEffect instanceof GlobalResearchEffect)) ** GOTO lbl-1000
            globalResearchEffect = (GlobalResearchEffect)researchEffect;
            if (researchEffect.getId().equals((Object)ResearchConstants.CITIZEN_CAP) && globalResearchEffect.getEffect() > (double)((Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().maxCitizenPerColony.get()).intValue()) {
                mainText = Component.m_237110_((String)researchEffect.getName().m_237508_(), (Object[])new Object[]{0, IMinecoloniesAPI.getInstance().getConfig().getServer().maxCitizenPerColony.get()});
                finishText = Component.m_237110_((String)(researchEffect.getName().m_237508_() + ".over"), (Object[])new Object[]{Math.round(globalResearchEffect.getEffect())});
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(mainText)).append(Component.m_237113_((String)" "))).append(finishText);
            } else lbl-1000:
            // 2 sources

            {
                ((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(MutableComponent.m_237204_((ComponentContents)researchEffect.getName()));
            }
            if (researchEffect.getSubtitle().m_237508_().isEmpty()) continue;
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237113_((String)"-"))).append(MutableComponent.m_237204_((ComponentContents)researchEffect.getSubtitle()))).italic()).colorName("GRAY");
        }
        if (state != ResearchButtonState.FINISHED && state != ResearchButtonState.IN_PROGRESS) {
            for (txt = 0; txt < research.getResearchRequirements().size(); ++txt) {
                if (research.getResearchRequirements().get(txt).isFulfilled(this.building.getColony())) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237113_((String)" - "))).color(ResearchConstants.COLOR_TEXT_FULFILLED)).append(research.getResearchRequirements().get(txt).getDesc());
                    continue;
                }
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237113_((String)" - "))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).append(research.getResearchRequirements().get(txt).getDesc());
            }
            for (IResearchCost cost : research.getCostList()) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237113_((String)" - "))).append(Component.m_237110_((String)"com.minecolonies.coremod.research.limit.requirement", (Object[])new Object[]{cost.getCount(), cost.getTranslatedName()}));
                if (research.hasEnoughResources((IItemHandler)new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_()))) {
                    hoverPaneBuilder.color(ResearchConstants.COLOR_TEXT_FULFILLED);
                    continue;
                }
                hoverPaneBuilder.color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
            }
            if (research.getDepth() > this.building.getBuildingLevel() && this.building.getBuildingLevel() != this.building.getBuildingMaxLevel() && this.branchType != ResearchBranchType.UNLOCKABLES) {
                ((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.university.level", (Object[])new Object[]{Math.min(research.getDepth(), this.building.getBuildingMaxLevel())}));
            }
            if (research.getDepth() == 6 && this.branchType != ResearchBranchType.UNLOCKABLES) {
                if (this.hasMax) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237115_((String)"com.minecolonies.coremod.research.limit.onemaxperbranch"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
                } else {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237115_((String)"com.minecolonies.coremod.research.limit.onemaxperbranch"))).color(ResearchConstants.COLOR_TEXT_FULFILLED);
                }
            }
        }
        if (research.isImmutable()) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append(Component.m_237115_((String)"com.minecolonies.coremod.research.limit.immutable"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
        }
        hoverPaneBuilder.build();
    }

    private void drawResearchTexts(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state, int progress) {
        Text nameText = new Text();
        nameText.setSize(175, 18);
        nameText.setText(MutableComponent.m_237204_((ComponentContents)research.getName()));
        nameText.setPosition(offsetX + 15 + 5, offsetY);
        nameText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        nameText.setTextScale((double)1.4f);
        nameText.setEnabled(false);
        view.addChild((Pane)nameText);
        if (state == ResearchButtonState.IN_PROGRESS) {
            double progressToGo = research.isInstant() || this.mc.f_91074_.m_7500_() && (Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get() != false ? 0.0 : (double)(IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth()) - progress);
            int hours = (int)(progressToGo / 144.0);
            int increments = (int)Math.ceil(progressToGo % 144.0 / 36.0);
            String timeRemaining = increments == 4 ? String.format("%d:%02d", hours + 1, 0) : String.format("%d:%02d", hours, increments * 15);
            Text progressLabel = new Text();
            progressLabel.setSize(175, 10);
            progressLabel.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.research.time", (Object[])new Object[]{timeRemaining}));
            progressLabel.setPosition(offsetX + 15 + 5, offsetY + 18);
            progressLabel.setColors(ResearchConstants.COLOR_TEXT_DARK);
            progressLabel.setTextScale((double)0.7f);
            progressLabel.setID(research.getId().toString());
            view.addChild((Pane)progressLabel);
        }
    }

    private void drawUndoProgressButton(Button parent) {
        this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"), false);
        this.undoButton.setSize(129, 17);
        this.undoButton.setPosition(parent.getX() + 23, parent.getY() + 6 + 16);
        this.undoButton.setID("undo:" + parent.getID());
        parent.getParent().addChild((Pane)this.undoButton);
        this.undoText.setSize(129, 17);
        this.undoText.setPosition(parent.getX() + 5 + 23, parent.getY() + 6 + 16);
        this.undoText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        this.undoText.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.undo.progress"));
        this.undoText.disable();
        parent.getParent().addChild((Pane)this.undoText);
        ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)this.undoButton).append(Component.m_237115_((String)"com.minecolonies.coremod.research.undo.progress.tooltip"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).bold()).build();
    }

    private void drawUndoCompleteButton(Button parent) {
        List<ItemStorage> costList = IGlobalResearchTree.getInstance().getResearchResetCosts();
        this.undoCostIcons = new ItemIcon[costList.size()];
        ArrayList<ItemStorage> missingItems = new ArrayList<ItemStorage>();
        for (int i = 0; i < costList.size(); ++i) {
            ItemStorage is = costList.get(i);
            this.undoCostIcons[i] = new ItemIcon();
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_()), stack -> !ItemStackUtils.isEmpty(stack) && ItemStack.m_41656_((ItemStack)stack, (ItemStack)is.getItemStack())) < is.getAmount()) {
                missingItems.add(is);
            }
            this.undoCostIcons[i].setItem(is.getItemStack());
            this.undoCostIcons[i].setPosition(parent.getX() + 175 + 16 * i, parent.getY() + 6 + 16);
            this.undoCostIcons[i].setSize(16, 16);
            parent.getParent().addChild((Pane)this.undoCostIcons[0]);
        }
        this.undoButton.setSize(129, 17);
        this.undoButton.setPosition(parent.getX(), parent.getY() + 6 + 16);
        AbstractTextBuilder.TooltipBuilder undoTipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)this.undoButton).append(Component.m_237115_((String)"com.minecolonies.coremod.research.undo.remove.tooltip"))).bold()).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
        this.undoText.setSize(129, 17);
        this.undoText.setPosition(parent.getX() + 5, parent.getY() + 6 + 16);
        this.undoText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        if (!missingItems.isEmpty()) {
            this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"), false);
            this.undoText.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.research.notenoughresources"));
            for (ItemStorage cost : missingItems) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)undoTipBuilder.paragraphBreak()).append(Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.research", (Object[])new Object[]{cost.getItem().m_41466_()}))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
            }
        } else {
            this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"), false);
            this.undoButton.setID("undo:" + parent.getID());
            this.undoText.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.undo.remove"));
        }
        this.undoText.disable();
        parent.getParent().addChild((Pane)this.undoButton);
        parent.getParent().addChild((Pane)this.undoText);
        undoTipBuilder.build();
    }

    private void drawResearchReqsAndCosts(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state) {
        RotatingItemIcon icon;
        if (state == ResearchButtonState.ABANDONED || state == ResearchButtonState.IN_PROGRESS || state == ResearchButtonState.FINISHED) {
            return;
        }
        int storageXOffset = 15;
        ArrayList alternateBuildingRequirements = new ArrayList();
        ArrayList buildingRequirements = new ArrayList();
        List<IResearchCost> itemRequirements = research.getCostList();
        research.getResearchRequirements().forEach(requirement -> {
            if (requirement instanceof BuildingAlternatesResearchRequirement) {
                BuildingAlternatesResearchRequirement alternateBuildingRequirement = (BuildingAlternatesResearchRequirement)requirement;
                alternateBuildingRequirements.add(alternateBuildingRequirement);
            } else if (requirement instanceof BuildingResearchRequirement) {
                BuildingResearchRequirement buildingRequirement = (BuildingResearchRequirement)requirement;
                buildingRequirements.add(buildingRequirement);
            }
        });
        for (IResearchRequirement requirement2 : alternateBuildingRequirements) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ResourceLocation building : ((BuildingAlternatesResearchRequirement)requirement2).getBuildings()) {
                stacks.add(Optional.ofNullable((BuildingEntry)IBuildingRegistry.getInstance().getValue(building)).map(arg_0 -> WindowResearchTree.lambda$drawResearchReqsAndCosts$3((BuildingAlternatesResearchRequirement)requirement2, arg_0)).orElse(Items.f_41852_.m_7968_()));
            }
            icon = new RotatingItemIcon();
            icon.setItems(stacks);
            icon.setPosition(offsetX + storageXOffset, offsetY + 18 + 6);
            icon.setSize(16, 16);
            view.addChild((Pane)icon);
            if (((BuildingAlternatesResearchRequirement)requirement2).isFulfilled(this.building.getColony())) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(((BuildingAlternatesResearchRequirement)requirement2).getDesc())).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            } else {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(((BuildingAlternatesResearchRequirement)requirement2).getDesc())).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).build();
            }
            storageXOffset += 20;
        }
        for (IResearchRequirement requirement2 : buildingRequirements) {
            ItemStack stack2 = Optional.ofNullable((BuildingEntry)IBuildingRegistry.getInstance().getValue(((BuildingResearchRequirement)requirement2).getBuilding())).map(arg_0 -> WindowResearchTree.lambda$drawResearchReqsAndCosts$4((BuildingResearchRequirement)requirement2, arg_0)).orElse(Items.f_41852_.m_7968_());
            icon = new ItemIcon();
            icon.setItem(stack2);
            icon.setPosition(offsetX + storageXOffset, offsetY + 18 + 6);
            icon.setSize(16, 16);
            view.addChild((Pane)icon);
            if (((BuildingResearchRequirement)requirement2).isFulfilled(this.building.getColony())) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(((BuildingResearchRequirement)requirement2).getDesc())).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            } else {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append(((BuildingResearchRequirement)requirement2).getDesc())).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).build();
            }
            storageXOffset += 20;
        }
        storageXOffset = 20;
        for (IResearchCost cost : itemRequirements) {
            RotatingItemIcon icon2 = new RotatingItemIcon();
            icon2.setPosition(offsetX + 175 - storageXOffset - 10, offsetY + 18 + 6);
            icon2.setSize(16, 16);
            if (cost.getItems().size() == 0) {
                Log.getLogger().error("Found Empty list requirement for: " + String.valueOf(research.getId()) + ". Please report this to the developers.");
                continue;
            }
            icon2.setItems(cost.getItems().stream().map(ItemStack::new).map(stack -> {
                stack.m_41764_(cost.getCount());
                return stack;
            }).toList());
            view.addChild((Pane)icon2);
            storageXOffset += 20;
        }
    }

    private void drawResearchIcons(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state) {
        if (research.isImmutable() && state != ResearchButtonState.FINISHED) {
            Image immutIcon = new Image();
            immutIcon.setImage(new ResourceLocation("minecraft", "textures/block/redstone_torch.png"), false);
            immutIcon.setSize(16, 16);
            immutIcon.setPosition(offsetX + 175 - 16, offsetY);
            view.addChild((Pane)immutIcon);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)immutIcon).paragraphBreak()).append(Component.m_237115_((String)"com.minecolonies.coremod.research.limit.immutable"))).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
        }
        switch (state) {
            case LOCKED: 
            case ABANDONED: 
            case MISSING_PARENT: 
            case TOO_LOW_UNIVERSITY: 
            case TOO_MANY_PROGRESS: 
            case MISSING_REQUIREMENT: {
                Image lockIcon = new Image();
                lockIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/locked_icon_light_gray.png"), false);
                lockIcon.setSize(16, 16);
                lockIcon.setPosition(offsetX, offsetY);
                view.addChild((Pane)lockIcon);
                break;
            }
            case MISSING_COST: {
                Image unlockIcon = new Image();
                unlockIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/locked_icon_unlocked_blue.png"), false);
                unlockIcon.setSize(16, 16);
                unlockIcon.setPosition(offsetX, offsetY);
                view.addChild((Pane)unlockIcon);
                break;
            }
            case AVAILABLE: {
                ButtonImage icon = new ButtonImage();
                icon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_start.png"), false);
                icon.setSize(16, 16);
                icon.setPosition(offsetX, offsetY);
                icon.setID(research.getId().toString());
                view.addChild((Pane)icon);
                break;
            }
            case IN_PROGRESS: {
                ButtonImage playIcon = new ButtonImage();
                playIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_cancel.png"), false);
                playIcon.setSize(16, 16);
                playIcon.setPosition(offsetX, offsetY);
                playIcon.setID(research.getId().toString());
                view.addChild((Pane)playIcon);
                break;
            }
            case FINISHED: {
                ButtonImage checkIcon = new ButtonImage();
                checkIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_check.png"), false);
                checkIcon.setSize(16, 16);
                checkIcon.setPosition(offsetX, offsetY);
                checkIcon.setID(research.getId().toString());
                view.addChild((Pane)checkIcon);
                break;
            }
            default: {
                Log.getLogger().error("Error with DrawIcons :" + String.valueOf(research.getId()));
            }
        }
    }

    private void drawArrows(ZoomDragView view, int offsetX, int offsetY, int researchListSize, ResourceLocation parentResearch, int currentCounter, int nextHeight, int parentHeight) {
        boolean lastSibling;
        boolean firstSibling = currentCounter == 0;
        boolean secondSibling = currentCounter >= 1;
        boolean bl = lastSibling = currentCounter + 1 >= researchListSize;
        if (firstSibling && lastSibling) {
            Image corner = new Image();
            corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right.png"), false);
            corner.setSize(37, 50);
            corner.setPosition(offsetX, offsetY);
            view.addChild((Pane)corner);
        } else {
            Image corner;
            if (secondSibling) {
                for (int dif = 1; dif < nextHeight - parentHeight; ++dif) {
                    corner = new Image();
                    corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_down.png"), false);
                    corner.setSize(37, 70);
                    corner.setPosition(offsetX - 3, offsetY - dif * corner.getHeight());
                    view.addChild((Pane)corner);
                }
            }
            if (firstSibling) {
                Image corner2 = new Image();
                corner2.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_down.png"), false);
                corner2.setSize(37, 70);
                corner2.setPosition(offsetX - 3, offsetY);
                view.addChild((Pane)corner2);
            } else if (IGlobalResearchTree.getInstance().getResearch(this.branch, parentResearch).hasOnlyChild()) {
                Text orLabel = new Text();
                orLabel.setSize(16, 16);
                orLabel.setColors(ResearchConstants.COLOR_TEXT_DARK);
                orLabel.setText(Component.m_237115_((String)"com.minecolonies.coremod.research.research.or"));
                orLabel.setPosition(offsetX + 10, offsetY + 6);
                view.addChild((Pane)orLabel);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)orLabel).append(Component.m_237115_((String)"com.minecolonies.coremod.research.research.or.tooltip"))).build();
                if (lastSibling) {
                    Image circle = new Image();
                    circle.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or.png"), false);
                    circle.setSize(37, 50);
                    circle.setPosition(offsetX - 3, offsetY);
                    view.addChild((Pane)circle);
                } else {
                    corner = new Image();
                    corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or_down.png"), false);
                    corner.setSize(37, 70);
                    corner.setPosition(offsetX - 3, offsetY + 4);
                    view.addChild((Pane)corner);
                }
            } else {
                Image corner3 = new Image();
                if (lastSibling) {
                    corner3.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and.png"), false);
                    corner3.setSize(37, 50);
                } else {
                    corner3.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and_more.png"), false);
                    corner3.setSize(37, 70);
                }
                corner3.setPosition(offsetX - 3, offsetY);
                view.addChild((Pane)corner3);
            }
        }
    }

    private static /* synthetic */ ItemStack lambda$drawResearchReqsAndCosts$4(BuildingResearchRequirement requirement, BuildingEntry entry) {
        return new ItemStack((ItemLike)entry.getBuildingBlock().m_5456_(), requirement.getBuildingLevel());
    }

    private static /* synthetic */ ItemStack lambda$drawResearchReqsAndCosts$3(BuildingAlternatesResearchRequirement requirement, BuildingEntry entry) {
        return new ItemStack((ItemLike)entry.getBuildingBlock().m_5456_(), requirement.getBuildingLevel());
    }

    static enum ResearchButtonState {
        AVAILABLE,
        IN_PROGRESS,
        FINISHED,
        ABANDONED,
        MISSING_PARENT,
        MISSING_REQUIREMENT,
        MISSING_COST,
        TOO_MANY_PROGRESS,
        TOO_LOW_UNIVERSITY,
        LOCKED;

    }
}

