/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesFarmland
extends AbstractBlockMinecolonies<MinecoloniesFarmland>
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final String FARMLAND = "farmland";
    public static final String FLOODED_FARMLAND = "floodedfarmland";
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected final VoxelShape shape;
    private final ResourceLocation blockId;
    private final boolean waterLogged;

    public MinecoloniesFarmland(@NotNull String blockName, boolean waterLogged, double height) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56739_).m_60971_((s, g, p) -> true).m_60960_((s, g, p) -> true));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
        this.blockId = new ResourceLocation("minecolonies", blockName);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged)));
        this.shape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)height, (double)16.0);
        this.waterLogged = waterLogged;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState newState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (direction == Direction.UP && !state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 1);
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && this.waterLogged) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, newState, level, pos, neighborPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        if (level == null) {
            return true;
        }
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        return !aboveState.m_280296_();
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return !this.m_49966_().m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_()) ? Blocks.f_50493_.m_49966_() : super.m_5573_(ctx);
    }

    public boolean m_7923_(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return this.shape;
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rng) {
        Block block;
        if (!state.m_60710_((LevelReader)level, pos)) {
            MinecoloniesFarmland.turnToDirt(null, state, (Level)level, pos);
            return;
        }
        int i = (Integer)state.m_61143_((Property)MOISTURE);
        if (!level.m_46758_(pos.m_7494_()) && !MinecoloniesFarmland.isNearWater((LevelReader)level, pos)) {
            if (i > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!MinecoloniesFarmland.shouldMaintainFarmland((BlockGetter)level, pos)) {
                MinecoloniesFarmland.turnToDirt(null, state, (Level)level, pos);
            }
        } else if (i < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        BlockState aboveState = level.m_8055_(pos.m_7494_());
        int growthChance = 4;
        if (level.m_46471_()) {
            growthChance = 12;
        }
        if ((block = aboveState.m_60734_()) instanceof MinecoloniesCropBlock) {
            MinecoloniesCropBlock cropBlock = (MinecoloniesCropBlock)block;
            if (rng.m_188503_(100) <= growthChance) {
                cropBlock.attemptGrow(aboveState, level, pos.m_7494_());
                Network.getNetwork().sendToPosition(new VanillaParticleMessage((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() - 0.5f, (float)pos.m_123343_() + 0.5f, ParticleTypes.f_123748_), new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 16.0, level.m_46472_()));
            }
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        if (level.m_46471_() && level.m_8055_(pos.m_7494_()).m_60734_() instanceof MinecoloniesCropBlock) {
            BoneMealItem.m_40638_((LevelAccessor)level, (BlockPos)pos, (int)1);
        }
        super.m_214162_(state, level, pos, rng);
    }

    public void m_142072_(Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float light) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)Blocks.f_50493_.m_49966_(), (float)light, (Entity)entity)) {
            MinecoloniesFarmland.turnToDirt(entity, state, level, pos);
        }
        super.m_142072_(level, state, pos, entity, light);
    }

    public static void turnToDirt(@Nullable Entity p_270981_, BlockState p_270402_, Level p_270568_, BlockPos p_270551_) {
        BlockState blockstate = MinecoloniesFarmland.m_49897_((BlockState)p_270402_, (BlockState)Blocks.f_50493_.m_49966_(), (LevelAccessor)p_270568_, (BlockPos)p_270551_);
        p_270568_.m_46597_(p_270551_, blockstate);
        p_270568_.m_220407_(GameEvent.f_157792_, p_270551_, GameEvent.Context.m_223719_((Entity)p_270981_, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        BlockState plant = p_279219_.m_8055_(p_279209_.m_7494_());
        BlockState state = p_279219_.m_8055_(p_279209_);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(p_279219_, p_279209_, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader level, BlockPos thisPos) {
        BlockState state = level.m_8055_(thisPos);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = thisPos.m_123341_() - 4; x <= thisPos.m_123341_() + 4; ++x) {
            for (int z = thisPos.m_123343_() - 4; z <= thisPos.m_123343_() + 4; ++z) {
                for (int y = thisPos.m_123342_() - 1; y <= thisPos.m_123342_(); ++y) {
                    blockPos.m_122178_(x, y, z);
                    if (!state.canBeHydrated((BlockGetter)level, thisPos, level.m_6425_((BlockPos)blockPos), (BlockPos)blockPos)) continue;
                    return true;
                }
            }
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)thisPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{MOISTURE, WATERLOGGED});
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.blockId;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false && this.waterLogged ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

