/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.costs;

import com.google.gson.JsonObject;
import com.minecolonies.api.research.IResearchCost;
import com.minecolonies.api.research.ModResearchCosts;
import com.minecolonies.core.util.GsonHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class SimpleItemCost
implements IResearchCost {
    private static final String JSON_PROP_ITEM = "item";
    private static final String JSON_PROP_QUANTITY = "quantity";
    private final Item item;
    private final int count;

    public SimpleItemCost(CompoundTag compound) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("cost-item")));
        this.count = compound.m_128451_("cost-count");
    }

    public SimpleItemCost(JsonObject json) {
        this.item = (Item)ForgeRegistries.ITEMS.getValue(GsonHelper.getAsResourceLocation(json, JSON_PROP_ITEM));
        this.count = Math.max(GsonHelper.m_13824_((JsonObject)json, (String)JSON_PROP_QUANTITY, (int)1), 1);
    }

    @Override
    public ModResearchCosts.ResearchCostEntry getType() {
        return (ModResearchCosts.ResearchCostEntry)ModResearchCosts.simpleItemCost.get();
    }

    @Override
    public List<Item> getItems() {
        return List.of(this.item);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("cost-item", ForgeRegistries.ITEMS.getKey((Object)this.item).toString());
        compound.m_128405_("cost-count", this.count);
        return compound;
    }
}

