/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items;

import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class CheckedNbtKey {
    @NotNull
    public String key;
    @NotNull
    public Set<CheckedNbtKey> children;

    public CheckedNbtKey(@NotNull String key, @NotNull Set<CheckedNbtKey> children) {
        this.key = key;
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckedNbtKey keyObject = (CheckedNbtKey)o;
        return this.key.equals(keyObject.key) && this.children.equals(keyObject.children);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.children);
    }

    public boolean matches(CompoundTag nbt1, CompoundTag nbt2) {
        Tag tag1 = nbt1.m_128423_(this.key);
        Tag tag2 = nbt2.m_128423_(this.key);
        if (tag1 == null || tag2 == null) {
            return tag1 == null == (tag2 == null);
        }
        if (this.children.isEmpty()) {
            return tag1.equals(tag2);
        }
        if (tag1 instanceof CompoundTag && tag2 instanceof CompoundTag) {
            for (CheckedNbtKey key : this.children) {
                if (key.matches((CompoundTag)tag1, (CompoundTag)tag2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

