/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericRecipe
implements IGenericRecipe {
    @Nullable
    private final ResourceLocation id;
    private final List<ItemStack> mainOutputs;
    private final List<ItemStack> additionalOutputs;
    private final List<List<ItemStack>> inputs;
    private final int gridSize;
    private final Block intermediate;
    @Nullable
    private final ResourceLocation lootTable;
    private final EquipmentTypeEntry requiredTool;
    @Nullable
    private final EntityType<?> requiredEntity;
    private final Supplier<List<Component>> restrictions;
    private final int levelSort;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static Builder builder(@NotNull IGenericRecipe recipe) {
        return new Builder(recipe);
    }

    @NotNull
    public static Builder builder(@NotNull IRecipeStorage storage) {
        List<List<ItemStack>> inputs = storage.getCleanedInput().stream().map(input -> Collections.singletonList(GenericRecipe.toItemStack(input))).toList();
        return GenericRecipe.builder().withRecipeId(storage.getRecipeSource()).withOutputs(storage.getPrimaryOutput(), storage.getAlternateOutputs()).withAdditionalOutputs(storage.getCraftingToolsAndSecondaryOutputs()).withInputs(inputs).withGridSize(storage.getGridSize()).withIntermediate(storage.getIntermediate()).withLootTable(storage.getLootTable()).withRequiredTool(storage.getRequiredTool());
    }

    private GenericRecipe(@NotNull Builder builder) {
        this.id = builder.id;
        this.mainOutputs = builder.mainOutputs;
        this.additionalOutputs = builder.additionalOutputs;
        this.inputs = builder.inputs;
        this.gridSize = builder.gridSize;
        this.intermediate = builder.intermediate;
        this.lootTable = builder.lootTable;
        this.requiredTool = builder.requiredTool;
        this.requiredEntity = builder.requiredEntity;
        this.restrictions = builder.restrictions;
        this.levelSort = builder.levelSort;
    }

    @Nullable
    public static IGenericRecipe of(@Nullable Recipe<?> recipe, @NotNull Level world) {
        if (recipe == null) {
            return null;
        }
        List<List<ItemStack>> inputs = GenericRecipe.compactInputs(recipe.m_7527_().stream().map(ingredient -> Arrays.asList(ingredient.m_43908_())).toList());
        Builder builder = GenericRecipe.builder().withRecipeId(recipe.m_6423_()).withOutput(recipe.m_8043_(world.m_9598_())).withAdditionalOutputs(GenericRecipe.calculateSecondaryOutputs(recipe, world)).withInputs(inputs);
        if (recipe instanceof SmeltingRecipe) {
            builder.withGridSize(1).withIntermediate(Blocks.f_50094_);
        } else {
            builder.withGridSize(recipe.m_8004_(2, 2) ? 2 : 3);
        }
        return builder.build();
    }

    @Nullable
    public static IGenericRecipe of(@Nullable IToken<?> recipeToken) {
        if (recipeToken == null) {
            return null;
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(recipeToken);
        return storage == null ? null : GenericRecipe.builder(storage).build();
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeId() {
        return this.id;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.mainOutputs.isEmpty() ? ItemStack.f_41583_ : this.mainOutputs.get(0);
    }

    @Override
    @NotNull
    public List<ItemStack> getAllMultiOutputs() {
        return this.mainOutputs;
    }

    @Override
    @NotNull
    public List<ItemStack> getAdditionalOutputs() {
        return this.additionalOutputs;
    }

    @Override
    @NotNull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    @Override
    @NotNull
    public Supplier<List<Component>> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public int getLevelSort() {
        return this.levelSort;
    }

    @Override
    public Optional<Boolean> matchesOutput(@NotNull OptionalPredicate<ItemStack> predicate) {
        return predicate.test(this.getPrimaryOutput());
    }

    @Override
    public Optional<Boolean> matchesInput(@NotNull OptionalPredicate<ItemStack> predicate) {
        Optional<Boolean> result = Optional.empty();
        for (List<ItemStack> slot : this.inputs) {
            for (ItemStack stack : slot) {
                Optional<Boolean> itemResult = predicate.test(stack);
                if (!itemResult.isPresent()) continue;
                if (!itemResult.get().booleanValue()) {
                    return itemResult;
                }
                result = itemResult;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    @Nullable
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    @Override
    @NotNull
    public EquipmentTypeEntry getRequiredTool() {
        return this.requiredTool;
    }

    @Override
    @Nullable
    public EntityType<?> getRequiredEntity() {
        return this.requiredEntity;
    }

    public String toString() {
        return "GenericRecipe{output=" + String.valueOf(this.getPrimaryOutput()) + "}";
    }

    @NotNull
    private static ItemStack toItemStack(@NotNull ItemStorage input) {
        ItemStack result = input.getItemStack().m_41777_();
        result.m_41764_(input.getAmount());
        return result;
    }

    @NotNull
    private static List<ItemStack> calculateSecondaryOutputs(@NotNull Recipe<?> recipe, @Nullable Level world) {
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            NonNullList inputs = recipe.m_7527_();
            TransientCraftingContainer inv = new TransientCraftingContainer(new AbstractContainerMenu(MenuType.f_39968_, 0){

                @NotNull
                public ItemStack m_7648_(@NotNull Player player, int slot) {
                    return ItemStack.f_41583_;
                }

                public boolean m_6875_(@NotNull Player playerIn) {
                    return false;
                }
            }, 3, 3);
            for (int slot = 0; slot < inputs.size(); ++slot) {
                ItemStack[] stacks = ((Ingredient)inputs.get(slot)).m_43908_();
                if (stacks.length <= 0) continue;
                inv.m_6836_(slot, stacks[0].m_41777_());
            }
            if (craftingRecipe.m_5818_((Container)inv, world)) {
                return craftingRecipe.m_7457_((Container)inv).stream().filter(ItemStackUtils::isNotEmpty).filter(stack -> stack.m_41720_() != ModItems.buildTool.get()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static List<List<ItemStack>> compactInputs(List<List<ItemStack>> inputs) {
        HashMap<IngredientStacks, IngredientStacks> ingredients = new HashMap<IngredientStacks, IngredientStacks>();
        for (List<ItemStack> ingredient : inputs) {
            IngredientStacks newIngredient = new IngredientStacks(ingredient);
            if (!newIngredient.getStacks().isEmpty() && newIngredient.getStacks().get(0).m_41720_() == ModItems.buildTool.get()) continue;
            IngredientStacks existing = (IngredientStacks)ingredients.get(newIngredient);
            if (existing == null) {
                ingredients.put(newIngredient, newIngredient);
                continue;
            }
            existing.merge(newIngredient);
        }
        return ingredients.values().stream().sorted(Comparator.reverseOrder()).map(IngredientStacks::getStacks).collect(Collectors.toList());
    }

    public static class Builder {
        @Nullable
        private ResourceLocation id;
        private List<ItemStack> mainOutputs = List.of();
        private List<ItemStack> additionalOutputs = List.of();
        private List<List<ItemStack>> inputs = List.of();
        private int gridSize = 1;
        private Block intermediate = Blocks.f_50016_;
        private ResourceLocation lootTable = null;
        private EquipmentTypeEntry requiredTool = (EquipmentTypeEntry)ModEquipmentTypes.none.get();
        private EntityType<?> requiredEntity = null;
        private Supplier<List<Component>> restrictions = List::of;
        private int levelSort = -1;

        public Builder() {
        }

        public Builder(@NotNull IGenericRecipe recipe) {
            this.id = recipe.getRecipeId();
            this.mainOutputs = recipe.getAllMultiOutputs();
            this.additionalOutputs = recipe.getAdditionalOutputs();
            this.inputs = recipe.getInputs();
            this.gridSize = recipe.getGridSize();
            this.intermediate = recipe.getIntermediate();
            this.lootTable = recipe.getLootTable();
            this.requiredTool = recipe.getRequiredTool();
            this.requiredEntity = recipe.getRequiredEntity();
            this.restrictions = recipe.getRestrictions();
            this.levelSort = recipe.getLevelSort();
        }

        public Builder withRecipeId(@Nullable ResourceLocation id) {
            this.id = id == null || id.m_135815_().isEmpty() ? null : id;
            return this;
        }

        public Builder withOutput(@NotNull ItemStack output) {
            this.mainOutputs = List.of(output);
            return this;
        }

        public Builder withOutput(@NotNull ItemLike output) {
            return this.withOutput(new ItemStack(output));
        }

        public Builder withOutput(@NotNull ItemLike output, int count) {
            return this.withOutput(new ItemStack(output, count));
        }

        public Builder withOutputs(@NotNull List<ItemStack> multiOutputs) {
            this.mainOutputs = Collections.unmodifiableList(multiOutputs);
            return this;
        }

        public Builder withOutputs(@NotNull ItemStack firstOutput, @NotNull List<ItemStack> otherOutputs) {
            return this.withOutputs(Stream.concat(Stream.of(firstOutput), otherOutputs.stream()).filter(ItemStackUtils::isNotEmpty).toList());
        }

        public Builder withAdditionalOutputs(@NotNull List<ItemStack> additionalOutputs) {
            this.additionalOutputs = Collections.unmodifiableList(additionalOutputs);
            return this;
        }

        public Builder withInputs(@NotNull List<List<ItemStack>> inputs) {
            this.inputs = Collections.unmodifiableList(inputs);
            return this;
        }

        public Builder withGridSize(int gridSize) {
            this.gridSize = gridSize;
            return this;
        }

        public Builder withIntermediate(@NotNull Block intermediate) {
            this.intermediate = intermediate;
            return this;
        }

        public Builder withLootTable(@Nullable ResourceLocation lootTable) {
            this.lootTable = lootTable;
            return this;
        }

        public Builder withRequiredTool(@NotNull EquipmentTypeEntry requiredTool) {
            this.requiredTool = requiredTool;
            return this;
        }

        public Builder withRequiredEntity(@Nullable EntityType<?> requiredEntity) {
            this.requiredEntity = requiredEntity;
            return this;
        }

        public Builder withRestrictions(@NotNull List<Component> restrictions) {
            List<Component> fixedRestrictions = Collections.unmodifiableList(restrictions);
            return this.withRestrictions(() -> fixedRestrictions);
        }

        public Builder withRestrictions(@NotNull Supplier<List<Component>> restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public Builder withLevelSort(int levelSort) {
            this.levelSort = levelSort;
            return this;
        }

        @NotNull
        public IGenericRecipe build() {
            return new GenericRecipe(this);
        }
    }

    private static class IngredientStacks
    implements Comparable<IngredientStacks> {
        private final List<ItemStack> stacks;
        private final Set<Item> items;

        public IngredientStacks(List<ItemStack> ingredient) {
            this.stacks = ingredient.stream().filter(stack -> !stack.m_41619_()).map(ItemStack::m_41777_).collect(Collectors.toList());
            this.items = this.stacks.stream().map(ItemStack::m_41720_).collect(Collectors.toSet());
        }

        @NotNull
        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public int getCount() {
            return this.stacks.isEmpty() ? 0 : this.stacks.get(0).m_41613_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IngredientStacks that = (IngredientStacks)o;
            return this.items.equals(that.items);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public int compareTo(@NotNull IngredientStacks o) {
            int diff = this.getCount() - o.getCount();
            if (diff != 0) {
                return diff;
            }
            diff = this.stacks.size() - o.stacks.size();
            if (diff != 0) {
                return diff;
            }
            return this.hashCode() - o.hashCode();
        }

        public void merge(@NotNull IngredientStacks other) {
            for (int i = 0; i < this.stacks.size(); ++i) {
                this.stacks.get(i).m_41769_(other.stacks.get(i).m_41613_());
            }
        }

        public String toString() {
            return "IngredientStacks{stacks=" + String.valueOf(this.stacks) + ", items=" + String.valueOf(this.items) + "}";
        }
    }
}

