/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.deliveryman;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Delivery
extends AbstractDeliverymanRequestable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Delivery.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_START = "Start";
    private static final String NBT_TARGET = "Target";
    private static final String NBT_STACK = "Stack";
    @NotNull
    private final ILocation start;
    @NotNull
    private final ILocation target;
    @NotNull
    private final ItemStack stack;

    public Delivery(@NotNull ILocation start, @NotNull ILocation target, @NotNull ItemStack stack, int priority) {
        super(priority);
        this.start = start;
        this.target = target;
        this.stack = stack;
    }

    @NotNull
    public static CompoundTag serialize(@NotNull IFactoryController controller, Delivery delivery) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_START, (Tag)controller.serialize(delivery.getStart()));
        compound.m_128365_(NBT_TARGET, (Tag)controller.serialize(delivery.getTarget()));
        compound.m_128365_(NBT_STACK, (Tag)delivery.getStack().serializeNBT());
        compound.m_128365_("Priority", (Tag)controller.serialize(delivery.getPriority()));
        return compound;
    }

    @NotNull
    public static Delivery deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag compound) {
        ILocation start = (ILocation)controller.deserialize(compound.m_128469_(NBT_START));
        ILocation target = (ILocation)controller.deserialize(compound.m_128469_(NBT_TARGET));
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.m_128469_(NBT_STACK));
        int priority = (Integer)controller.deserialize(compound.m_128469_("Priority"));
        return new Delivery(start, target, stack, priority);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, Delivery input) {
        controller.serialize(buffer, input.getStart());
        controller.serialize(buffer, input.getTarget());
        buffer.m_130055_(input.getStack());
        buffer.writeInt(input.getPriority());
    }

    public static Delivery deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        ILocation start = (ILocation)controller.deserialize(buffer);
        ILocation target = (ILocation)controller.deserialize(buffer);
        ItemStack stack = buffer.m_130267_();
        int priority = buffer.readInt();
        return new Delivery(start, target, stack, priority);
    }

    @NotNull
    public ILocation getStart() {
        return this.start;
    }

    @NotNull
    public ILocation getTarget() {
        return this.target;
    }

    @NotNull
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Delivery)) {
            return false;
        }
        Delivery delivery = (Delivery)o;
        if (!this.getStart().equals(delivery.getStart())) {
            return false;
        }
        if (!this.getTarget().equals(delivery.getTarget())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), delivery.getStack());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getStart().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        result = 31 * result + this.getStack().hashCode();
        return result;
    }

    public String toString() {
        return "Delivery{start=" + String.valueOf(this.start) + ", target=" + String.valueOf(this.target) + ", stack=" + String.valueOf(this.stack) + ", priority=" + this.priority + "}";
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

