/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColonyBlock<B extends AbstractColonyBlock<B>>
extends AbstractBlockMinecolonies<B>
implements IBuilderUndestroyable,
ITickableBlockMinecolonies {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final float HARDNESS = 10.0f;
    public static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final String name;
    private long lastBreakTickWarn = 0L;

    public AbstractColonyBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(10.0f, Float.POSITIVE_INFINITY).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        IBuilding building = IColonyManager.getInstance().getBuilding(player.m_9236_(), pos);
        if (building != null && !building.getChildren().isEmpty() && player.m_9236_().m_46467_() - this.lastBreakTickWarn < 100L) {
            this.lastBreakTickWarn = player.m_9236_().m_46467_();
            MessageUtils.format("block.minecolonies.blockhut.breakwarn.children", new Object[0]).sendTo(player);
        }
        return ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().pvp_mode.get() != false ? 0.025f : 0.1f) / 30.0f;
    }

    public AbstractColonyBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public abstract String getHutName();

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        TileEntityColonyBuilding building = (TileEntityColonyBuilding)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()).m_155264_(blockPos, blockState);
        building.registryName = this.getBuildingEntry().getRegistryName();
        return building;
    }

    public void m_6810_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newBlockState, boolean p_60519_) {
        BlockEntity tileentity = level.m_7702_(pos);
        if (tileentity instanceof AbstractTileEntityColonyBuilding) {
            AbstractTileEntityColonyBuilding tileEntityColonyBuilding = (AbstractTileEntityColonyBuilding)tileentity;
            InventoryUtils.dropItemHandler((IItemHandler)tileEntityColonyBuilding.getInventory(), level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        super.m_6810_(blockState, level, pos, newBlockState, p_60519_);
    }

    public abstract BuildingEntry getBuildingEntry();

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            TileEntityColonyBuilding te;
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.FAIL;
            }
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), pos);
            LevelChunk chunk = worldIn.m_46745_(pos);
            BlockEntity entity = worldIn.m_7702_(pos);
            if (entity instanceof TileEntityColonyBuilding && (te = (TileEntityColonyBuilding)entity).getPositionedTags().containsKey(BlockPos.f_121853_) && te.getPositionedTags().get(BlockPos.f_121853_).contains("deactivated")) {
                if (building == null && ColonyUtils.getOwningColony(chunk) == 0) {
                    MessageUtils.format("com.minecolonies.coremod.building.missingcolony", new Object[0]).sendTo(player);
                    return InteractionResult.FAIL;
                }
                if (building == null && ColonyUtils.getAllClaimingBuildings(chunk).values().stream().flatMap(Collection::stream).noneMatch(p -> p.equals((Object)pos))) {
                    IColonyManager.getInstance().openReactivationWindow(pos);
                    return InteractionResult.SUCCESS;
                }
            }
            if (building == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            if (building.getColony() == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nocolony", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            if (!building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            building.openGui(player.m_6144_());
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        @NotNull Direction facing = context.m_43723_() == null ? Direction.NORTH : Direction.m_122364_((double)context.m_43723_().m_146908_());
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            IColony colony;
            @NotNull TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (hut.getBuildingName() != this.getBuildingEntry().getRegistryName()) {
                hut.registryName = this.getBuildingEntry().getRegistryName();
            }
            if ((colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition())) != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", this.getHutName());
    }

    @Override
    public B registerBlock(IForgeRegistry<Block> registry) {
        registry.register(this.getRegistryName(), (Object)this);
        return (B)this;
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(this.getRegistryName(), (Object)new ItemBlockHut(this, properties));
    }
}

