/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.CheckBox;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.api.util.ItemStorage;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.client.gui.util.InputFilters;
import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.network.messages.FillTopPlaceholderMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private static final String CHEST_WARNING = "chestwarning";
    private final Map<ItemStorage, ItemPositionsStorage> allResources = new HashMap<ItemStorage, ItemPositionsStorage>();
    private final Object2IntMap<EntityType> entities = new Object2IntOpenHashMap();
    public static final int WHITE = Color.getByName((String)"white", (int)0);
    private final ScanToolData data;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final TextField slotId;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;
    private int updateFilterTimer = 0;
    private ArrayList<ItemStorage> visibleResourcesSortedList = new ArrayList();

    public WindowScan(@NotNull ScanToolData data) {
        super("structurize:gui/windowscantool.xml");
        this.data = data;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("showvisisble", this::updateResources);
        this.registerButton("showhidden", this::updateResources);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.registerButton("fillplaceholders", this::showFillplaceholderUI);
        this.registerButton("cancelfill", this::cancelFill);
        this.registerButton("fill", this::fillPlaceholders);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("removefiltered", this::removeFilteredBlock);
        this.pos1x = (TextField)this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = (TextField)this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = (TextField)this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = (TextField)this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = (TextField)this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = (TextField)this.findPaneOfTypeByID("pos2z", TextField.class);
        this.slotId = (TextField)this.findPaneOfTypeByID("slot", TextField.class);
        this.pos1x.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos1y.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos1z.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2x.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2y.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2z.setFilter(InputFilters.ONLY_NUMBERS);
        this.slotId.setFilter(InputFilters.ONLY_NUMBERS);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = (ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showFillplaceholderUI() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(true);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(false);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(false);
    }

    private void cancelFill() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(false);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(true);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(true);
    }

    private void fillPlaceholders() {
        try {
            double yStretch = Double.parseDouble(((TextField)this.findPaneOfTypeByID("ystretch", TextField.class)).getText());
            double circleRadiusMult = Double.parseDouble(((TextField)this.findPaneOfTypeByID("radius", TextField.class)).getText());
            int heightOffset = Integer.parseInt(((TextField)this.findPaneOfTypeByID("heightoffset", TextField.class)).getText());
            int minDistToBlocks = Integer.parseInt(((TextField)this.findPaneOfTypeByID("blockdist", TextField.class)).getText());
            Network.getNetwork().sendToServer(new FillTopPlaceholderMessage(this.data.getCurrentSlotData().getBox().getPos1(), this.data.getCurrentSlotData().getBox().getPos2(), yStretch, circleRadiusMult, heightOffset, minDistToBlocks));
        }
        catch (Exception e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Invalid Number"), false);
        }
        this.close();
    }

    private void showResClicked() {
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).show();
        ((Button)this.findPaneOfTypeByID("showRes", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("removefiltered", Button.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class)).setChecked(true);
        ((CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class)).setChecked(true);
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane((Pane)button);
        EntityType entity = (EntityType)new ArrayList(this.entities.keySet()).get(row);
        Network.getNetwork().sendToServer(new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), EntityType.m_20613_((EntityType)entity)));
        this.entities.removeInt((Object)entity);
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemPositionsStorage toRemove = this.allResources.get(this.visibleResourcesSortedList.get(row));
        Network.getNetwork().sendToServer(new RemoveBlockMessage(toRemove));
        this.removeAllNeededResource(toRemove.itemStorage.getItemStack());
        this.updateResourceList();
    }

    private Set<ItemStorage> getResources() {
        return this.allResources.keySet();
    }

    private void removeFilteredBlock() {
        Network.getNetwork().sendToServer(new RemoveBlockMessage(this.allResources.values().stream().toList()));
        this.allResources.clear();
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        new WindowReplaceBlock(this, this.allResources.get(this.visibleResourcesSortedList.get(row))).open();
    }

    public void onOpened() {
        super.onOpened();
        if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.loadSlot();
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> {
            this.filter = ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).getText();
            this.updateFilterTimer = 10;
        });
        this.updateFilterTimer = 30;
    }

    public void onClosed() {
        if (RenderingCache.getBoxPreviewData("scan") != null) {
            this.updateBounds();
        }
        super.onClosed();
    }

    public void onUpdate() {
        if (this.updateFilterTimer > 0) {
            --this.updateFilterTimer;
            if (this.updateFilterTimer == 0) {
                this.updateResources();
            }
        }
        super.onUpdate();
    }

    private void discardClicked() {
        RenderingCache.removeBox("scan");
        Iterator<Map.Entry<String, BoxPreviewData>> iterator = RenderingCache.boxRenderingCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BoxPreviewData> entry = iterator.next();
            if (!entry.getKey().contains("clickedResource")) continue;
            iterator.remove();
        }
        this.close();
    }

    private void confirmClicked() {
        this.updateBounds();
        ScanToolData.Slot slot = this.data.getCurrentSlotData();
        Network.getNetwork().sendToServer(new ScanOnServerMessage(slot, true));
        RenderingCache.removeBox("scan");
        this.close();
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch >= 48 && ch <= 57) {
            this.updateBounds();
            this.data.moveTo(ch - 48);
            this.loadSlot();
            this.updateResources();
            return true;
        }
        return super.onUnhandledKeyTyped(ch, key);
    }

    private void loadSlot() {
        BlockEntity tile;
        this.slotId.setText(String.valueOf(this.data.getCurrentSlotId()));
        ScanToolData.Slot slot = this.data.getCurrentSlotData();
        this.pos1x.setText(String.valueOf(slot.getBox().getPos1().m_123341_()));
        this.pos1y.setText(String.valueOf(slot.getBox().getPos1().m_123342_()));
        this.pos1z.setText(String.valueOf(slot.getBox().getPos1().m_123343_()));
        this.pos2x.setText(String.valueOf(slot.getBox().getPos2().m_123341_()));
        this.pos2y.setText(String.valueOf(slot.getBox().getPos2().m_123342_()));
        this.pos2z.setText(String.valueOf(slot.getBox().getPos2().m_123343_()));
        RenderingCache.queue("scan", slot.getBox());
        ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText("");
        if (!slot.getName().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(slot.getName());
        } else if (slot.getBox().getAnchor().isPresent() && (tile = Minecraft.m_91087_().f_91074_.m_9236_().m_7702_(slot.getBox().getAnchor().get())) instanceof IBlueprintDataProviderBE && !((IBlueprintDataProviderBE)tile).getSchematicName().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(((IBlueprintDataProviderBE)tile).getSchematicName());
        }
    }

    private void updateBounds() {
        BlockPos pos2;
        BlockPos pos1;
        BlockPos def = Minecraft.m_91087_().f_91074_.m_20183_();
        try {
            int x1 = this.pos1x.getText().isEmpty() ? def.m_123341_() : Integer.parseInt(this.pos1x.getText());
            int y1 = this.pos1y.getText().isEmpty() ? def.m_123342_() : Integer.parseInt(this.pos1y.getText());
            int z1 = this.pos1z.getText().isEmpty() ? def.m_123343_() : Integer.parseInt(this.pos1z.getText());
            pos1 = new BlockPos(x1, y1, z1);
            int x2 = this.pos2x.getText().isEmpty() ? def.m_123341_() : Integer.parseInt(this.pos2x.getText());
            int y2 = this.pos2y.getText().isEmpty() ? def.m_123342_() : Integer.parseInt(this.pos2y.getText());
            int z2 = this.pos2z.getText().isEmpty() ? def.m_123343_() : Integer.parseInt(this.pos2z.getText());
            pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237113_((String)"Invalid Number"), false);
            return;
        }
        String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
        ScanToolData.Slot slot = this.data.getCurrentSlotData();
        this.data.setCurrentSlotData(new ScanToolData.Slot(name, new BoxPreviewData(pos1, pos2, slot.getBox().getAnchor())));
        RenderingCache.queue("scan", slot.getBox());
        Network.getNetwork().sendToServer(new UpdateScanToolMessage(this.data));
    }

    private void updateResources() {
        this.updateFilterTimer = 0;
        this.updateBounds();
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        this.allResources.clear();
        this.entities.clear();
        if (this.findPaneByID("showRes").isVisible()) {
            return;
        }
        ScanToolData.Slot slot = this.data.getCurrentSlotData();
        List list = world.m_45976_(Entity.class, new AABB(slot.getBox().getPos1(), slot.getBox().getPos2()));
        for (Entity entity : list) {
            if (this.entities.containsKey((Object)entity.m_7755_().getString()) || !entity.m_6095_().m_20584_() && !entity.m_6095_().equals(EntityType.f_20464_) || !this.filter.isEmpty() && !entity.m_7755_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
            this.entities.mergeInt((Object)entity.m_6095_(), 1, Integer::sum);
        }
        AABB box = new AABB(slot.getBox().getPos1(), slot.getBox().getPos2());
        BlockPos.MutableBlockPos here = new BlockPos.MutableBlockPos();
        int minX = Math.min(slot.getBox().getPos1().m_123341_(), slot.getBox().getPos2().m_123341_());
        int minY = Math.min(slot.getBox().getPos1().m_123342_(), slot.getBox().getPos2().m_123342_());
        int minZ = Math.min(slot.getBox().getPos1().m_123343_(), slot.getBox().getPos2().m_123343_());
        int maxX = Math.max(slot.getBox().getPos1().m_123341_(), slot.getBox().getPos2().m_123341_());
        int maxY = Math.max(slot.getBox().getPos1().m_123342_(), slot.getBox().getPos2().m_123342_());
        int maxZ = Math.max(slot.getBox().getPos1().m_123343_(), slot.getBox().getPos2().m_123343_());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block;
                    here.m_122178_(x, y, z);
                    BlockState blockState = world.m_8055_((BlockPos)here);
                    BlockEntity tileEntity = world.m_7702_((BlockPos)here);
                    boolean visible = false;
                    for (Direction dir : Direction.values()) {
                        BlockPos offsetPos = here.m_121945_(dir);
                        if (box.m_82390_(offsetPos.m_252807_()) && (!world.m_8055_(offsetPos).m_60815_() || world.m_8055_(offsetPos).m_60808_((BlockGetter)world, offsetPos) == Shapes.m_83144_())) continue;
                        visible = true;
                        break;
                    }
                    if ((block = blockState.m_60734_()) == Blocks.f_50016_ || block == Blocks.f_50626_ || block == Blocks.f_50627_) {
                        this.addNeededResource(new ItemStack((ItemLike)Blocks.f_50016_, 1), visible, (BlockPos)here);
                        continue;
                    }
                    IPlacementHandler handler = PlacementHandlers.getHandler((Level)world, BlockPos.f_121853_, blockState);
                    List<ItemStack> itemList = handler.getRequiredItems((Level)world, (BlockPos)here, blockState, tileEntity == null ? null : tileEntity.m_187480_(), true);
                    for (ItemStack stack : itemList) {
                        this.addNeededResource(stack, visible, (BlockPos)here);
                    }
                }
            }
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, boolean visible, BlockPos pos) {
        if (res == null) {
            return;
        }
        CheckBox visibleCheckBox = (CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class);
        CheckBox hiddenCheckBox = (CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class);
        if (visible && !visibleCheckBox.isChecked()) {
            return;
        }
        if (!visible && !hiddenCheckBox.isChecked()) {
            return;
        }
        if (this.filter.isEmpty() || res.m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.m_41786_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            ItemStorage stackToStore = new ItemStorage(res, 1, true, false);
            ItemPositionsStorage existing = this.allResources.computeIfAbsent(stackToStore, ItemPositionsStorage::new);
            existing.addItemAndPos(stackToStore, pos.m_7949_());
        }
    }

    public void removeAllNeededResource(ItemStack res) {
        ItemStorage storage = new ItemStorage(res, 1, true, false);
        this.allResources.remove(storage);
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList tempEntities = new ArrayList(this.entities.keySet());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempEntities.size();
            }

            public void updateElement(int index, Pane rowPane) {
                EntityType entity = (EntityType)tempEntities.get(index);
                ItemStack entityIcon = entity.m_20615_((Level)Minecraft.m_91087_().f_91073_).m_142340_();
                if (entity == EntityType.f_147033_) {
                    entityIcon = new ItemStack((ItemLike)Items.f_151063_);
                } else if (entity == EntityType.f_20462_) {
                    entityIcon = new ItemStack((ItemLike)Items.f_42617_);
                } else if (entity == EntityType.f_20469_) {
                    entityIcon = new ItemStack((ItemLike)Items.f_42449_);
                }
                ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.m_237113_((String)Integer.toString(WindowScan.this.entities.getInt((Object)entity))));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(entityIcon);
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(entity.m_20676_());
                if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeEntity", Button.class)).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        ((Text)this.window.findPaneOfTypeByID(CHEST_WARNING, Text.class)).show();
        this.visibleResourcesSortedList = new ArrayList<ItemStorage>(this.getResources());
        this.visibleResourcesSortedList.sort(Comparator.comparing(s1 -> s1.getItemStack().m_41786_().getString()));
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowScan.this.visibleResourcesSortedList.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStorage resource = WindowScan.this.visibleResourcesSortedList.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().m_41786_());
                quantityLabel.setText(Component.m_237113_((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack copy = resource.getItemStack().m_41777_();
                copy.m_41764_(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(copy);
                if (!Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).hide();
                    ((Button)rowPane.findPaneOfTypeByID("replaceBlock", Button.class)).hide();
                }
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).getModifiedItemStackTooltip());
                tooltip.add(Component.m_237115_((String)"com.ldtteam.structurize.gui.scantool.item.tooltipclick"));
                new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane(rowPane.findPaneOfTypeByID("showBlock", Button.class)).build().setTextOld(tooltip);
                ((Button)rowPane.findPaneOfTypeByID("showBlock", Button.class)).setHandler(b -> this.doHighLightBlocks(b, resource));
            }

            private void doHighLightBlocks(Button button, ItemStorage block) {
                ItemPositionsStorage itemPositionsStorage = WindowScan.this.allResources.get(block);
                for (BlockPos position : itemPositionsStorage.positions) {
                    BoxPreviewData previewData = new BoxPreviewData(position, position, Optional.empty());
                    previewData.setExpireTime(30);
                    RenderingCache.queue("clickedResource" + position.m_123344_(), previewData);
                }
                WindowScan.this.window.close();
            }
        });
    }
}

